//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID3bc8882a_b5d4_4c9f_8f5a_31cd5d23d95b
{
    public class Class_BrightContrast : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Contrast = 2,
            Gamma = 3,
            mulColorR = 4,
            mulColorG = 5,
            mulColorB = 6,
            mulColorA = 7,
            Bright = 8
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var Contrast = inputs[(int)InputId.Contrast].Eval(context).Value;
            var Gamma = inputs[(int)InputId.Gamma].Eval(context).Value;
            var mulColorR = inputs[(int)InputId.mulColorR].Eval(context).Value;
            var mulColorG = inputs[(int)InputId.mulColorG].Eval(context).Value;
            var mulColorB = inputs[(int)InputId.mulColorB].Eval(context).Value;
            var mulColorA = inputs[(int)InputId.mulColorA].Eval(context).Value;
            var mulColor = new Color4(mulColorR, mulColorG, mulColorB, mulColorA);
            var Bright = inputs[(int)InputId.Bright].Eval(context).Value;
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Contrast").AsScalar().Set(Contrast);
                    _effect.GetVariableByName("Gamma").AsScalar().Set(Gamma);
                    _effect.GetVariableByName("mulColor").AsVector().Set(new Vector4(mulColorR, mulColorG, mulColorB, mulColorA));
                    _effect.GetVariableByName("Bright").AsScalar().Set(Bright);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

