//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDd7a9871f_34fa_410f_9677_b94084324eca
{
    public class Class_EnergiePhysik : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            Angle = 2,
            SampleCount = 3,
            Strength = 4,
            Wipe = 5,
            Size = 6
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return context;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var SampleCount = inputs[(int)InputId.SampleCount].Eval(context).Value;
            var Strength = inputs[(int)InputId.Strength].Eval(context).Value;
            var Wipe = inputs[(int)InputId.Wipe].Eval(context).Value;
            var Size = inputs[(int)InputId.Size].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 1));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("SampleCount").AsScalar().Set(SampleCount);
                    _effect.GetVariableByName("Strength").AsScalar().Set(Strength);
                    _effect.GetVariableByName("Wipe").AsScalar().Set(Wipe);
                    _effect.GetVariableByName("Size").AsScalar().Set(Size);
                //<<< _setup


                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

