//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID1dafae7b_cfcd_4fb1_bb13_6aa71effe76b
{
    public class Class_BeatTapper : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            TapTrigger = 0,
            ResyncTrigger = 1,
            ResetTotalTrigger = 2,
            OffsetSync = 3,
            RoundBPMTrigger = 4,
            ChangeTempo = 5
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Fragment = 0,
            BPM = 1,
            SyncedTime = 2
        }
        //<<< _outputids
                
                
        /*
            This code seems much too complicated, but getting flexible and conherent beat detection
            seems to be much trickier, than I though. After playing with a couple of methods, it 
            finally settled on keeping a "fragmentTime" counter wrapping over the _beatDuration.
            The fragmentTime is than additionaly offset with. Maybe there is a method that works
            without the separate offset-variable, but since I wanted to have damped transition is
            syncing (no jumps please), keeping both seperated seemed to work.
        */
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var TapTrigger = inputs[(int)InputId.TapTrigger].Eval(context).Value;
            var ResyncTrigger = inputs[(int)InputId.ResyncTrigger].Eval(context).Value;
            var ResetTotalTrigger = inputs[(int)InputId.ResetTotalTrigger].Eval(context).Value;
            var OffsetSync = inputs[(int)InputId.OffsetSync].Eval(context).Value;
            var RoundBPMTrigger = inputs[(int)InputId.RoundBPMTrigger].Eval(context).Value;
            var ChangeTempo = inputs[(int)InputId.ChangeTempo].Eval(context).Value;
            //<<< _params
            
            var time = context.GlobalTime;          
            var timeDelta =  time - _lastTime;


            if(time != _lastTime) 
            {            
                _lastTime = time;
                _beatDuration += ChangeTempo;
                var barDuration = _dampedBeatDuration * BeatsPerBar;
                                                                      
                // Detect Flanks
                bool justResynced = (ResyncTrigger - _oldResyncTrigger > 0.5f);
                _oldResyncTrigger =ResyncTrigger;                
                
                bool justTapped = (TapTrigger - _oldTapTrigger > 0.5f);
                if(justTapped) {
                    _resyncTime = 0;    // disable resync-retiming when tapping
                }
                justTapped |= justResynced; //  treat resyncs as triggers
                _oldTapTrigger =TapTrigger;
    
                
                if(ResetTotalTrigger > 0.5f) {
                    _barCounter = 0;
                    _dampedBeatDuration=120;
                }
                
                if(RoundBPMTrigger > 0.5f) {
                    Logger.Info("Just Tapped");
                
                    var BPM = (float)(60.0f / _beatDuration);
                    var roundedBPM = (float)Math.Round(BPM);
                    _beatDuration = 60 / roundedBPM;
                }
                
                // Update tap
                if(justTapped) 
                {                
                    AddTapAndShiftTimings(context.GlobalTime);
                }                   
                    
                if(justResynced) 
                {
                    var measureDuration = _beatDuration * BeatsPerBar;
                    var timeInMeasure = time - _barStartTime;
                    if(timeInMeasure > measureDuration/2) {
                        timeInMeasure -= measureDuration;
                    }
                    if(Math.Abs(timeInMeasure) > measureDuration / 16) {
                        // Reset measure-timing
                        _tappedBarStartTime  = _barStartTime = time;
                    }
                    else {
                        // Sliding is sufficient
                        _tappedBarStartTime = time;
                    }
                    
                    // stretch _beatTime
                    if(_resyncTime != 0) {
                        var timeSinceResync = time - _resyncTime;

                        var measureCount = timeSinceResync / measureDuration;
                        var measureCountInt = Math.Round(measureCount); 
                        Logger.Info("MeasureCount:" + measureCount);
                        var mod = measureCount - measureCountInt;
                        Logger.Info(" Mod:"+ mod);
                        if( Math.Abs(mod) < 0.1 && measureCountInt > 0) {
                            var measureFragment = mod * measureDuration / measureCountInt;
                            var beatShift=  measureFragment / BeatsPerBar;
                            _beatDuration += beatShift; 
                            Logger.Info("Resync-Offset:" + mod + " shift:" + beatShift);
                        }
                    }
                    _resyncTime = time;                
                }
                
                // Smooth offset and beatduration to avoid jumps
                _dampedBeatDuration = Lerp(_dampedBeatDuration, _beatDuration, 0.05f);

                // Slide start-time to match last beat-trigger
                var timeInBar = time - _barStartTime;
                var _tappedTimeInBar = time - _tappedBarStartTime;
                var tappedBeatTime = (_tappedTimeInBar / _dampedBeatDuration) % 1f ;
                var beatTime = (timeInBar / _dampedBeatDuration ) % 1f ;
                
                _barStartTime += (beatTime < tappedBeatTime) ? -0.01f : 0.01f;

                // Check for next bar               
                if(timeInBar > barDuration) {
                    _barCounter++;
                    //_barStartTime = time - (_timeInBar - barDuration);
                    _barStartTime += barDuration;
                    timeInBar -= barDuration;
                }
                
                _tappedBarStartTime = time +  (_tappedBarStartTime - time) % barDuration;
                _barProgress = (float)(timeInBar / barDuration);
            }            
                       
            switch(outputIdx) 
            {
                case (int)OutputId.Fragment:                                 
                    context.Value = 1 - _barProgress;                    
                    break;
                    
                case (int)OutputId.BPM:
                    context.Value =  (float)(60.0f/_dampedBeatDuration);
                    break;
                    
                case (int)OutputId.SyncedTime:
                    context.Value = (float)(_barCounter + _barProgress) * 4 + OffsetSync;
                    break;
                    
            }            
            
            return context;
        }
        
        

        
        private void AddTapAndShiftTimings(double time) 
        {
            var newSeriesStarted = _tapTimes.Count == 0 || Math.Abs(time - _tapTimes.Last()) > 4* _beatDuration;
            
            if(newSeriesStarted) {
                //Logger.Info("New Tap Series started");
                _tapTimes.Clear();
            }
            
            _tapTimes.Add( time );
            
            var taps = _tapTimes.Count;            
            if (taps < 4)
                return;
            
            
            var avgBeatDuration = (_tapTimes.Last() - _tapTimes.First()) / (taps - 1);
            
            var sum = 0.0;
            var goodCount = 0.0;
            var goodSum = 0.0;
            var lastT = 0.0;
            
            foreach(var t in _tapTimes) 
            {
                var dt = t - lastT ;
                lastT = t;
                
                var matchRate = ( dt / avgBeatDuration) ;
                //Logger.Info("MatchRate:" + matchRate);
                if(matchRate < 0.7f || matchRate > 1.2f) {
                    continue;
                }
                goodSum += dt;
                goodCount++;
            }
            
            if(goodCount > 3) {            
                _beatDuration = goodSum / goodCount;
            }
            Logger.Info(" " + goodCount + "/" + taps);
            
            _tappedBarStartTime = time - _beatDuration;  
        }
        
        
        private double Lerp(double a, double b, float t) {
            return a * (1-t) + b * t; 
        }
        
        
        private float _beatTime = 0;
        private float _tapTime = 0;
        private float _resyncTime = 0;
        
        double _barStartTime = 0;
        
        double _beatDuration=0.5;
        double _dampedBeatDuration= 0.5;
        double _tappedBarStartTime = 0;
        
        int _barCounter = 0;
        
        private const float BeatsPerBar =16;
        float _barProgress;
        //double _timeInBar;
        double _lastTime;
        
        //float _lastDefaultBpm;
        float _oldTapTrigger;
        float _oldResyncTrigger;
        
        List<double> _tapTimes = new List<double>();
    }
}

