//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDa5278258_566e_4c60_b291_448761935c41
{
    public class Class_AnimeSplitLines : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            iTime = 2,
            Angle = 3,
            Color0R = 4,
            Color0G = 5,
            Color0B = 6,
            Color0A = 7,
            ColorMix = 8,
            SizeX = 9,
            SizeY = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
            var iTime = inputs[(int)InputId.iTime].Eval(context).Value;
            var Angle = inputs[(int)InputId.Angle].Eval(context).Value;
            var Color0R = inputs[(int)InputId.Color0R].Eval(context).Value;
            var Color0G = inputs[(int)InputId.Color0G].Eval(context).Value;
            var Color0B = inputs[(int)InputId.Color0B].Eval(context).Value;
            var Color0A = inputs[(int)InputId.Color0A].Eval(context).Value;
            var Color0 = new Color4(Color0R, Color0G, Color0B, Color0A);
            var ColorMix = inputs[(int)InputId.ColorMix].Eval(context).Value;
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            //<<< _params
            
            if(Image == null)
                return context;


            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("iTime").AsScalar().Set(iTime);
                    _effect.GetVariableByName("Angle").AsScalar().Set(Angle);
                    _effect.GetVariableByName("Color0").AsVector().Set(new Vector4(Color0R, Color0G, Color0B, Color0A));
                    _effect.GetVariableByName("ColorMix").AsScalar().Set(ColorMix);
                    _effect.GetVariableByName("Size").AsVector().Set(new Vector2(SizeX, SizeY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

