//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDed5ee8bb_615f_4f98_ba8e_3961b5116859
{
    public class Class_AddPixelNoise : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Seed = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            Image = 6
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
                var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
                var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
                var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
                var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
                var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
                var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return;
                //<<< __params

                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));
            
            /*
                var blendStateDescription = new BlendStateDescription();
                blendStateDescription.RenderTarget[0].IsBlendEnabled = true;
                blendStateDescription.RenderTarget[0].SourceBlend = BlendOption.SourceAlpha;
                blendStateDescription.RenderTarget[0].DestinationBlend = BlendOption.InverseSourceAlpha;
                blendStateDescription.RenderTarget[0].BlendOperation = BlendOperation.Add;
                blendStateDescription.RenderTarget[0].SourceAlphaBlend = BlendOption.SourceAlpha;
                blendStateDescription.RenderTarget[0].DestinationAlphaBlend = BlendOption.InverseSourceAlpha;
                blendStateDescription.RenderTarget[0].AlphaBlendOperation = BlendOperation.Add;
                blendStateDescription.RenderTarget[0].RenderTargetWriteMask = ColorWriteMaskFlags.All;
                blendStateDescription.AlphaToCoverageEnable = false;
                */
                /*
                blendStateDescription.RenderTarget[0].IsBlendEnabled = true;
                blendStateDescription.RenderTarget[0].SourceBlend = BlendOption.SourceAlpha;
                blendStateDescription.RenderTarget[0].DestinationBlend = BlendOption.InverseSourceAlpha;
                blendStateDescription.RenderTarget[0].BlendOperation = BlendOperation.Add;
                blendStateDescription.RenderTarget[0].SourceAlphaBlend = BlendOption.SourceAlpha;
                blendStateDescription.RenderTarget[0].DestinationAlphaBlend = BlendOption.DestinationAlpha;
                blendStateDescription.RenderTarget[0].AlphaBlendOperation = BlendOperation.Add;
                blendStateDescription.RenderTarget[0].RenderTargetWriteMask = ColorWriteMaskFlags.All;
                blendStateDescription.AlphaToCoverageEnable = false;
                */


                //_blendState = new BlendState(D3DDevice.Device, blendStateDescription);   
                
                

                //>>> _setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Seed").AsScalar().Set(Seed);
                    _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB, ColorA));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

