const unsigned char vid_palette[16]={ 0x0f,0x16,0x27,0x38,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30,0x0f,0x00,0x10,0x30 };


#define END_TX			12
#define END_TY			24
#define VID_MAX_SCALE	64

#pragma bssseg (push,"ZEROPAGE")
#pragma dataseg(push,"ZEROPAGE")

signed int vid_sx;
signed int vid_sy;
signed int vid_scale;

#pragma dataseg(pop);
#pragma bssseg (pop);



void e_vid(void)
{
	unsigned char i,chr,tile,pcnt;
	unsigned char bright_spr,bright_bg,delay1;
	unsigned char sxa[8],sya[8];
	unsigned int frame;

	oam_clear_fast();
	oam_size(1);		//8x16 mode

	chr=CHR_FONT;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg (vid_palette);
	pal_spr(vid_palette);
	
	pal_bright(0);
	
	scroll(0,0);
	
	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);
	
	for(i=0;i<8;++i)
	{
		vram_adr(NTADR_A(END_TX+i,END_TY+0));
		vram_put(0xf0+i);
		vram_adr(NTADR_A(END_TX+i,END_TY+1));
		vram_put(0xf8+i);
	}
	
	frame=0;
	bright_spr=0;
	bright_bg=0;
	delay1=16;
	vid_scale=32;
	pcnt=0;
	
	ppu_on_all();
	
	while(1)
	{
		chr=CHR_VID+((frame&1)?2:0);
		
		mmc3_chr_bank(chr+0,2);
		mmc3_chr_bank(chr+1,3);
	
		pal_spr_bright(bright_spr);

		vid_sx=-32;
		
		for(_i=0;_i<8;++_i)
		{
			sxa[_i]=128+vid_sx*vid_scale/VID_MAX_SCALE;
			vid_sx+=8;
		}
		
		vid_sy=-64;
		
		for(_i=0;_i<8;++_i)
		{
			sya[_i]=112+vid_sy*vid_scale/VID_MAX_SCALE;
			vid_sy+=16;
		}
		
		oam_off=0;
		
		tile=0x01;
		
		for(_i=0;_i<8;++_i)
		{
			for(_j=0;_j<8;++_j)
			{
				oam_spr(sxa[_j],sya[_i],tile,1,oam_off);
				oam_off+=4;
				tile+=2;
			}
		}
		
		oam_update();
		
		ppu_wait_nmi();
		
		if(vid_scale<VID_MAX_SCALE) ++vid_scale; else break;
		
		if(!(pcnt&7))
		{
			if(bright_spr<4) ++bright_spr;
		}		
		
		++pcnt;
		++frame;
	}
	
	set_nmi_handler(NMI_VID_DMC);

	playdump_soft_dmc(PRG_SAMPLE,fatality_1_data,sizeof(fatality_1_data));
	
	set_nmi_handler(NMI_NORMAL);
	
	pcnt=0;
	
	while(1)
	{
		chr=CHR_VID+((frame&1)?2:0);
		
		mmc3_chr_bank(chr+0,2);
		mmc3_chr_bank(chr+1,3);

		pal_bg_bright (bright_bg);

		oam_update();
		
		ppu_wait_nmi();
		
		if(!(pcnt&7))
		{
			if(bright_bg<4) ++bright_bg; else break;
		}
		
		++pcnt;
		++frame;
	}
	
	set_nmi_handler(NMI_VID_DMC);

	playdump_soft_dmc(PRG_SAMPLE,fatality_2_data,sizeof(fatality_2_data));
	
	set_nmi_handler(NMI_NORMAL);
	
	while(1)
	{
		chr=CHR_VID+((frame&1)?2:0);
		
		mmc3_chr_bank(chr+0,2);
		mmc3_chr_bank(chr+1,3);

		pal_bg_bright (bright_bg);
		pal_spr_bright(bright_spr);

		oam_update();
		
		ppu_wait_nmi();
		
		if(frame>60*5)
		{
			if(!(frame&15))
			{
				if(bright_bg>0)
				{
					--bright_bg;
					--bright_spr;
				}
				else break;
			}
		}

		++frame;
	}

	ppu_off();
}