const char ntsc_only_message[]={
	"\n"
	"WARNING\n\n\n"
	"THIS VERSION OF THE DEMO HAS\n\n"
	"BEEN DESIGNED AS NTSC ONLY.\n\n"
	"IT WILL RUN ON A PAL MACHINE,\n\n"
	"BUT SLOWER AND WITH A FEW\n\n"
	"PARTS BROKEN.\r"
};

const unsigned char ntsc_only_palette[16]={ 0x0f,0x00,0x10,0x30,0x0f,0x07,0x17,0x27,0x0f,0x06,0x16,0x26,0x0f,0x09,0x19,0x29 };



void e_ntsc_only(void)
{
	unsigned char i,c,x,y,chr,bright;
	const char* text;

	chr=CHR_FONT;
	
	mmc3_chr_bank(chr+0,0);
	mmc3_chr_bank(chr+2,1);
	mmc3_chr_bank(chr+0,2);
	mmc3_chr_bank(chr+1,3);
	mmc3_chr_bank(chr+2,4);
	mmc3_chr_bank(chr+3,5);

	mmc3_set_mirroring(M_HORIZONTAL);
	
	set_irq_handler(IRQ_EMPTY);
	set_nmi_handler(NMI_NORMAL);
	
	pal_bg(ntsc_only_palette);

	pal_bright(0);
	
	vram_adr(NAMETABLE_A);
	vram_fill(0,1024);
	vram_adr(NAMETABLE_A+960);
	vram_fill(0x55,24);
	
	text=ntsc_only_message;
	y=8;

	while(1)
	{
		c=*text++;
		
		if(c=='\r') break;
		
		if(c=='\n')
		{
			x=2;
			++y;
			vram_adr(NTADR_A(x,y));
			continue;
		}
		
		vram_put(c-0x20+0x60);
	}
	
	bright=0;
	
	scroll(0,0);
	
	ppu_on_bg();
	
	while(bright<4)
	{
		++bright;
		pal_bright(bright);
		delay(6);
	}
	
	for(i=0;i<10;++i) delay(50);
	
	while(bright>0)
	{
		--bright;
		pal_bright(bright);
		delay(6);
	}
	
	ppu_off();
}