/*
 * Decompiled with CFR 0.152.
 */
package slideybopp.games.lessthan3.Levels;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PathTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import slideybopp.games.lessthan3.Controls.CustomSlider;
import slideybopp.games.lessthan3.Controls.Paths;
import slideybopp.games.lessthan3.Controls.Slidey;
import slideybopp.games.lessthan3.Game;
import slideybopp.games.lessthan3.Levels.LevelDetails;
import slideybopp.games.lessthan3.Levels.MessageType;
import slideybopp.games.lessthan3.Obstacles.Obstacle;

public abstract class Level
extends Parent {
    protected int levelId;
    private String name;
    private int secondsOnLevel;
    protected Pane world = new Pane();
    protected int nextLevel;
    private Paths levelPaths;
    protected CustomSlider slider;
    protected Slidey slidey;
    protected Group slideyGroup = new Group();
    private String deathText;
    private String winningText;
    protected VBox messagePane;
    private Timeline clock;
    private Text timer;
    private int seconds = 0;
    protected List<Obstacle> obstacles = new ArrayList<Obstacle>();
    protected Group obstacleGroup = new Group();
    protected Path path;
    protected List<Path> paths;
    protected int pathIterator = 0;
    protected PathTransition transition;
    protected double fadingPercentage = 0.0;
    protected Timer tick;
    protected TimerTask tickTask;
    protected Button buttonGoToStart = new Button("Go to start");
    protected Button buttonRetry = new Button("Retry");
    protected Button buttonNext = new Button("Go to next level");
    protected boolean end = false;

    public Level(String name, int levelId) {
        this.name = name;
        this.levelId = levelId;
        this.world.setMinSize((double)Game.WIDTH, (double)Game.HEIGHT);
        this.world.setLayoutX(0.0);
        this.world.setLayoutY(0.0);
        this.getChildren().add((Object)this.world);
        this.slideyGroup.getChildren().clear();
        this.obstacleGroup.getChildren().clear();
    }

    protected abstract CustomSlider getSlider();

    protected Slidey getSlidey() {
        Slidey slidey = new Slidey();
        return slidey;
    }

    protected void setNextLevel(int nextLevel) {
        this.nextLevel = nextLevel;
    }

    protected int getNextLevel() {
        return this.nextLevel;
    }

    protected void setButtons() {
        this.buttonGoToStart.setOnMouseClicked(event -> Game.setScene(0));
        this.buttonNext.setOnMouseClicked(event -> Game.setScene(this.getNextLevel()));
        this.buttonRetry.setOnMouseClicked(event -> Game.resetScene(this.levelId));
    }

    protected Path getPath(Integer levelId) {
        this.levelPaths = new Paths(levelId);
        return this.levelPaths.getPath();
    }

    protected List<Path> getPaths(Integer levelId) {
        this.levelPaths = new Paths(levelId);
        return this.levelPaths.getPaths();
    }

    protected void startTick() {
        this.tick = new Timer("GameTick", true);
        this.tickTask = new TimerTask(){

            @Override
            public void run() {
                if (Level.this.slidey.isAlive()) {
                    Level.this.checkCollision();
                }
            }
        };
        this.tick.scheduleAtFixedRate(this.tickTask, 0L, 200L);
    }

    protected void stopTick() {
        this.tick.cancel();
        this.tick.purge();
        this.tickTask.cancel();
    }

    protected void setMessageText(MessageType messageType, String text) {
        switch (messageType) {
            case WIN: {
                this.winningText = text;
                break;
            }
            case DEATH: {
                this.deathText = text;
            }
        }
    }

    protected Group getMessagePane(MessageType messageType) {
        if (!this.end) {
            this.end = true;
            Group group = new Group();
            Rectangle background = new Rectangle(0.0, 0.0, (double)Game.WIDTH, (double)Game.HEIGHT);
            background.setOpacity(0.5);
            this.messagePane = new VBox();
            this.messagePane.setLayoutX(0.0);
            this.messagePane.setLayoutY(0.0);
            this.messagePane.setMinSize((double)Game.WIDTH, (double)Game.HEIGHT);
            this.messagePane.setAlignment(Pos.CENTER);
            this.messagePane.setSpacing(10.0);
            Text messageText = new Text();
            VBox buttonPane = new VBox();
            buttonPane.setSpacing(10.0);
            buttonPane.setAlignment(Pos.CENTER);
            switch (messageType) {
                case WIN: {
                    background.setFill((Paint)Color.GREENYELLOW);
                    messageText.setText(this.winningText);
                    messageText.setTextAlignment(TextAlignment.CENTER);
                    buttonPane.getChildren().add((Object)this.buttonNext);
                    buttonPane.getChildren().add((Object)this.buttonGoToStart);
                    break;
                }
                case DEATH: {
                    background.setFill((Paint)Color.DARKRED);
                    messageText.setText(this.deathText);
                    buttonPane.getChildren().add((Object)this.buttonRetry);
                    buttonPane.getChildren().add((Object)this.buttonGoToStart);
                }
            }
            messageText.setFont(Font.font((String)"Verdana", (double)120.0));
            this.messagePane.getChildren().add((Object)messageText);
            this.messagePane.getChildren().add((Object)buttonPane);
            group.getChildren().addAll((Object[])new Node[]{background, this.messagePane});
            return group;
        }
        return null;
    }

    protected void stopObstacles() {
        for (Obstacle obstacle : this.obstacles) {
            obstacle.pause();
        }
    }

    public void stopWorld(MessageType messageType) {
        this.stopTimer();
        Platform.runLater(() -> {
            this.stopObstacles();
            this.displayMessage(messageType);
        });
    }

    protected PathTransition getTransition(Path transitionPath, CustomSlider slider, Slidey node) {
        PathTransition transition = new PathTransition();
        transition.setDuration(Duration.seconds((double)slider.getTravelLength()));
        transition.setPath((Shape)transitionPath);
        transition.setNode((Node)node);
        transition.setInterpolator(Interpolator.LINEAR);
        transition.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        transition.setAutoReverse(false);
        transition.play();
        transition.pause();
        transition.jumpTo(Duration.seconds((double)0.0));
        transition.currentTimeProperty().addListener((observable, oldValue, newValue) -> {
            if (this.slidey.isAlive()) {
                this.checkCollision();
            }
        });
        return transition;
    }

    protected void checkCollision() {
        for (Obstacle obstacle : this.obstacles) {
            try {
                if (obstacle == null || !obstacle.collision()) continue;
                this.slidey.setAlive(false);
                obstacle.setFill(Color.RED);
                System.out.println("literally dead.");
                this.stopTick();
                Game.LEVEL.stopWorld(MessageType.DEATH);
            }
            catch (NullPointerException e) {
                System.out.println("nulls!!!!");
            }
        }
    }

    protected void addChild(Node child) {
        this.world.getChildren().add((Object)child);
    }

    protected void removeChild(Node child) {
        this.world.getChildren().remove((Object)child);
    }

    protected void displayMessage(MessageType messageType) {
        Group group = this.getMessagePane(messageType);
        if (group != null) {
            this.addChild((Node)group);
        }
    }

    protected HBox getTimerPane() {
        this.timer = new Text("000");
        this.timer.setFont(Font.font((String)"Verdana", (double)40.0));
        this.timer.getStyleClass().add((Object)"timer");
        HBox timerPane = new HBox();
        timerPane.getStyleClass().add((Object)"timerPane");
        timerPane.setLayoutX(0.0);
        timerPane.setLayoutY(0.0);
        timerPane.setAlignment(Pos.TOP_RIGHT);
        timerPane.setMinSize((double)Game.WIDTH, (double)Game.HEIGHT);
        timerPane.getChildren().add((Object)this.timer);
        return timerPane;
    }

    protected void initTimer() {
        this.clock = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> {
            if (this.seconds > 999) {
                this.seconds = 0;
            }
            ++this.seconds;
            this.timer.setText(this.seconds < 10 ? "00" + this.seconds : (this.seconds < 100 ? "0" + this.seconds : "" + this.seconds));
        }, new KeyValue[0])});
        this.clock.setCycleCount(-1);
        this.clock.play();
    }

    protected void setSliderHorizontalToLeft(final CustomSlider slider, final PathTransition pt) {
        Node seeker = slider.getSeeker();
        final int x = slider.getX();
        final int y = slider.getY();
        final int seekerSize = slider.getSeekerSize();
        final int max = slider.getMax();
        final int pos = slider.getPosition();
        seeker.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (Level.this.slidey.isAlive() && slider.isEnabled()) {
                    Level.this.slidey.setMoving(true);
                    double seekX = event.getSceneX() - (double)x - (double)(seekerSize / 2);
                    double seekY = event.getSceneY() - (double)y - (double)(seekerSize / 2);
                    int seekMax = max - seekerSize;
                    double position = pos;
                    if (seekX >= 0.0 && seekX <= (double)seekMax) {
                        position = seekX;
                    } else if (seekX < 0.0) {
                        position = 0.0;
                    } else if (seekX > (double)seekMax) {
                        position = seekMax;
                    }
                    slider.setPosition((int)position);
                    Level.this.setPathFading(position, seekMax, true);
                    if (position <= 0.0) {
                        Level.this.setWinScreen();
                    }
                    pt.jumpTo(Duration.seconds((double)((double)seekMax - position)));
                }
            }
        });
        seeker.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Level.this.slidey.setMoving(false);
            }
        });
    }

    protected void setSliderHorizontalToRight(final CustomSlider slider, final PathTransition pt) {
        Node seeker = slider.getSeeker();
        final int x = slider.getX();
        final int y = slider.getY();
        final int seekerSize = slider.getSeekerSize();
        final int max = slider.getMax();
        final int pos = slider.getPosition();
        seeker.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (Level.this.slidey.isAlive() && slider.isEnabled()) {
                    Level.this.slidey.setMoving(true);
                    double seekX = event.getSceneX() - (double)x - (double)(seekerSize / 2);
                    double seekY = event.getSceneY() - (double)y - (double)(seekerSize / 2);
                    double position = pos;
                    int seekMax = max - seekerSize;
                    if (seekX >= 0.0 && seekX <= (double)seekMax) {
                        position = seekX;
                    } else if (seekX < 0.0) {
                        position = 0.0;
                    } else if (seekX > (double)seekMax) {
                        position = seekMax;
                    }
                    slider.setPosition((int)position);
                    Level.this.setPathFading(position, seekMax, false);
                    if (position >= (double)seekMax) {
                        Level.this.setWinScreen();
                    }
                    pt.jumpTo(Duration.seconds((double)position));
                }
            }
        });
        seeker.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Level.this.slidey.setMoving(false);
            }
        });
    }

    private void setPathFading(double position, int seekMax, boolean inverted) {
        if (this.fadingPercentage > 0.0) {
            double correctionStart = 1.0 - (double)this.pathIterator / (double)(this.path != null ? 1 : this.paths.size());
            double correctionEnd = 1.0 - (double)(this.pathIterator + 1) / (double)(this.path != null ? 1 : this.paths.size());
            double percentage = position / (double)seekMax;
            if (inverted) {
                percentage = 1.0 - position / (double)seekMax;
            }
            double opacity = 1.0 - percentage / this.fadingPercentage;
            double correctedOpacity = this.fadingPercentage <= 1.0 - correctionStart ? 0.0 : opacity * (correctionStart - correctionEnd) + correctionEnd;
            if (this.path != null) {
                this.path.setOpacity(correctedOpacity);
            } else {
                this.paths.forEach(p -> p.setOpacity(correctedOpacity));
            }
        }
    }

    protected void setWinScreen() {
        if (this.hasMorePaths()) {
            this.attachToNextSlider();
        } else {
            Game.LEVEL.stopWorld(MessageType.WIN);
            this.slidey.setAlive(false);
        }
    }

    protected boolean hasMorePaths() {
        if (this.paths != null) {
            return this.paths.size() + 1 > this.pathIterator;
        }
        return false;
    }

    protected abstract void attachToNextSlider();

    protected boolean isEnd() {
        return this.end;
    }

    protected void setEnd(boolean end) {
        this.end = end;
    }

    private void stopTimer() {
        this.clock.stop();
    }

    public String getName() {
        return this.name;
    }

    public int GetLevelId() {
        return this.levelId;
    }

    public void resetTime() {
        this.secondsOnLevel = 0;
    }

    public LevelDetails getDetails() {
        return new LevelDetails(this.name, this.levelId);
    }
}

