import processing.sound.*;
boolean boltsSet = false;
int time;
int numberOfBolts = 5;
int lightningHeight = 40;
ArrayList<PVector> raindrops = new ArrayList<PVector>();
int initY = 0;
int initX = 200;
ArrayList<SoundFile> thunderSounds = new ArrayList<SoundFile>();
SoundFile wind;
SoundFile rain;
int seed = 17;

void settings() {
  //size(WIDTH, HEIGHT, P3D);
  fullScreen();
}

void setup(){
  colorMode(HSB, 360, 100, 100);
  noCursor();
  background(236,79,13);
  noiseSeed(seed);
  randomSeed(seed);
  //noLoop();
  thunderSounds.add(new SoundFile(this, "Thunder_HD-Mark_DiAngelo-587966950.wav"));
  thunderSounds.add(new SoundFile(this, "Storm_exclamation.wav"));
  thunderSounds.add(new SoundFile(this, "thunder2.wav"));
  thunderSounds.add(new SoundFile(this, "thunder3.wav"));
  thunderSounds.add(new SoundFile(this, "More_Thunder-Mike_Koenig-889679068.wav"));
  thunderSounds.add(new SoundFile(this, "Thunder-Mark_DiAngelo-2147265856.wav"));
  wind = new SoundFile(this, "Wind-Mark_DiAngelo-1940285615.wav");
  rain = new SoundFile(this, "Rain_Inside_House-Mark_DiAngelo-323934112-clipped.wav");
  wind.play();
}

void draw() {
  background(234,70,7);
  
  time = millis();
  
  // Rain
  stroke(0,0,31);
  strokeWeight(1);
  int numberOfRaindrops = int(random(1, 100));
  int timeframe = time%500;
  if(timeframe < 370) {
    for(int i=1; i<=numberOfRaindrops; i++) {
      PVector raindrop = new PVector(int(random(1, width)), int(random(0, 20)), int(random(8, 32)));
      raindrops.add(raindrop);
    }
  }
  
  for(int i=raindrops.size()-1; i>=0; i--) {
    PVector raindrop = raindrops.get(i);
    
    float newX = (raindrop.x + log(raindrop.z) + raindrop.z/3); // horizontal speed
    if(newX < 0) {
      newX += width;
    }
    float newY = raindrop.y + raindrop.z; // vertical speed

    float endX = lerp(raindrop.x, newX, 0.5); // calculate shorter lines for raindrops
    float endY = lerp(raindrop.y, newY, 0.5);

    line(raindrop.x, raindrop.y, endX, endY);
    
    raindrop.x = newX % width;
    raindrop.y = newY;
        
    if(raindrop.y > height) {
      raindrops.remove(i);
      if(!rain.isPlaying())
        rain.play();
    }
  }
  
  if(time >= 60000)
    exit();
  
  // Lightning
  timeframe = time%7000;
  if(timeframe >= 200){
    boltsSet = false;
    return;
  } else if(!boltsSet) {
    numberOfBolts = int(random(1,3));
    if(numberOfBolts == 1) {
      initX = int(random(100, width-100));
    }
    else {
      initX = int(random(100, width/2));
    }
    boltsSet = true;
    
    int thunderIndex = int(random(0, thunderSounds.size()));
    thunderSounds.get(thunderIndex).play();
  }

  int startX = initX;
  println("Random: "+ startX);

  int startY = initY;
  timeframe = time%60;
  if(timeframe < 30){
    background(255);
    stroke(0);
  }
  else {
    background(0);
    stroke(255);
  }
  for(int i=1; i<=numberOfBolts; i++){
    drawLightning(startX, startY, lightningHeight/2);
    drawLightning(startX, startY, lightningHeight/2);
    strokeWeight(7*noise(millis()/100));
    drawLightning(startX, startY, lightningHeight);
    startX += width/numberOfBolts;
  }
}

void drawLightning(int lineStartX, int lineStartY, int lightningHeight){
  //println("startX: " + lineStartX + ", startY: " + lineStartY);
  for(int i=0; i< lightningHeight; i++){
    PVector endPoint = getEndPoint(lineStartX, lineStartY);
    line(lineStartX, lineStartY, endPoint.x, endPoint.y);
    lineStartX = int(endPoint.x);
    lineStartY = int(endPoint.y);
  }
}
PVector getEndPoint(int lineStartX, int lineStartY){
  float randomFloat = noise(lineStartX, lineStartY, millis());
  float length = 50*randomFloat;
  float angle = PI*randomFloat;
  float yDistance = length*sin(angle);
  float xDistance = length*cos(angle);
  return new PVector(lineStartX + xDistance, lineStartY + yDistance);
}
