
//  ███╗   ██╗███████╗██╗   ██╗███╗   ██╗ ██████╗
//  ████╗  ██║██╔════╝╚██╗ ██╔╝████╗  ██║██╔════╝
//  ██╔██╗ ██║███████╗ ╚████╔╝ ██╔██╗ ██║██║     
//  ██║╚██╗██║╚════██║  ╚██╔╝  ██║╚██╗██║██║     
//  ██║ ╚████║███████║   ██║   ██║ ╚████║╚██████╗
//  ╚═╝  ╚═══╝╚══════╝   ╚═╝   ╚═╝  ╚═══╝ ╚═════╝
//  supa & noby -=- Scene Lounge : One Scene 2019
//  -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  TECH SUPPORT: CAPTAIN PORNO & MOBUTU SEKOSEKO

import moonlander.library.*;
import ddf.minim.*;
Moonlander moonlander;

PShape cube;
PImage cube_texture;

PGraphics surface;
PGraphics front;
PGraphics backdrop;

int resX = 1920;
int resY = 1080;

float angle = 0;
float lineangle = 0.8;

int linesize;
int lineamount;
int linegap;

void setup () {
  fullScreen(P3D);
  frameRate(60);
  noCursor();
  
  surface = createGraphics(400,400);
  backdrop = createGraphics(resX,resY);
  front = createGraphics(resX,resY,P3D);
  
  moonlander = Moonlander.initWithSoundtrack(this, ("data/noby_rahina.mp3"), 128, 4);
  moonlander.start("localhost", 1338, ("data/syncdata.rocket"));
  
  cube = createShape(BOX, 400);
  cube.setTexture(surface);
  
}

void draw() {
  
  int bg = moonlander.getIntValue("Background");
  int boxsize = moonlander.getIntValue("Cube");
  int elsize = moonlander.getIntValue("Circle");
  int elsize2 = moonlander.getIntValue("Circle 2");
  int speed = moonlander.getIntValue("Speed");
  int rl = moonlander.getIntValue("Red");
  int gl = moonlander.getIntValue("Green");
  int bl = moonlander.getIntValue("Blue");
  int linesize = moonlander.getIntValue("Size");
  int lineamount = moonlander.getIntValue("Amount");
  int linegap = moonlander.getIntValue("Gap");
  
  pointLight(rl, gl, bl, resX/3, resY/3, 3000);
  
  surface.beginDraw();
    surface.background(15);
    surface.noStroke();
    surface.rectMode(CENTER);
    surface.translate(200,200);
    surface.rotate(lineangle);
      for (int i = 0; i < lineamount; i++) {
      surface.rect(-300+i*linegap,0,linesize,600);
      }
  surface.endDraw();
  
  backdrop.beginDraw();
    backdrop.background(bg);
    backdrop.noFill();
    backdrop.stroke(255);
    backdrop.strokeWeight(elsize/6);
    backdrop.ellipse(resX/2,resY/2,elsize,elsize);
    backdrop.strokeWeight(elsize2/12);
    backdrop.ellipse(resX/2,resY/2,elsize2,elsize2);
  backdrop.endDraw();
  
  front.beginDraw();
    front.translate(resX/2,resY/2,boxsize);
    front.rotateX(angle*0.24);
    front.rotateY(angle*0.33);
    front.shape(cube);
  front.endDraw();
  
  image(backdrop,0,0,width,height);
  image(front,0,0,width,height);
  
  front.beginDraw();
    front.clear();
  front.endDraw();
  
  if(speed > 0) {
    angle += 0.3;
  }
  
  angle += 0.1;
  
  moonlander.update();
}
