#version 330 core

// Input vertex data, different for all executions of this shader.
layout(location = 0) in vec3 squareVertices;
layout(location = 1) in vec2 xys; // Position of the center of the particule and size of the square

// Output data ; will be interpolated for each fragment.
out vec4 oColor;
out vec2 uv;

// Values that stay constant for the whole mesh.
uniform vec3 camr;
uniform vec3 camu;
uniform vec3 campos;
uniform mat4 VpMtx; // Model-View-Projection matrix, but without the Model (the position is in BillboardPos; the orientation depends on the camera)

vec2 hash( vec2 p ) // replace this by something better
{
	p = vec2( dot(p,vec2(127.1,311.7)),
			  dot(p,vec2(269.5,183.3)) );

	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2 i = floor( p + (p.x+p.y)*K1 );
	
    vec2 a = p - i + (i.x+i.y)*K2;
    vec2 o = step(a.yx,a.xy);    
    vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0*K2;

    vec3 h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );

	vec3 n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));

    return dot( n, vec3(70.0) );
	
}

float height(vec2 uv) {
    float f = 0.0;
		uv *= 5.0;
        mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
		f  = 0.5000*noise( uv ); uv = m*uv;
		f += 0.2500*noise( uv ); uv = m*uv;
		f += 0.1250*noise( uv ); uv = m*uv;
		f += 0.0625*noise( uv ); uv = m*uv;
    return 0.5 + 0.5*f;
}

void main()
{
	// TODO: funky height maps
	float spreadness = 40.0;
	vec2 XY = (xys.xy - .5);
	float a = 0.2;
	float f = 5.0*height(XY) * (a + (1.-a)*smoothstep(0.075, 0.2, abs(XY.x)));
	vec2 permt = (1./256.) * vec2(noise(2.0*XY),
		                          noise(5.0*XY.xx + 5.3*XY.yy));
	vec3 particleCenter_wordspace = vec3(spreadness, f, 0.6*spreadness) * vec3(xys.x + permt.x, 1.0, xys.y + permt.y);
	
	float s = 0.05;
	vec3 vertexPosition_worldspace = 
		particleCenter_wordspace
		+ s*camr*squareVertices.x
		+ s*camu*squareVertices.y;

	// Output position of the vertex
	gl_Position = VpMtx * vec4(vertexPosition_worldspace, 1.0);
	oColor = vec4(1.0);
	oColor.xyz *= exp(-.12*length(campos - particleCenter_wordspace));
	uv =  .5 *(1.0 + squareVertices.xy);
}
