#version 330 core

in vec2 UV;
out vec4 fragColor;

uniform vec2 iResolution;
uniform vec2 texdimensions;
uniform sampler2D sourcetex;
uniform float radius;
uniform vec2 blurdir;

void main() {
	vec4 outcolor = vec4(vec3(0.0), 1.0);
	float nSamples = 0.0;
	for (float dx = -radius; dx <= radius; dx += 1.0) {
		vec2 pos = UV + dx * blurdir / texdimensions;
		outcolor += texture(sourcetex, pos);
		nSamples += 1.0;
	}
    fragColor = outcolor / nSamples;
}
