class SceneLoading {
	constructor (scene, analyser, camera, closeCallback) {
		this.closeCallback = closeCallback;
		this.timer = 0;
		this.scene = scene;
		this.analyser = analyser;
		this.state = 'stage1';
		this.fontSize = 6;
		this.frequencyMultplier = 0;
		this.cubeGroup = new THREE.Group();
		this.cubeArray = [];

		this.cubeDelay = 2;

		this.makeCubes();
	}

	destroy () {
		this.closeCallback();
		this.destroyQCubes();
	}

	makeCubes () {
		for (var i = 10 - 1; i >= 0; i--) {
			this.cubeArray[i] = new Cube(scene);

			this.cubeArray[i].setPosition(new THREE.Vector3( 120, 0, 0 ))
		}
	}

	destroyQCubes () {
		if (this.cubeArray) {
			for (var i = this.cubeArray.length - 1; i >= 0; i--) {
				if (this.cubeArray[i]) {
					this.cubeArray[i].destroy();
					this.cubeArray[i] = null;
				}
			}
		}		
	}

	animate (scene) {
		this.timer += 0.1;
		

		if (this.timer > 20) {
			this.state =  'stage2'
		}

		if (this.timer > 70) {
			this.destroy();
		}

		// Intro text and logo n stuff
		if (this.state ===  'stage1' || this.state ===  'stage2') {
			for (var i = this.cubeArray.length - 1; i >= 0; i--) {

				if (this.timer > this.cubeDelay * i) {
					var pos = new THREE.Vector3( i * 2 - 10, 0, 0 );

					if (this.state === 'stage2' && this.timer > this.cubeDelay * i + 40) {
						pos = new THREE.Vector3( i * 2 - 200, 0, 0 );
					}

					if (this.cubeArray[i]) {
						var cubePos = this.cubeArray[i].getPosition();
						var x = Math.abs(pos.x - cubePos.x);
						var y = Math.abs(pos.y - cubePos.y);
						var z = Math.abs(pos.z - cubePos.z);
						var distanceToTarget = Math.max(x, y, z);
						if (distanceToTarget > 0.5) {
							this.cubeArray[i].animatePosition(pos, 1.5); 
						}
					}

				}

			}
		} 


	}
}