uniform float time;
uniform float alpha;
varying float vNoise;
varying vec3 vNormal;
varying vec3 vPos;
varying vec2 vUv;

float noise(float v, float amplitude, float frequency, float time) {
    float r = sin(v * frequency);
    float t = 0.01*(-time*130.0);
    r += sin(v*frequency*2.1 + t)*4.5;
    r += sin(v*frequency*1.72 + t*1.121)*4.0;
    r += sin(v*frequency*2.221 + t*0.437)*5.0;
    r += sin(v*frequency*3.1122+ t*4.269)*2.5;
    r *= amplitude*0.06;
    
    return r;
}

float plot(float pct, float thickness, vec2 position) {
    return smoothstep(pct - thickness, pct, position.x) - smoothstep(pct, pct + thickness, position.x);
}
    
void main(void) {
    float time2 = time / 10.0;
    vec2 position = vPos.xy;
    vec3 color = vec3(0);


    color += plot(noise(position.y * 0.01, 1.023, 9.8, time2 * 0.3)  * 3.4, 1.93, position ) * vec3(0.2, 0.5, 0.9);
    color += plot(noise(position.y * 0.01, 1.06, 5.8, time2 * 0.76)  * 3.4, 1.90, position) * vec3(0.2, 0.9, 0.1);
    color += plot(noise(position.y * 0.01, 1.96, 7.8, time2 * 0.5)  * 3.4, 1.93, position) * vec3(0.8, 0.2, 0.8);
    color *= length(color * 6.8);
    gl_FragColor = vec4(color, alpha);
    
}
    