;txt.msg // 1-4-411
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: marukabis - arrival time

;________________________
;one scroller for all sizecoders on all platforms - especially those who
;keep the tiny intro section alive :)

;________________________
;this is very heavy commented compared to many of my previous releases.
;but i had the urge to do so. so feel free to go on reading ;)

;i was (still) thinking about scrollers and wanted to have one in texmode
;since i can't remember having seen a big one in 256 bytes + in textmode.
;and i watched way too much bbstros which were also an influence. because
;of that i made the scroller the way it is. at first it was a decision to
;save space but the more i could shave off bytes the longer the scroller
;could become within it's boundaries (30 bytes is the maximum because of
;how things are done ... but that is enough for a little message). and it
;does not need to hide from the quite long text in my previous ad for demozoo.

;anyway, to get the big text the intro does output the string to a000 in 13h
;and saves it. each pixel is then grabbed from the stored data and droped
;to 80*50 upscaling/stretching it. the text itself does not scroll but the
;area where the data is grabbed from does (which always is 80 bytes wide).

;i also disabled blink to get access to the full background palette to create
;the orange like highlight on the text in the first place which is quite neat
;and worth the few bytes.

;all data is stored in the screen buffer outside of the visible area. this way
;only es and ds are needed for segments which overall saves quite some bytes
;mainly because accessing/adressing via ds is 1 byte smaller than using other
;segment registers.

;________________________
;    memory at DS      rows (to visualize the offset)
;--------------------.   0
; the intro outputs  ;   1    160 bytes (80 * 2) is 1 row
;  the visuals of    ;   .    50 rows since the intro uses
;   this area of     ;   .    80 * 50 resolution
;  80*50*2  bytes    ;   .
;--------------------'   49
;                        .  - here are random values (?)
;---------------------   65 - 80 bytes for empty space
;here are 320*12 bytes   .    in front of string (all 0)
; which include 320*8    .    (string size 160*16)
;bytes of  string data   81 - end of string data
;at the top.every byte   83 - at 160*65+160*18(320*9)
;<>0 is a pixel of the   .    is a variable for
;       string.          .    the movement of the
;                        .    highlight on the text
;                        .    rest of the data in this
;                        .    part is 0
;---------------------   89 - 320*12/160*24, end of data
;                             that is copied from
;                             0a000h. from here on up to
;                             end of the offset random
;                             data (?)

;_______________________
;assuming values at start of the intro: ax = bx = 0 / cx = 255
;global used variable: bp for scanning/moving the string/scroller

org 100h
use16

start:   push 0a000h     ;vga
         pop es          ;clears memory at 0a000h
         mov al,13h      ;by setting all bytes to 0
         int 10h         ;when video mode is activated

         mov ah,09h      ;print string to vga
         mov dx,text     ;ds needs to be unchanged
         int 21h         ;drop the string

         push 07000h     ;vscreen + buffer for string + movement of
                         ;diagonal bar
         pop ds          ;change here because of string operation above

;this copies data from 0a000h into unused part of the ds segment
;where only the first 80*50*2 bytes were displayed/used for the intro
;only the upper 320*8 bytes contain the string while all data below is 0
;the string is 30 bytes so 30 * 8 = 240. 240 + 80 = 320. and 80 is also
;the width of the screen in textmode so those 80 bytes provide an empty
;space between the scroller-loops which also avoids visual errors (jump
;when the process passes the 320 width in the stored data which again is
;a 1:1 copy of the output in mode 13h)
mov bh,0fh ;=320*12 ;it is assumed that bx = 0 at this point
copier:
mov ah,byte[es:bx]           ;get pixels of drawn string
mov byte[ds:160*65+bx+80],ah ;save it incl adjust for an empty area in front
dec bx                       ;of the string
jnz copier                   ;using ah because of code below

         push 0b800h     ;segment of screen memory of textmodes 80*25
         pop es          ;and 80*50

         mov al,03h      ;set textmode 80*25
                         ;ah has to be 0. it is zeroed at string grabbing where
                         ;last grabbed byte is always 0 so -1b
         int 10h

         mov ax,1003h    ;disable blink (128) ---> full 16 bg colors
         int 10h         ;syntax = color(0..15)+16*bg-color(0..15)

         mov ax,1112h    ;set textmode to 80*50 / 8000 bytes buffer
         int 10h         ;needed because 1 byte char + 1 byte attributes

main:

;draws bar in the middle by filling it with more or less random ascii
mov bx,160*8-6 ;thickness of bar ;-6 for cutting the edge
bar:
in al,40h     ;rnd
add dx,ax     ;more seed
mul dx        ;better rnd
mov cl,7      ;reuse below
shr ah,cl;7      ;makes ah 0 or 1
add ah,9;7    ;7 or 8 / light or dark gray
              ;but bright blue + green also looks nice
ney:
;mov al,cl     ;this is a neat alternative but it does kill
;shl ah,4      ;the textmode feeling
mov word[ds:bx+160*20+2],ax ;set ascii+attributes;+2 for cutting the edge

dec bx                      ;always word access
dec bx
jnz bar                     ;do whole bar


;draw a longer string as little extra to use remaining bytes
;sub ah,9 ;3b :(
mov cl,37 ;include the whole string after the little waving dude + 256b
line:
mov al,byte[cs:msg2+bx]
;imul si,bx,2
mov si,bx ;saves 1b
mov word[ds:bx+si+160*28+10],ax ;looks nice at this position
inc bx
loop line

mov ax,160                  ;save a few bytes by reusing below

;get the string data, convert it and show the text
mov cl,79;80;80 ;ch = always 0 ;startpos in textmode
         ;-1 because shadow would occur on left side
mov di,bp ;set start pos for scan on 320*200

scan:
xor bx,bx ;height on 320*200
xor dx,dx ;height on 80*50
scan2:

cmp byte[ds:160*65+bx+di],ch;0 ;pixel on buffer of 320*200 string?
je skip                 ;nope
;mov si,bx              ;set pos
;sub si,bp              ;sub movement
;shl si,1;2;1           ;word!
;imul ax,dx,4           ;size up height
;add si,ax              ;set correct pos for ascii

imul si,dx,2;3;2            ;size up steps for y
add si,di               ;pos of scan
sub si,bp               ;exclude movement
shl si,1                ;word

mov ch,6;4;6;4             ;height to be drawn for 1 pixel
                           ;since everything overlaps it pumps up the letters
sizeup:
mov word[ds:si+160*10+2],00b0h;01b0h ;shadow
                        ;having a black shadow makes it better looking
                        ;also it takes away the problem that the fact that the
                        ;highlight does only affect the letters not the shadows
                        ;which - with non black shadow - looks like a bug on the
                        ;bottom. and it looks great in grayscale in the diagonal bar
;177=b1 219=db 9+9*16=99h
mov word[ds:si+160*9],99b1h;0ceb1h;99b1h   ;letter

add si,ax;160        ;next row
dec ch               ;loop
jnz sizeup           ;until done

skip:
add dx,ax;160 ;helper on textmode, next row
add bx,320    ;next row in 320*200
;cmp bx,320*8 ;done full height or letters which are 8*8?
cmp bh,0ah    ;save 1b
jne scan2

inc di               ;next pos on 320*200
loop scan            ;do whole screen 80*50

;for movement of diagonal bar
;since byte at ds:160*65+320*9 is even (0) at beginning everything works fine
;data is in area that is copied from 0a000h which is 0 after init 13h
;odd bytes crash intro because of architecture of textmode (1b ascii + 1b color(s))
;when overriding offsets since many instructions use words

;mov di,160*65+320*9;saves 5 bytes below
;add byte[ds:di],2
;cmp byte[ds:di],al;160 (al reused from above)
;jna fine2
;mov byte[ds:di],cl;0
;fine2:

;create highlight on scroller + diagonal bar
;mov bx,word[ds:di] ;bh = 0 after this since the area in mem is 0
                             ;because of string saving at the start
;mov bl,byte[ds:160*51] ;works if jno instead jnz below
                        ;bh=0ah here

;shld bx,bp,18 ;use bp for moving and make sure
;shr bx,1      ;it is even so no error on moving highlight
              ;because word!
;shld bx,bp,17 ;bp 0..319 ---> 2x 160 ---> 2 screens in textmode only word steps
               ;somehow it sometimes runs smoother than using imul
imul bx,bp,2   ;-1b
mov di,39*162  ;starting point which is lower end of the letters/shadows
inc bx         ;this saves 1b because +1 in ds:di+bx+1 to access attributes
               ;for highlight is not necessary
glass:
mov cl,21     ;width of bar / ch = always 0 here
glass2:
;cmp dh,99h ;only highlight the scroller
cmp byte[ds:di+bx],99h;0ceh
jne well
;mov dl,177
;mov dh,14+12*16 ;new colors
;mov dx,0ceb1h
;mov word[ds:di+bx],0ceb1h;dx ;set highlight
mov byte[ds:di+bx],0ech;0ceh;0b9h;03eh;0ceh
well:
mov dx,word[ds:di+40+2]  ;grab
mov dh,4;8;7;4;7         ;color it; 8 is nice but 4 has a little extra to it
mov word[ds:di+34+2],dx  ;set
;mov byte[ds:di+34+2+1],4  ;set
inc di ;word access
inc di
loop glass2
;sub di,44 ;adjust because inc si inc si above
;sub di,162;height - 1
sub di,162+42
jnz glass      ;draw all the way up

;start of grabber-window in 320*200
;which moves from left to right
;to make scroller fake scroll
inc bp
cmp bp,320;-80;-39;-80
jnae fine
xor bp,bp
fine:

mov dx,3dah     ;wait for vsync for constant speed
;vsync1:         ;to slow things down and make the
;in al,dx        ;scroller actually readable ;)
;test al,8
;jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2

;di = cx = 0 here
;mov cx,80*50 ;no *2 since stosw does that
;80*64=1400h / word use makes this to 160*64
;which is on top of saved string data + variable for
;the orange highlight
mov ch,14h*2 ;slow things down a bit my using byte operations
flip:
xor ax,ax
xchg al,byte[ds:di]
stosb ;incl add di,2
loop flip

         in al,60h            ;read keyboard buffer
         dec ax               ;ESC? ax = possible + saves 1 byte
         jnz main             ;nothing so go on

breaker: ret                  ;back to dos, staying in 80*50

;        0        1         2         3         4         5
;        12345678901234567890123456789012345678901234567890
msg2 db '\',1,'/256B' ;some bytes left so ... :)
text db '-6R7Z-2-41l-5!Z3-[dRZ-47-RV5N-$'
;this clean version is nice but not so much like a bbs phone number ;)
;text db ':) 2 ALL SIZECODERS @ REVISION$'