var selectedUnitId= null; // key in array
var selectedBuildingId= null; // key in array
var selectBuildPlaceForMainBuildingId= null; // key in array

function toMapX(x){
	return (x-mapX)*gridSize;
}

function toMapY(y){
	return (y-mapY)*gridSize;
}

function toServerX(x){
	return x/gridSize+mapX;
}

function toServerY(y){
	return y/gridSize+mapY;
}

function getUserColor(id){
	// console.log(id);
	for( var i=0;i<users.length;i++){
		if( users[i]!==undefined && users[i].id==id )
			return '#'+users[i].color;
	}
	return '#F00';
}

function timeToStr(t){
	t= parseInt(t/1000);
	var sec= parseInt(t%60);
	t -= sec;
	t /= 60;
	var min= parseInt(t%60);
	t -= min;
	var hh= parseInt(t);
	if( 0 < hh ){
		return hh+':'+min+':'+sec;
	}else if( 0 < min ){
		return min+':'+sec;
	}else{
		return sec;
	}
}

function getCurrentUnitPosition(unit,t){
	var speed= unitTypes[unit.type_id].speed;
	var tt= t - unit.utime;
	var sx=(unit.x);
	var sy=(unit.y);
	var tx=(unit.tx);
	var ty=(unit.ty);
	var dis= Math.sqrt( (tx-sx)*(tx-sx) + (ty-sy)*(ty-sy) );
	
	var h= tt * speed / dis / 1000 / 60;
	if( 1.0 < h )
		h= 1.0;
	var x= sx*(1-h) + tx*h;
	var y= sy*(1-h) + ty*h;
	return [x,y];
}

function updateMap(){
	var t= getTime();
	$('#mapBackground').css('background-position',(-mapX*gridSize)+'px '+(-mapY*gridSize)+'px');
	/// update buildings
	for( var i=0;i<buildings.length;i++)
		if( buildings[i]!==undefined && buildings[i]!==null && 0<buildings[i].hp )
		{
			var b= $('#building-'+buildings[i].id);
			if( 0 < b.length ){
				b.css('top',toMapY(buildings[i].y));
				b.css('left',toMapX(buildings[i].x));
				$('#building-'+buildings[i].id+' .hpbar .hpbarfill').css('width', (100*buildings[i].hp/buildingTypes[buildings[i].type_id].hp)+'%' );
			}else{
				var hpbarcode= '<div class="hpbar"><div class="hpbarfill" style="background-color:'+getUserColor(buildings[i].user_id)+';width:'+(100*buildings[i].hp/buildingTypes[buildings[i].type_id].hp)+'%;"></div></div>';
				$('#map').append('<div onclick="onBuildingClick('+i+');" id="building-'+buildings[i].id+'" class="item building building-type-'+buildings[i].type_id+'" style="top:'+toMapY(buildings[i].y)+'px;left:'+toMapX(buildings[i].x)+'px;width:'+gridSize+'px;height:'+gridSize+'px;">'+hpbarcode+'</div>');
			}
		}
	/// update units
	for( var i=0;i<units.length;i++)
		if( units[i]!==undefined && units[i]!==null && 0<units[i].hp )
		{
			var p= getCurrentUnitPosition(units[i],t);
			var u= $('#unit-'+units[i].id);
			if( 0 < u.length ){
				u.css('top',toMapY(p[1]));
				u.css('left',toMapX(p[0]));
				$('#unit-'+units[i].id+' .hpbar .hpbarfill').css('width', (100*units[i].hp/unitTypes[units[i].type_id].hp)+'%' );
			}else{
				var hpbarcode= '<div class="hpbar"><div class="hpbarfill" style="background-color:'+getUserColor(units[i].user_id)+';width:'+(100*units[i].hp/unitTypes[units[i].type_id].hp)+'%;"></div></div>';
				$('#map').append('<div onclick="onUnitClick('+i+');" id="unit-'+(units[i].id)+'" class="item unit unit-type-'+units[i].type_id+'" style="position:absolute;top:'+toMapY(p[1])+'px;left:'+toMapX(p[0])+'px;width:'+(gridSize/2)+'px;height:'+(gridSize/2)+'px;">'+hpbarcode+'</div>');
			}
		}
	///@test update corpses position
	for( var i=0;i<corpses.length;i++){
		var o= $('#corpse-'+i);
		o.css('top',toMapY(corpses[i].y)+'px');
		o.css('left',toMapX(corpses[i].x)+'px');
	}
}

function getTime(){
	var d= new Date();
	// return d.getTime()*1000+d.getMilliseconds();
	return d.getTime() - timeServerDelay;
}

function cronPerFrame(){
	// console.log('cronPerFrame');
	updateMap();
}

/// download data from server
///@todo if our unit disapear then add corpse in it's place
function cronDataUpdate(){
	///@todo limit of witch parts are we updating
	var screenSize= Math.max( $('body').width(), $('body').height() ) / gridSize;
	$.ajax('?mod=update&minx='+(mapX-screenSize)+'&max='+(mapX+2*screenSize)+'&miny='+(mapY-screenSize)+'&may='+(mapY+2*screenSize)+'',{
		success: function(res){
			// console.log('ajax success');
			// console.log(res);
			var data= JSON.parse(res);
			
			// users= data.p;
			for(var i=0;i<data.p.length;i++)
				users[data.p[i].id]= data.p[i];

			///@test if our building disapear then add corpse in it's place
			for(var i=0;i<buildings.length;i++)
				if( buildings[i]!==undefined && buildings[i]!==null && buildings[i].user_id==userId )
				{
					var h= false;
					for(var j=0;j<data.b.length;j++)
						if( data.b[j].id==buildings[i].id ){
							h= true;
							break;
						}
					if( !h ){
						$('#building-'+buildings[i].id).remove();
						addCorpse( buildings[i].x, buildings[i].y );
					}
				}

			// buildings= data.b;
			buildings= new Array();
			for(var i=0;i<data.b.length;i++)
				buildings[data.b[i].id]= data.b[i];

			///@test if our building disapear then add corpse in it's place
			for(var i=0;i<units.length;i++)
				if( units[i]!==undefined && units[i]!==null && units[i].user_id==userId )
				{
					var h= false;
					for(var j=0;j<data.u.length;j++)
						if( data.u[j].id==units[i].id ){
							h= true;
							break;
						}
					if( !h ){
						$('#map unit-'+units[i].id).remove();
						addCorpse( units[i].x, units[i].y );
					}
				}

			// units= data.u;
			units= new Array();
			for(var i=0;i<data.u.length;i++)
				units[data.u[i].id]= data.u[i];

			///@test delete unit DOM objects, that we don't have on units list
			var unitDooms= $('#map .unit');
			for( var i=0;i<unitDooms.length;i++){
				var id= unitDooms[i].id.substr(5);
				if( units[id]===undefined || units[id]===null || units[id].hp<=0 ){
					unitDooms[i].remove();
				}
			}

			///@test delete unit DOM objects, that we don't have on units list
			var dooms= $('#map .building');
			for( var i=0;i<dooms.length;i++){
				var id= dooms[i].id.substr(9);
				if( buildings[id]===undefined || buildings[id]===null ){
					dooms[i].remove();
				}
			}

			/// update user data
			///@todo that can be calculated in JS, no need to abuse server
			$('#gold').html(data.y.gold);
			$('#score').html(data.y.score);

			// console.log(units);
		},
		error: function(){
			console.log('ajax fail in cronDataUpdate');
		}
	});
}

function unselectUnit(){
	if( selectedUnitId!==null ){
		if( units[selectedUnitId]!==undefined && units[selectedUnitId]!==null )
			$('#unit-'+units[selectedUnitId].id).removeClass('selected');
		selectedUnitId= null;
	}
}

function unselectBuilding(){
	if( selectedBuildingId!==null ){
		$('#menu').html('Please click something');
		if( buildings[selectedBuildingId]!==undefined && buildings[selectedBuildingId]!==null ){
			$('#building-'+buildings[selectedBuildingId].id).removeClass('selected');
		}
		selectedBuildingId= null;
	}
}

function showAsDead(unitId){
	if( units[unitId]===undefined || units[unitId]===null )
		return;
	
	console.log('showing as dead unit '+unitId);
	addCorpse( units[unitId].x, units[unitId].y );
	$('#unit-'+unitId).remove();
	units[unitId]= null;
}

function addCorpse(px,py){
	var id= corpses.length;
	corpses[id]= { x:px, y:py, utime:getTime() };
	$('#map').append('<div id="corpse-'+id+'" class="item corpse" style="top:'+toMapY(py)+'px;left:'+toMapX(px)+'px;width:'+(gridSize/2)+'px;height:'+(gridSize/2)+'px;">'+'</div>');
}

function onUnitClick(unitId){
	if( units[unitId]===undefined || units[unitId]===null || units[unitId].hp <= 0){
		console.log('undefined unit clicked. Its probably dead already');
		//showAsDead(unitId);
		return;
	}
	/// if it's not our unit then attack it with our selected unit
	if( units[unitId].user_id != userId ){
		/// if we have our unit selected then attack that unit
		if( selectedUnitId===null || units[selectedUnitId]===undefined || units[selectedUnitId]===null ){
			console.log('can not attack unit. you don\'t have any your units selected');
			return;
		}

		units[selectedUnitId].target_unit_id= unitId;

		unitAttackUnit( selectedUnitId, unitId );

	}else{
		/// select unit
		unselectBuilding();
		unselectUnit();
		selectedUnitId= unitId;
		$('#unit-'+units[selectedUnitId].id).addClass('selected');
		console.log('selecting unit '+unitId);
		///@todo show nice icon in html
		$('#menu').html('<div>Let\'s kill something</div>');
	}
}

function unitAttackUnit(unit1ID, unit2ID){
	if( 
		unit1ID===undefined || unit1ID===null || units[unit1ID]===undefined || units[unit1ID]===null || units[unit1ID].hp < 0 ||
		unit2ID===undefined || unit2ID===null || units[unit2ID]===undefined || units[unit2ID]===null || units[unit2ID].hp < 0
	)
		return;

	if( units[unit1ID].user_id != userId || units[unit2ID].user_id == userId )
		return;


	/// if we have our unit selected then attack that unit
	var t= getTime();
	if( t < units[unit1ID].la + unitTypes[units[unit1ID].type_id].cooldown ){
		return;
	}

	var pu= getCurrentUnitPosition(units[unit1ID],t);
	var pt= getCurrentUnitPosition(units[unit2ID],t);
	if(  unitTypes[units[unit1ID].type_id].range < Math.sqrt( (pu[0]-pt[0])*(pu[0]-pt[0]) + (pu[1]-pt[1])*(pu[1]-pt[1]) ) ){
		console.log('unit to far away to attack');
		return;
	}
	/// try to attack units[unit2ID]
	var attackingUnitId= unit1ID;
	$.ajax('?mod=attack&unitId='+units[attackingUnitId].id+'&targetId='+units[unit2ID].id+'',{
		success: function(res){
			if( res=='ok' ){
				console.log('unit attacked');
				units[attackingUnitId].la= getTime();
				units[unit2ID].hp -= unitTypes[units[attackingUnitId].type_id].attack;
				if( units[unit2ID].hp <= 0 ){
					showAsDead(unit2ID);
				}
			}else{
				console.log('attacking unit fail\n'+res);
			}
		},
		error: function(){
			console.log('ajax fail');
		}
	});
}

///@test cron for auto attacking units
function cronUnitAttackUnit(){
	// console.log('cronUnitAttackUnit');
	var t= getTime();
	for( var i=0;i<units.length;i++){
		if( units[i]!==undefined && units[i]!==null && units[i].user_id==userId && 0 < units[i].hp && units[i].la + unitTypes[units[i].type_id].cooldown < t ){
			var pu= getCurrentUnitPosition(units[i],t); /// position of our unit
			/// try attack unit selected by user
			var hitted= false;
			if( units[i].target_unit_id!==undefined && units[i].target_unit_id!==null && units[units[i].target_unit_id]!==undefined && units[units[i].target_unit_id]!==null ){
				var pt= getCurrentUnitPosition(units[units[i].target_unit_id],t);
				var dis= Math.sqrt( (pu[0]-pt[0])*(pu[0]-pt[0]) + (pu[1]-pt[1])*(pu[1]-pt[1]) );
				if( dis < unitTypes[units[i].type_id].range ){
					unitAttackUnit( i, bestId );
					hitted= true;
				}
			}
			// console.log(hitted);
			if( !hitted ){
				/// find closest enemy
				var bestDis= 1000000.0;
				var bestId= null;
				// console.log(units[i]);
				for( var j=0;j<units.length;j++){
					if( units[j]!==undefined && units[j]!==null && units[j].user_id!=userId && 0 < units[j].hp ){
						/// check distance
						var pt= getCurrentUnitPosition(units[j],t);
						var dis= Math.sqrt( (pu[0]-pt[0])*(pu[0]-pt[0]) + (pu[1]-pt[1])*(pu[1]-pt[1]) );
						if( dis < bestDis ){
							bestDis= dis;
							bestId= j;
						}
					}
				}
				// console.log(bestId);
				/// attack best one
				if( bestId!==null && bestDis < unitTypes[units[i].type_id].range ){
					unitAttackUnit( i, bestId );
					hitted= true;
				}
			}
			if( !hitted ){
				///@test try attack buildings
				/// find closest enemy
				var bestDis= 1000000.0;
				var bestId= null;
				for( var j=0;j<buildings.length;j++){
					if( buildings[j]!==undefined && buildings[j]!==null && buildings[j].user_id!=userId && 0 < buildings[j].hp ){
						/// check distance
						var pt= [buildings[j].x,buildings[j].y];
						var dis= Math.sqrt( (pu[0]-pt[0])*(pu[0]-pt[0]) + (pu[1]-pt[1])*(pu[1]-pt[1]) );
						if( dis < bestDis ){
							bestDis= dis;
							bestId= j;
						}
					}
				}
				/// attack best one
				if( bestId!==null && bestDis < unitTypes[units[i].type_id].range ){
					unitAttackBuilding( i, bestId );
					hitted= true;
				}
			}
		}
	}
}

function unitAttackBuilding(unitId, buildingId){
	/// if we have our unit selected then attack that building
	if( unitId===null || units[unitId]===undefined || units[unitId]===null ){
		return false;
	}
	if( getTime() < units[unitId].la + unitTypes[units[unitId].type_id].cooldown ){
		console.log('can not attack, still cooling down');
		return false;
	}
	if( buildings[buildingId].hp <= 0 ){
		console.log('that building seem to be already dead');
		return;
	}
	var t= getTime();
	var pu= getCurrentUnitPosition(units[unitId],t);
	var pt= [ buildings[buildingId].x , buildings[buildingId].y ];
	if(  unitTypes[units[unitId].type_id].range < Math.sqrt( (pu[0]-pt[0])*(pu[0]-pt[0]) + (pu[1]-pt[1])*(pu[1]-pt[1]) ) ){
		console.log('unit to far away to attack');
		return;
	}
	///@test try to attack building[buildingId]
	var attackingUnitId= unitId;
	$.ajax('?mod=attack-building&unitId='+units[attackingUnitId].id+'&targetId='+buildings[buildingId].id+'',{
		success: function(res){
			if( res=='ok' ){
				console.log('building attacked');
				units[attackingUnitId].la= getTime();
				buildings[buildingId].hp -= unitTypes[units[attackingUnitId].type_id].attack;
				if( buildings[buildingId].hp <= 0){
					console.log('building destroyed');
					///@todo addCorpse( buildings[buildingId].x+0.25, buildings[buildingId].y+0.25 );
					addCorpse( buildings[buildingId].x, buildings[buildingId].y );
					$('#building-'+buildings[buildingId].id).hide();
					$('#building-'+buildings[buildingId].id).remove();
				}
			}else{
				console.log('attacking building fail\n'+res);
			}
		},
		error: function(){
			console.log('ajax fail');
		}
	});
	return true;
}

/// building onclick
function onBuildingClick(buildingId){
	/// make sure it's our unit
	if( buildings[buildingId].user_id != userId ){
		console.log('it\'s not your building');
		/// if we have our unit selected then attack that building
		if( selectedUnitId===null || units[selectedUnitId]===undefined || units[selectedUnitId]===null ){
			console.log('can not attack building. you don\'t have any your units selected');
			return;
		}
		return unitAttackBuilding( selectedUnitId, buildingId );
	}
	/// select this building
	unselectBuilding();
	unselectUnit();
	selectedBuildingId= buildingId;
	$('#building-'+buildings[selectedBuildingId].id).addClass('selected');
	// console.log('selecting building '+buildingId);
	///@todo show nice icon in html
	if( false ){
	}else if( buildings[selectedBuildingId].type_id==1 ){
		$('#menu').html('');
		for(var i=0;i<buildingTypes.length;i++){
			// list of possible buildings to build
			var inoptionstr= '<div><img src="img/building-'+i+'.png" alt="'+buildingTypes[i].name+'" title="'+buildingTypes[i].name+'" /></div><div class="price"><img src="img/bitcoin.png" alt="B" />'+(buildingTypes[i].cost)+'</div><div class="build_time">'+timeToStr(buildingTypes[i].build_time)+'s</div>';
			if( buildings[selectedBuildingId].task_id==0 ){
				$('#menu').append('<div class="makeoption">'+inoptionstr+'<div class="buttonHolder"><button onclick="startPrebuilding('+buildingId+','+i+');">Build</button></div></div>');
			}else if(buildings[selectedBuildingId].task_id == 100+i){
				buildings[buildingId].task_end_time= parseInt(buildings[buildingId].task_end_time);
				// console.log(getTime());
				// console.log(buildings[buildingId].task_end_time);
				if( getTime() <= parseInt(buildings[buildingId].task_end_time) ){
					$('#menu').append('<div class="makeoption">'+inoptionstr+'<div class="progressbar"><div class="progress"></div></div></div>');
				}else{
					$('#menu').append('<div class="makeoption">'+inoptionstr+'<div class="buttonHolder"><button onclick="startBuildPlaceSelecting('+selectedBuildingId+');">Place</button></div></div>');
				}
			}else{
				$('#menu').append('<div class="makeoption">'+inoptionstr+' </div>');
			}
		}
	}else if( buildings[selectedBuildingId].type_id==2 || buildings[selectedBuildingId].type_id==3 ){
		var typeId= buildings[selectedBuildingId].type_id;
		/// list of units
		$('#menu').html('');
		for(var i=0;i<unitTypes.length;i++)
			if( unitTypes[i].train_in==typeId )
			{
				var inoptionstr= '<div><img src="img/unit-'+i+'.png" alt="'+unitTypes[i].name+'" /></div><div class="price"><img src="img/bitcoin.png" alt="B" />'+(unitTypes[i].cost)+'</div><div class="build_time">'+timeToStr(unitTypes[i].build_time)+'s</div>';
				if( buildings[selectedBuildingId].task_id==0 ){
					$('#menu').append('<div class="makeoption">'+inoptionstr+'<div class="buttonHolder"><button onclick="startUnitTraining('+buildingId+','+i+');">Recrut</button></div></div>');
				}else if(buildings[selectedBuildingId].task_id == 200+i){
					buildings[buildingId].task_end_time= parseInt(buildings[buildingId].task_end_time);
					$('#menu').append('<div class="makeoption">'+inoptionstr+'<div class="progressbar"><div class="progress"></div></div></div>');
				}else{
					$('#menu').append('<div class="makeoption">'+inoptionstr+' </div>');
				}
			}
	}else if( buildings[selectedBuildingId].type_id==0 ){
		$('#menu').html('Bitcoin minig speed: 1GH/s');
	}else if( buildings[selectedBuildingId].type_id==4 ){
		$('#menu').html('Coding demo for Revision');
	}else{
		$('#menu').html('');
	}
}

/// keep updating progressbar of building buildings or recruting units
function cronUpdateBuildingProgressBar(){
	if( selectedBuildingId!==null && buildings[selectedBuildingId]!==undefined && buildings[selectedBuildingId]!==null && ( buildings[selectedBuildingId].type_id==1 || buildings[selectedBuildingId].type_id==2 || buildings[selectedBuildingId].type_id==3 )  ){
		var b= buildings[selectedBuildingId];
		if( 100 <= b.task_id ){
			var atime= getTime();
			if( b.task_end_time < atime ){
				/// progressbar reached end
				if( buildings[selectedBuildingId].type_id==2 || buildings[selectedBuildingId].type_id==3 ){
					buildings[selectedBuildingId].task_id= 0;
					onBuildingClick(selectedBuildingId);
				}else if( 0 < $('#menu .makeoption .progressbar .progress').length ){
					onBuildingClick(selectedBuildingId);
				}
			}else{
				var bot;
				if( 200 <= b.task_id ){
					/// unit
					bot= unitTypes[b.task_id-200];
				}else{
					/// building
					bot= buildingTypes[b.task_id-100];
				}
				var startTime= b.task_end_time - bot.build_time;
				var progress= (atime - startTime) / bot.build_time;
				$('#menu .makeoption .progressbar .progress').css('width',(100*progress)+'%');
			}
		}
	}
}

function startPrebuilding(mainBuildingId,buildingTypeId){
	$.ajax('?mod=prebuild&buildingId='+buildings[mainBuildingId].id+'&buildingTypeId='+buildingTypeId+'',{
		success: function(res){
			if( res!="ok" ){
				console.log("wrong response from server in startPrebuilding\n"+res);
			}else{
				console.log("start prebuilding "+buildingTypeId+" in "+mainBuildingId);
				buildings[mainBuildingId].task_id= 100 + buildingTypeId;
				buildings[mainBuildingId].task_end_time = getTime() + buildingTypes[buildingTypeId].build_time;
				buildings[mainBuildingId].utime= getTime();
				onBuildingClick(mainBuildingId);
			}
		},
		error: function(){
			console.log('ajax fail on startPrebuilding');
		}
	});
}

function startBuildPlaceSelecting(mainBuildingId){
	console.log('start building place selcting from '+mainBuildingId);
	selectBuildPlaceForMainBuildingId= mainBuildingId;
}

function onMapClick(x,y){
	console.log('onMapClick '+x+' '+y);
	if( selectBuildPlaceForMainBuildingId!==null ){
		///@test  place prebuilded building on map
		console.log('placing prebuilded building on map. sending request to server');
		var mbId= selectBuildPlaceForMainBuildingId;
		$.ajax('?mod=build&mainBuildingId='+buildings[selectBuildPlaceForMainBuildingId].id+'&x='+toServerX(x)+'&y='+toServerY(y),{
			success: function(res){
				if( res!="ok" ){
					console.log("wrong response from server during building on map\n"+res);
				}else{
					/// fake mb data
					buildings[mbId].task_id= 0;
					onBuildingClick(mbId);
					///@todo speed up redownloading data from server
				}
			},
			error: function(){
				console.log('ajax fail on startPrebuilding');
			}
		});
		selectBuildPlaceForMainBuildingId= null;
	}else if( selectedUnitId!==null && units[selectedUnitId]!==undefined && units[selectedUnitId]!==null ){
		/// make unit move to clicked location
		x -= gridSize/4;
		y -= gridSize/4;
		$.ajax('?mod=unit-move&unitId='+(units[selectedUnitId].id)+'&x='+toServerX(x)+'&y='+toServerY(y)+'',{
			success: function(res){
				// console.log('ajax success');
				/// update our data to know that we are moving as planed
				var t= getTime();
				var p= getCurrentUnitPosition(units[selectedUnitId], t );
				units[selectedUnitId].x= p[0];
				units[selectedUnitId].y= p[1];
				units[selectedUnitId].tx= toServerX(x);
				units[selectedUnitId].ty= toServerY(y);
				units[selectedUnitId].utime= t;
			},
			error: function(){
				console.log('ajax fail');
			}
		});
	}
}

/// send info to server to start unit training in building
function startUnitTraining( buildingId, unitTypeId){
	///@test at all
	$.ajax('?mod=train&buildingId='+buildings[buildingId].id+'&unitTypeId='+unitTypeId+'',{
		success: function(res){
			if( res!="ok" ){
				console.log("wrong response from server during building on map\n"+res);
			}else{
				if( selectedBuildingId==buildingId){
					buildings[buildingId].task_id= 200 + unitTypeId;
					buildings[buildingId].task_end_time = getTime() + unitTypes[unitTypeId].build_time;
					buildings[buildingId].utime= getTime();
					onBuildingClick(buildingId);
				}
			}
		},
		error: function(){
			console.log('ajax fail on startPrebuilding');
		}
	});
}

/// update html with session time, and after session redirect to top list
function cronSessionTimeUpdate(){
	if( getTime() <= sessionStartTime ){
		$('#sessionStartTimeLeft').html(timeToStr(sessionStartTime-getTime()));
	}else if(getTime() < sessionEndTime){
		/// static variable in JS
		if( typeof cronSessionTimeUpdate.backScreenHiden == 'undefined' ){
			cronSessionTimeUpdate.backScreenHiden= false;
		}
		if( !cronSessionTimeUpdate.backScreenHiden ){
			$('#beforeSessionStartsCountDown').remove();
			cronSessionTimeUpdate.backScreenHiden= true;
		}
		/// update timmer somewhere in menu
		$('.sessionTime').html(timeToStr(sessionEndTime-getTime()));
	}else{
		window.location= '?mod=top';
	}
}


/// handle key pressing (officialy it's not handling control, alt, etc)
function onKeyPress(event){
	if( false ){
	}else if( event.key=="ArrowUp" ){
		mapY-=3;updateMap();
	}else if( event.key=="ArrowDown" ){
		mapY+=3;updateMap();
	}else if( event.key=="ArrowLeft" ){
		mapX-=3;updateMap();
	}else if( event.key=="ArrowRight" ){
		mapX+=3;updateMap();
	}
}

function onKeyDown(event){
}

function onKeyUp(event){
}

/// on ready
$(function(){
	updateMap();
	setInterval('cronPerFrame()', 50);
	setInterval('cronUpdateBuildingProgressBar()', 100);
	setInterval('cronDataUpdate()', 1*1000);
	setInterval('cronSessionTimeUpdate()',1000);
	setInterval('cronUnitAttackUnit()',600); // that can be skiped for optimisation, but then user will need to make click for every single shot
	// setInterval('window.location=window.location;', 600*1000); ///@todo delete that
});
