/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.screens;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import modeling.ModelingKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.Cubemap;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.shape.ShapeContour;
import rndr.studio.demo.shading.FunctionsKt;
import scenes.RenderStyle;
import studio.rndr.screens.City;
import studio.rndr.screens.CityKt;
import studio.rndr.screens.CityStyle;
import studio.rndr.screens.MapScene;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lstudio/rndr/screens/City;", "", "()V", "floor", "Lorg/openrndr/draw/VertexBuffer;", "irradiance", "Lorg/openrndr/draw/Cubemap;", "getIrradiance", "()Lorg/openrndr/draw/Cubemap;", "mesh", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "getPreviousViewMatrix", "()Lorg/openrndr/math/Matrix44;", "setPreviousViewMatrix", "(Lorg/openrndr/math/Matrix44;)V", "style", "Lstudio/rndr/screens/CityStyle;", "getStyle", "()Lstudio/rndr/screens/CityStyle;", "setStyle", "(Lstudio/rndr/screens/CityStyle;)V", "vertexCount", "", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "time", "", "renderStyle", "Lscenes/RenderStyle;", "demo-strap"})
public final class City {
    @NotNull
    private final Cubemap irradiance = Cubemap.Companion.fromUrl("file:data/textures/evening_irr_hdr32.dds");
    @NotNull
    private CityStyle style = new CityStyle(ColorRGBa.Companion.getWHITE().shade(0.25), 1.0, 0.0, 0.0, 0.0, null, 0.0, 120, null);
    private final VertexBuffer floor = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(floor.1.INSTANCE), 40);
    private final VertexBuffer mesh = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(mesh.1.INSTANCE), 600000);
    private final int vertexCount;
    @NotNull
    private Matrix44 previousViewMatrix;

    @NotNull
    public final Cubemap getIrradiance() {
        return this.irradiance;
    }

    @NotNull
    public final CityStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull CityStyle cityStyle) {
        Intrinsics.checkParameterIsNotNull(cityStyle, "<set-?>");
        this.style = cityStyle;
    }

    @NotNull
    public final Matrix44 getPreviousViewMatrix() {
        return this.previousViewMatrix;
    }

    public final void setPreviousViewMatrix(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousViewMatrix = matrix44;
    }

    public final void draw(@NotNull Drawer drawer, double time, @NotNull RenderStyle renderStyle) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(renderStyle, "renderStyle");
        RenderTarget gbuffer = RenderTarget.Companion.getActive();
        drawer.pushModel();
        drawer.translate(-200.0, 0.0, 200.0);
        drawer.rotate(Vector3.Companion.getUNIT_X(), -90.0);
        drawer.pushStyle();
        drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this, time, renderStyle, gbuffer){
            final /* synthetic */ City this$0;
            final /* synthetic */ double $time;
            final /* synthetic */ RenderStyle $renderStyle;
            final /* synthetic */ RenderTarget $gbuffer;

            public final void invoke(@NotNull ShadeStyle $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.parameter("time", this.$time);
                $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n\n                    #define HASHSCALE 443.8975\n                    vec2 hash22(vec2 p) {\n\t                    vec3 p3 = fract(vec3(p.xyx) * HASHSCALE);\n                        p3 += dot(p3, p3.yzx+19.19);\n                        return fract(vec2((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y));\n                    }\n                    " + FunctionsKt.getShadowOrthoFunction() + "\n                ");
                $receiver.setVertexTransform("\n                    previousView = (p_previousModelView * vec4(x_position,1.0));\n                    previousClip = u_projectionMatrix * previousView;\n                    currentClip = u_projectionMatrix * u_viewMatrix * u_modelMatrix * vec4(x_position, 1.0);\n                ");
                $receiver.setFragmentTransform("\n                    o_position.xyz = v_viewPosition;\n                    o_position.w = max(-1.0, v_viewPosition.z/400.0);\n\n                    o_normal.xyz = normalize(v_viewNormal + vec3(0.0, 0.1, 0.0) * smoothstep(0.9,1.0, mod(v_worldPosition.y*1.0,1.0))) ;\n\n                    o_normal.w = 1.0 * (1.0-smoothstep(0.9,1.0, mod(v_worldPosition.y*1.0,1.0)));\n                    o_velocity.xy = vec2(0.0, 0.0);\n\n                    float soft = smoothstep(0.0, 1.0, mod(v_worldPosition.y, 1.0)) * smoothstep(1.0, 0.0, mod(v_worldPosition.y, 1.0));\n\n                    float divisions = 15.0+ (cos(va_objectId*0.432)*10.0);\n\n                    float useg = floor(va_texCoord0.x*divisions);\n                    float vseg = floor(v_worldPosition.y);\n\n                    float o = cos(floor(va_objectId+0.5)*0.7931);\n                    vec2 n2 = hash22(vec2(useg+o, vseg));\n                    float emissive = (int(v_worldPosition.y+va_objectId  +useg )%2)*5.2 * soft * 0.0;\n\n\n                    float tr = cos(va_objectId*0.9323);\n                    float e = n2.x > (0.990 + tr*0.05 + (1.0-p_lightDensity)*0.05*2 ) ? 1.0 : 0.0;\n\n                    e *= smoothstep(0.0, 0.1, va_texCoord0.x*divisions-useg) * smoothstep(1.0, 0.9, va_texCoord0.x*divisions-useg) * smoothstep(0.0, 0.5, v_worldPosition.y-vseg) *  smoothstep(1.0, 0.9, v_worldPosition.y-vseg);;\n                    float brick = 1.0;\n\n                    //x_fill.rgb +=  p_upIntensity *(va_normal.z);\n                    //\n\n                    vec3 skyColor = vec3(cos(va_objectId)*0.2+0.8) ;\n                    float shadow = 1.0;\n                    " + (this.$renderStyle.getLights().size() > 0 ? "\n                    shadow = shadowOrtho(p_lightMap, v_worldPosition, v_worldNormal, p_lightProj, p_lightView);\n                    skyColor.rgb *= (0.5 + 0.5 * shadow); " : "") + "\n\n                    x_fill.rgb = pow(texture(p_irradiance, normalize(v_worldNormal)).rgb, vec3(1.0)) * skyColor * 0.2 * (mix(0.0, 0.2, brick)) * (min(v_worldPosition.y/10.0, 1.0)) * (1.0-smoothstep(0.9,1.0, mod(v_worldPosition.y*1.0,1.0)))  + e * vec3(0.4+cos(va_objectId*0.432)*0.05, 0.3+cos(va_objectId*0.123)*0.05, 0.2)*(3.0 + 1.0 * cos(n2.y+va_objectId));\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720) * 0.08;\n\n                    x_fill.rgb *= 5.0;\n\n                    // -- hazing\n                    float haze = min(1.0, -v_viewPosition.z/400.0);\n                    vec3 viewDirection = normalize(inverse(mat3(u_viewNormalMatrix)) * v_viewPosition);\n                    vec3 hazeColor = texture(p_irradiance, viewDirection).rgb * p_skyIntensity;\n\n                    x_fill.rgb = mix(max(vec3(0.0), x_fill.rgb), hazeColor, haze);\n\n//                    if (cos(v_worldPosition.x * 1 + p_time + va_objectId) > 0.0  && v_worldPosition.y > 30.0)  {\n//                    discard;\n//                    }\n\n                    ");
                $receiver.output("position", this.$gbuffer.colorBufferIndex("position"));
                $receiver.output("normal", this.$gbuffer.colorBufferIndex("normal"));
                $receiver.output("velocity", this.$gbuffer.colorBufferIndex("velocity"));
                $receiver.parameter("previousViewMatrix", this.this$0.getPreviousViewMatrix());
                $receiver.parameter("patternIntensity", this.this$0.getStyle().getPatternIntensity());
                $receiver.parameter("upIntensity", this.this$0.getStyle().getUpIntensity());
                $receiver.parameter("explode", this.this$0.getStyle().getExplode());
                $receiver.parameter("selected", this.this$0.getStyle().getSelected());
                $receiver.parameter("irradiance", this.this$0.getIrradiance());
                $receiver.parameter("previousModelView", this.this$0.getPreviousViewMatrix());
                $receiver.parameter("skyIntensity", this.$renderStyle.getSkyIntensity());
                $receiver.parameter("lightDensity", this.$renderStyle.getLightDensity());
                $receiver.parameter("time", this.$time);
                if (this.$renderStyle.getLights().size() > 0) {
                    $receiver.parameter("lightMap", this.$renderStyle.getLights().get(0).getMap());
                    $receiver.parameter("lightProj", this.$renderStyle.getLights().get(0).getProjection());
                    $receiver.parameter("lightView", this.$renderStyle.getLights().get(0).getView());
                }
            }
            {
                this.this$0 = city;
                this.$time = d;
                this.$renderStyle = renderStyle;
                this.$gbuffer = renderTarget;
                super(1);
            }
        }));
        drawer.setFill(this.style.getFill());
        ShadeStyle shadeStyle = drawer.getShadeStyle();
        if (shadeStyle != null) {
            shadeStyle.parameter("upIntensity", this.style.getUpIntensity());
        }
        ShadeStyle shadeStyle2 = drawer.getShadeStyle();
        if (shadeStyle2 != null) {
            shadeStyle2.parameter("patternIntensity", this.style.getPatternIntensity());
        }
        drawer.vertexBuffer(this.mesh, DrawPrimitive.TRIANGLES, 0, this.vertexCount);
        this.previousViewMatrix = drawer.getView().times(drawer.getModel());
        drawer.popStyle();
        drawer.popModel();
    }

    public static /* bridge */ /* synthetic */ void draw$default(City city, Drawer drawer, double d, RenderStyle renderStyle, int n2, Object object) {
        if ((n2 & 4) != 0) {
            renderStyle = new RenderStyle();
        }
        city.draw(drawer, d, renderStyle);
    }

    public City() {
        final MapScene map = CityKt.loadMapScene(new File("data/meshes/map.json.lzma"));
        this.vertexCount = this.mesh.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Random random = new Random(303808909L);
                Iterable iterable = $receiver$iv = (Iterable)map.getBuildings();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                int index$iv$iv = 0;
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void idx;
                    void it2;
                    int n2 = index$iv$iv++;
                    List list = (List)item$iv$iv;
                    int n3 = n2;
                    Collection collection = destination$iv$iv;
                    ModelingKt.extrudeContourUV$default(ShapeContour.Companion.fromPoints((List<Vector2>)it2, true), 5.0 + random.nextDouble() * 50.0, (double)idx + 1.0, $receiver, true, false, 0.0, 96, null);
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        });
        this.previousViewMatrix = Matrix44.Companion.getIDENTITY();
    }
}

