/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.FontImageMapDrawer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Rectangle;
import org.openrndr.text.Cursor;
import org.openrndr.text.RenderToken;
import org.openrndr.text.WriteStyle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020(H\u0002J\u0006\u0010*\u001a\u00020%J \u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000203J\u0006\u00105\u001a\u00020%J\u0018\u0010-\u001a\u00020%2\u0006\u0010-\u001a\u00020.2\b\b\u0002\u00106\u001a\u000200J\u000e\u00107\u001a\u0002032\u0006\u0010-\u001a\u00020.R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00068"}, d2={"Lorg/openrndr/text/Writer;", "", "drawer", "Lorg/openrndr/draw/Drawer;", "(Lorg/openrndr/draw/Drawer;)V", "value", "Lorg/openrndr/shape/Rectangle;", "box", "getBox", "()Lorg/openrndr/shape/Rectangle;", "setBox", "(Lorg/openrndr/shape/Rectangle;)V", "cursor", "Lorg/openrndr/text/Cursor;", "getCursor", "()Lorg/openrndr/text/Cursor;", "setCursor", "(Lorg/openrndr/text/Cursor;)V", "Lorg/openrndr/draw/DrawStyle;", "drawStyle", "getDrawStyle", "()Lorg/openrndr/draw/DrawStyle;", "setDrawStyle", "(Lorg/openrndr/draw/DrawStyle;)V", "getDrawer", "()Lorg/openrndr/draw/Drawer;", "style", "Lorg/openrndr/text/WriteStyle;", "getStyle", "()Lorg/openrndr/text/WriteStyle;", "setStyle", "(Lorg/openrndr/text/WriteStyle;)V", "styleStack", "Ljava/util/Stack;", "getStyleStack", "()Ljava/util/Stack;", "emitToken", "", "renderTokens", "", "Lorg/openrndr/text/RenderToken;", "renderToken", "gaplessNewLine", "makeRenderTokens", "", "text", "", "mustFit", "", "move", "x", "", "y", "newLine", "visible", "textWidth", "openrndr-core"})
public final class Writer {
    @NotNull
    private Cursor cursor;
    @NotNull
    private Rectangle box;
    @NotNull
    private WriteStyle style;
    @NotNull
    private final Stack<WriteStyle> styleStack;
    @NotNull
    private DrawStyle drawStyle;
    @Nullable
    private final Drawer drawer;

    @NotNull
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@NotNull Cursor cursor) {
        Intrinsics.checkParameterIsNotNull(cursor, "<set-?>");
        this.cursor = cursor;
    }

    @NotNull
    public final Rectangle getBox() {
        return this.box;
    }

    public final void setBox(@NotNull Rectangle value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.box = value;
        this.cursor.setX(value.getCorner().getX());
        this.cursor.setY(value.getCorner().getY());
    }

    @NotNull
    public final WriteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull WriteStyle writeStyle) {
        Intrinsics.checkParameterIsNotNull(writeStyle, "<set-?>");
        this.style = writeStyle;
    }

    @NotNull
    public final Stack<WriteStyle> getStyleStack() {
        return this.styleStack;
    }

    @NotNull
    public final DrawStyle getDrawStyle() {
        Object object = this.drawer;
        if (object == null || (object = ((Drawer)object).getDrawStyle()) == null) {
            object = this.drawStyle;
        }
        return object;
    }

    public final void setDrawStyle(@NotNull DrawStyle value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        this.drawStyle = this.getDrawStyle();
    }

    public final void newLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + ((fontMap != null ? fontMap.getLeading() : 0.0) + this.style.getLeading()));
    }

    public final void gaplessNewLine() {
        this.cursor.setX(this.box.getCorner().getX());
        Cursor cursor = this.cursor;
        FontMap fontMap = this.getDrawStyle().getFontMap();
        cursor.setY(cursor.getY() + (fontMap != null ? fontMap.getHeight() : 0.0));
    }

    public final void move(double x, double y) {
        Cursor cursor = this.cursor;
        cursor.setX(cursor.getX() + x);
        Cursor cursor2 = this.cursor;
        cursor2.setY(cursor2.getY() + y);
    }

    /*
     * WARNING - void declaration
     */
    public final double textWidth(@NotNull String text) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(text, "text");
        CharSequence $receiver$iv = text;
        double sum$iv = 0.0;
        CharSequence charSequence = $receiver$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void it2;
            char element$iv;
            char c = element$iv = charSequence.charAt(i);
            double d = sum$iv;
            FontMap fontMap = this.getDrawStyle().getFontMap();
            if (fontMap == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            GlyphMetrics glyphMetrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf((char)it2));
            double d2 = glyphMetrics != null ? glyphMetrics.getAdvanceWidth() : 0.0;
            sum$iv = d + d2;
        }
        return (double)var3_3;
    }

    public final void text(@NotNull String text, boolean visible) {
        block3: {
            Intrinsics.checkParameterIsNotNull(text, "text");
            List<RenderToken> renderTokens = this.makeRenderTokens(text, false);
            if (!visible) break block3;
            Drawer drawer = this.drawer;
            if (drawer != null) {
                Drawer drawer2;
                Drawer d = drawer2 = drawer;
                FontImageMapDrawer renderer = d.getFontImageMapDrawer$openrndr_core();
                Iterable $receiver$iv = renderTokens;
                for (Object element$iv : $receiver$iv) {
                    RenderToken it2 = (RenderToken)element$iv;
                    FontMap fontMap = d.getDrawStyle().getFontMap();
                    if (fontMap == null) {
                        Intrinsics.throwNpe();
                    }
                    renderer.queueText(fontMap, it2.getToken(), it2.getX(), it2.getY(), this.style.getTracking());
                }
                renderer.flush(d.getContext(), d.getDrawStyle());
            }
        }
    }

    public static /* bridge */ /* synthetic */ void text$default(Writer writer, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        writer.text(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<RenderToken> makeRenderTokens(String text, boolean mustFit) {
        FontMap fontMap = this.getDrawStyle().getFontMap();
        if (fontMap != null) {
            List list;
            Collection $receiver$iv;
            FontMap fontMap2;
            FontMap font = fontMap2 = fontMap;
            boolean fits = true;
            FontMap fontMap3 = font;
            if (fontMap3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            FontImageMap cfr_ignored_0 = (FontImageMap)fontMap3;
            Object object = text;
            Object object2 = "((?<=\n)|(?=\n))";
            object2 = new Regex((String)object2);
            int n2 = 0;
            object = ((Regex)object2).split((CharSequence)object, n2);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    CharSequence charSequence = it2;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take($receiver$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $receiver$iv = list;
            Collection collection = $receiver$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] lines = stringArray;
            List tokens = new ArrayList();
            for (Object element$iv : (Object[])lines) {
                String line = (String)element$iv;
                List lineTokens = StringsKt.split$default((CharSequence)line, new String[]{" "}, false, 0, 6, null);
                tokens.addAll(lineTokens);
            }
            Cursor localCursor = new Cursor(this.cursor);
            GlyphMetrics glyphMetrics = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf(' '));
            if (glyphMetrics == null) {
                Intrinsics.throwNpe();
            }
            double spaceWidth = glyphMetrics.getAdvanceWidth();
            double verticalSpace = font.getHeight() + this.style.getLeading() + font.getLeading();
            List renderTokens = new ArrayList();
            int $i$a$1$forEach = 0;
            int n3 = tokens.size();
            while ($i$a$1$forEach < n3) {
                void i;
                String token = (String)tokens.get((int)i);
                if (Intrinsics.areEqual(token, "\n")) {
                    localCursor.setX(this.box.getCorner().getX());
                    Cursor cursor = localCursor;
                    cursor.setY(cursor.getY() + verticalSpace);
                } else {
                    CharSequence $receiver$iv2 = token;
                    double sum$iv = 0.0;
                    CharSequence charSequence = $receiver$iv2;
                    for (int j = 0; j < charSequence.length(); ++j) {
                        void it3;
                        char element$iv;
                        char c = element$iv = charSequence.charAt(j);
                        double d = sum$iv;
                        GlyphMetrics glyphMetrics2 = ((FontImageMap)font).getGlyphMetrics().get(Character.valueOf((char)it3));
                        double d2 = glyphMetrics2 != null ? glyphMetrics2.getAdvanceWidth() : 0.0;
                        sum$iv = d + d2;
                    }
                    double tokenWidth = sum$iv + this.style.getTracking() * (double)token.length();
                    if (localCursor.getX() + tokenWidth < this.box.getX() + this.box.getWidth() && localCursor.getY() <= this.box.getY() + this.box.getHeight()) {
                        Writer writer;
                        Writer $receiver = writer = this;
                        RenderToken renderToken = new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, $receiver.style.getTracking());
                        $receiver.emitToken(localCursor, renderTokens, renderToken);
                    } else {
                        if (localCursor.getY() > this.box.getCorner().getY() + this.box.getHeight()) {
                            fits = false;
                        }
                        if (localCursor.getY() + verticalSpace <= this.box.getY() + this.box.getHeight()) {
                            Cursor cursor = localCursor;
                            cursor.setY(cursor.getY() + verticalSpace);
                            localCursor.setX(this.box.getX());
                            this.emitToken(localCursor, renderTokens, new RenderToken(token, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                        } else {
                            if (!mustFit && this.style.getEllipsis() != null && this.cursor.getY() <= this.box.getY() + this.box.getHeight()) {
                                String string = this.style.getEllipsis();
                                if (string == null) {
                                    string = "";
                                }
                                this.emitToken(localCursor, renderTokens, new RenderToken(string, localCursor.getX(), localCursor.getY(), tokenWidth, this.style.getTracking()));
                                break;
                            }
                            fits = false;
                        }
                    }
                    Cursor cursor = localCursor;
                    cursor.setX(cursor.getX() + tokenWidth);
                    if (i != tokens.size() - 1) {
                        Cursor cursor2 = localCursor;
                        cursor2.setX(cursor2.getX() + spaceWidth);
                    }
                }
                ++i;
            }
            if (fits || !fits && !mustFit) {
                this.cursor = new Cursor(localCursor);
            } else {
                renderTokens.clear();
            }
            return renderTokens;
        }
        return CollectionsKt.emptyList();
    }

    static /* bridge */ /* synthetic */ List makeRenderTokens$default(Writer writer, String string, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return writer.makeRenderTokens(string, bl);
    }

    private final void emitToken(Cursor cursor, List<RenderToken> renderTokens, RenderToken renderToken) {
        renderTokens.add(renderToken);
    }

    @Nullable
    public final Drawer getDrawer() {
        return this.drawer;
    }

    public Writer(@Nullable Drawer drawer) {
        this.drawer = drawer;
        this.cursor = new Cursor(0.0, 0.0, 3, null);
        Drawer drawer2 = this.drawer;
        Drawer drawer3 = this.drawer;
        this.box = new Rectangle(Vector2.Companion.getZERO(), drawer2 != null ? (double)drawer2.getWidth() : DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), drawer3 != null ? (double)drawer3.getHeight() : DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
        this.style = new WriteStyle();
        this.styleStack = new Stack();
        this.drawStyle = new DrawStyle(null, null, null, null, 0.0, false, null, null, false, null, null, null, null, null, null, null, null, null, 262143, null);
    }
}

