/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0000H\u0086\u0004J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010/\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0000H\u0086\u0002J\u0011\u00100\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0003H\u0086\u0002J\u0011\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0000H\u0086\u0002J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0000H\u0086\u0002J$\u00105\u001a\u00020\u00142\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\bR\u0011\u0010\u001c\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u0011\u0010\u001e\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000b\u00a8\u00068"}, d2={"Lorg/openrndr/math/Vector2;", "Ljava/io/Serializable;", "x", "", "y", "(DD)V", "length", "getLength", "()D", "normalized", "getNormalized", "()Lorg/openrndr/math/Vector2;", "perpendicular", "getPerpendicular", "squaredLength", "getSquaredLength", "getX", "xx", "getXx", "xy0", "Lorg/openrndr/math/Vector3;", "getXy0", "()Lorg/openrndr/math/Vector3;", "xy01", "Lorg/openrndr/math/Vector4;", "getXy01", "()Lorg/openrndr/math/Vector4;", "getY", "yx", "getYx", "yy", "getYy", "component1", "component2", "copy", "div", "d", "dot", "right", "equals", "", "other", "", "hashCode", "", "minus", "vector2", "plus", "times", "v", "toString", "", "unaryMinus", "vector3", "z", "Companion", "openrndr-math"})
public final class Vector2
implements Serializable {
    private final double x;
    private final double y;
    @NotNull
    private static final Vector2 ZERO;
    @NotNull
    private static final Vector2 UNIT_X;
    @NotNull
    private static final Vector2 UNIT_Y;
    @NotNull
    private static final Vector2 INFINITY;
    public static final Companion Companion;

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double getSquaredLength() {
        return this.x * this.x + this.y * this.y;
    }

    @NotNull
    public final Vector2 getPerpendicular() {
        return new Vector2(-this.y, this.x);
    }

    @NotNull
    public final Vector2 getNormalized() {
        return this.div(this.getLength());
    }

    public final double dot(@NotNull Vector2 right) {
        Intrinsics.checkParameterIsNotNull(right, "right");
        return this.x * right.x + this.y * right.y;
    }

    @NotNull
    public final Vector2 getYx() {
        return new Vector2(this.y, this.x);
    }

    @NotNull
    public final Vector2 getXx() {
        return new Vector2(this.x, this.x);
    }

    @NotNull
    public final Vector2 getYy() {
        return new Vector2(this.y, this.y);
    }

    @NotNull
    public final Vector3 getXy0() {
        return new Vector3(this.x, this.y, 0.0);
    }

    @NotNull
    public final Vector4 getXy01() {
        return new Vector4(this.x, this.y, 0.0, 1.0);
    }

    @NotNull
    public final Vector3 vector3(double x, double y, double z) {
        return new Vector3(x, y, z);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Vector3 vector3$default(Vector2 vector2, double d, double d2, double d3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = vector2.x;
        }
        if ((n2 & 2) != 0) {
            d2 = vector2.y;
        }
        if ((n2 & 4) != 0) {
            d3 = 0.0;
        }
        return vector2.vector3(d, d2, d3);
    }

    @NotNull
    public final Vector2 unaryMinus() {
        return new Vector2(-this.x, -this.y);
    }

    @NotNull
    public final Vector2 plus(@NotNull Vector2 vector2) {
        Intrinsics.checkParameterIsNotNull(vector2, "vector2");
        return new Vector2(this.x + vector2.x, this.y + vector2.y);
    }

    @NotNull
    public final Vector2 minus(@NotNull Vector2 vector2) {
        Intrinsics.checkParameterIsNotNull(vector2, "vector2");
        return new Vector2(this.x - vector2.x, this.y - vector2.y);
    }

    @NotNull
    public final Vector2 times(double d) {
        return new Vector2(this.x * d, this.y * d);
    }

    @NotNull
    public final Vector2 times(@NotNull Vector2 v) {
        Intrinsics.checkParameterIsNotNull(v, "v");
        return new Vector2(this.x * v.x, this.y * v.y);
    }

    @NotNull
    public final Vector2 div(double d) {
        return new Vector2(this.x / d, this.y / d);
    }

    @NotNull
    public final Vector2 div(@NotNull Vector2 d) {
        Intrinsics.checkParameterIsNotNull(d, "d");
        return new Vector2(this.x / d.x, this.y / d.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vector2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    static {
        Companion = new Companion(null);
        ZERO = new Vector2(0.0, 0.0);
        UNIT_X = new Vector2(1.0, 0.0);
        UNIT_Y = new Vector2(0.0, 1.0);
        INFINITY = new Vector2(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY(), DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vector2 copy(double x, double y) {
        return new Vector2(x, y);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Vector2 copy$default(Vector2 vector2, double d, double d2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d = vector2.x;
        }
        if ((n2 & 2) != 0) {
            d2 = vector2.y;
        }
        return vector2.copy(d, d2);
    }

    public String toString() {
        return "Vector2(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        return Double.hashCode(this.x) * 31 + Double.hashCode(this.y);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector2)) break block3;
                Vector2 vector2 = (Vector2)object;
                if (Double.compare(this.x, vector2.x) != 0 || Double.compare(this.y, vector2.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/openrndr/math/Vector2$Companion;", "", "()V", "INFINITY", "Lorg/openrndr/math/Vector2;", "getINFINITY", "()Lorg/openrndr/math/Vector2;", "UNIT_X", "getUNIT_X", "UNIT_Y", "getUNIT_Y", "ZERO", "getZERO", "openrndr-math"})
    public static final class Companion {
        @NotNull
        public final Vector2 getZERO() {
            return ZERO;
        }

        @NotNull
        public final Vector2 getUNIT_X() {
            return UNIT_X;
        }

        @NotNull
        public final Vector2 getUNIT_Y() {
            return UNIT_Y;
        }

        @NotNull
        public final Vector2 getINFINITY() {
            return INFINITY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

