/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_rect")
public class STBRPRect
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int W;
    public static final int H;
    public static final int X;
    public static final int Y;
    public static final int WAS_PACKED;

    STBRPRect(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public STBRPRect(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBRPRect.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int id() {
        return STBRPRect.nid(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short w() {
        return STBRPRect.nw(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short h() {
        return STBRPRect.nh(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short x() {
        return STBRPRect.nx(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short y() {
        return STBRPRect.ny(this.address());
    }

    @NativeType(value="int")
    public boolean was_packed() {
        return STBRPRect.nwas_packed(this.address()) != 0;
    }

    public STBRPRect id(int value) {
        STBRPRect.nid(this.address(), value);
        return this;
    }

    public STBRPRect w(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nw(this.address(), value);
        return this;
    }

    public STBRPRect h(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nh(this.address(), value);
        return this;
    }

    public STBRPRect x(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.nx(this.address(), value);
        return this;
    }

    public STBRPRect y(@NativeType(value="stbrp_coord") short value) {
        STBRPRect.ny(this.address(), value);
        return this;
    }

    public STBRPRect was_packed(@NativeType(value="int") boolean value) {
        STBRPRect.nwas_packed(this.address(), value ? 1 : 0);
        return this;
    }

    public STBRPRect set(int id, short w, short h, short x, short y, boolean was_packed) {
        this.id(id);
        this.w(w);
        this.h(h);
        this.x(x);
        this.y(y);
        this.was_packed(was_packed);
        return this;
    }

    public STBRPRect set(STBRPRect src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBRPRect malloc() {
        return STBRPRect.create(MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static STBRPRect calloc() {
        return STBRPRect.create(MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static STBRPRect create() {
        return new STBRPRect(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBRPRect create(long address) {
        return new STBRPRect(address, null);
    }

    @Nullable
    public static STBRPRect createSafe(long address) {
        return address == 0L ? null : STBRPRect.create(address);
    }

    public static Buffer malloc(int capacity) {
        return STBRPRect.create(STBRPRect.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBRPRect.create(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBRPRect.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : STBRPRect.create(address, capacity);
    }

    public static STBRPRect mallocStack() {
        return STBRPRect.mallocStack(MemoryStack.stackGet());
    }

    public static STBRPRect callocStack() {
        return STBRPRect.callocStack(MemoryStack.stackGet());
    }

    public static STBRPRect mallocStack(MemoryStack stack) {
        return STBRPRect.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBRPRect callocStack(MemoryStack stack) {
        return STBRPRect.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBRPRect.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBRPRect.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBRPRect.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBRPRect.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ID);
    }

    public static short nw(long struct) {
        return MemoryUtil.memGetShort(struct + (long)W);
    }

    public static short nh(long struct) {
        return MemoryUtil.memGetShort(struct + (long)H);
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort(struct + (long)X);
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort(struct + (long)Y);
    }

    public static int nwas_packed(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WAS_PACKED);
    }

    public static void nid(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ID, value);
    }

    public static void nw(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)W, value);
    }

    public static void nh(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)H, value);
    }

    public static void nx(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)X, value);
    }

    public static void ny(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)Y, value);
    }

    public static void nwas_packed(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)WAS_PACKED, value);
    }

    static {
        Struct.Layout layout = STBRPRect.__struct(STBRPRect.__member(4), STBRPRect.__member(2), STBRPRect.__member(2), STBRPRect.__member(2), STBRPRect.__member(2), STBRPRect.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        W = layout.offsetof(1);
        H = layout.offsetof(2);
        X = layout.offsetof(3);
        Y = layout.offsetof(4);
        WAS_PACKED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<STBRPRect, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBRPRect newInstance(long address) {
            return new STBRPRect(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public int id() {
            return STBRPRect.nid(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short w() {
            return STBRPRect.nw(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short h() {
            return STBRPRect.nh(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short x() {
            return STBRPRect.nx(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short y() {
            return STBRPRect.ny(this.address());
        }

        @NativeType(value="int")
        public boolean was_packed() {
            return STBRPRect.nwas_packed(this.address()) != 0;
        }

        public Buffer id(int value) {
            STBRPRect.nid(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nh(this.address(), value);
            return this;
        }

        public Buffer x(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="stbrp_coord") short value) {
            STBRPRect.ny(this.address(), value);
            return this;
        }

        public Buffer was_packed(@NativeType(value="int") boolean value) {
            STBRPRect.nwas_packed(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

