var prefaceTimeline, chaosTimelines = {};

function initializeWozi()  {
	var wozi = scenes.wozi, beamer = wozi.beamer, normal = wozi.normal, chaos = wozi.chaos, laser = wozi.laser, sputnik = chaos.sunspire.sputnik, sunspire = normal.sunspire;
	var auaspire = scenes.preface, auabubble = auaspire.thought_bubble, pow = wozi.pow, ending = scenes.ending;
	wozi.div.style.overflow = 'hidden';
	
	scenes.ending.white.div.childNodes[0].remove();
	scenes.ending.white.div.style.backgroundColor = "#FFFFFF";

	wozi.mask = document.getElementById('mask');
	wozi.mask.style.opacity = 0;
	wozi.div.appendChild(wozi.mask);

	wozi.sound = document.getElementById('woziSound');
	wozi.sound.pause();
	wozi.sound.loop = true;
	wozi.sound.volume = 1;
	wozi.waber = document.getElementById('waberSound');
	wozi.sfx = {
		zugUndLachen: document.getElementById('zugUndLachenSfx'),
		brause: document.getElementById('brauseSfx'),
		tuetchen1: document.getElementById('tuetchen1Sfx'),
		tuetchen2: document.getElementById('tuetchen2Sfx'),
		tuetchen3: document.getElementById('tuetchen4Sfx'),
		kopf: document.getElementById('kopfSfx'),
		scratch: document.getElementById('scratchSfx'),
		plop: document.getElementById('plopSfx'),
		juhu: document.getElementById('juhuSfx'),
		juhuarghs: document.getElementById('juhuarghsSfx'),
		splash: document.getElementById("splashSfx"),
	};
	wozi.sfx.zugUndLachen.pause();
	wozi.sfx.zugUndLachen.volume = 0.7;
	
	addTextElement(wozi.end_bubble, "spire-bubble-text arv-end");
	setBubbleText(wozi.end_bubble, "Say, did anyone see SunSpirou?");
	wozi.end_bubble.div.style.opacity = 0;
	
	wozi.pow.div.style.opacity = 0;
	auaspire.div.style.opacity = 0;
	auabubble.div.style.opacity = 0;
	addTextElement(auabubble, "spire-bubble-text spire-preface");
	
	var lampCable = chaos.rbr.body.back.div.appendChild(document.createElementNS('http://www.w3.org/2000/svg', 'svg')).appendChild(document.createElementNS('http://www.w3.org/2000/svg', 'path'));
	lampCable.parentNode.style='position:absolute;top:-50px;width:300px;height:300px;';
	lampCable.style="stroke:#282828;stroke-width:8px;stroke-opacity:1;fill:none;";
	
	var focusMask = function(x, y) {
		var tweens = [];
		//tweens.push(TweenMax.to(wozi.mask, 0.1, {opacity:0, immediateRender:false }));
		tweens.push(TweenMax.to(wozi.mask, 0.2, {opacity:1, immediateRender:false, delay:0.5 }));
		tweens.push(TweenMax.to(wozi.mask, 0.25, {x:x-1000, y:y-1000, immediateRender:false, ease:Power1.easeInOut }));
		return tweens;
	}
	
	var noFocusMask = function() { return TweenMax.to(wozi.mask, 0.2, {opacity: 0}); };

	var chaosToggle = function(item, delay, transition) {
		var tweens = [],
			normal = wozi.normal[item] || item.normal,
			chaos = wozi.chaos[item] || item.chaos || item;
		if(normal && normal.div)
		{
			tweens.push(normal.to(transition, {opacity:0, immediateRender:false, delay:delay||0, ease:Power1.easeOut}));
		}
		if(chaos && chaos.div)
		{
			tweens.push(chaos.fromTo(transition, {opacity:0}, {opacity:1, immediateRender:false, delay:delay||0, ease:Power1.easeIn}));
		}
		return tweens;
	}

	var boingball = wozi.boing_ball.fromTo(beatLen/2, { y: "-=0", scaleY:0.98, scaleX:1.02 }, { y: "-=30", scaleY:1.02, scaleX:0.98, repeat:-1, yoyo:true, ease:Power1.easeOut });

	spireTimeline = (new TimelineMax({paused: true})).add([
		sunspire.fromTo(4.3, { x: "-=70", rotation:-2 }, { x: "+=130", rotation:3, repeat:-1, yoyo:true, ease:Sine }),
		sunspire.fromTo(6, { y: "-=30" }, { y: "+=70", repeat:-1, yoyo:true, ease:function(p) { return Math.sin(2*Math.PI*p)-0.5*Math.abs(Math.sin(16*Math.PI*p)); } })
	]);

	var blabla = function(offset, speed, e, t, p) { 
		return Math.pow(0.5*(1-Math.cos(2*Math.PI*(p+offset)*speed)), e)*(!(t&((p*speed)+offset)));
	};
	var sceners = [normal.neoman, normal.fizzer, normal.arvenius, normal.rbr, normal.kaomau, normal.dojoe, normal.sentcool];
	normal.arvenius.head.fromTo(32, { rotation: 0 }, { rotation:-10, repeat:-1, ease:blabla.bind(0, 0,   32, 1  , 4) });
	normal.neoman  .head.fromTo(32, { rotation:-5 }, { rotation:  5, repeat:-1, ease:blabla.bind(0, 1.2, 32, 0.5, 3) });
	normal.fizzer  .head.fromTo(32, { rotation: 0 }, { rotation:-10, repeat:-1, ease:blabla.bind(0, 2.1, 32, 0.9, 9) });
	normal.kaomau  .head.fromTo(32, { rotation: 0 }, { rotation:-15, repeat:-1, ease:blabla.bind(0, 3.6, 16, 8  , 0) });
	normal.sentcool.head.fromTo(32, { rotation: 0 }, { rotation: 10, repeat:-1, ease:blabla.bind(0, 4.3, 32, 1.5, 11) });
	normal.dojoe   .head.fromTo(32, { rotation: 0 }, { rotation:-15, repeat:-1, ease:blabla.bind(0, 5.1, 32, 1.2, 5) });
	normal.rbr     .head.fromTo(32, { rotation: 2 }, { rotation:- 2, repeat:-1, ease:blabla.bind(0, 6.9, 32, 0.8, 5) });

	var sputniks = [sputnik.div];
	for(var i = 0; i < 4; i++) {
		sputniks.push(sputnik.div.parentNode.appendChild(sputnik.div.cloneNode(true)));
	}
	for(var i = 0; i < sputniks.length; i++) {
		var s = sputniks[i], p = 0.37*i;
		TweenMax.fromTo(s.firstChild.nextSibling, 2, { rotationY: -360*p }, { rotationY: -360*(1+p), repeat: -1, ease: Power0.easeIn, transformOrigin: '105% 50%' } );
		TweenMax.fromTo(s, 2, { x: "-=70" }, { x: "+=145", repeat: -1, ease: (function(p, s) { return 0.5+0.5*Math.sin((p+s)*2*Math.PI); }).bind(p, p) } );
		TweenMax.fromTo(s, 200, { y: "-=80" }, { y: "+=60", repeat: -1, ease: (function(p, s) { return 0.5+0.5*Math.cos(((100+p)*s+p)*2*Math.PI); }).bind(p, 67*p) } );
		TweenMax.fromTo(s, 2, { scale: 0.4 }, { scale: 0.6, repeat: -1, ease: (function(p, s) { return 0.5+0.5*Math.cos((p+s)*2*Math.PI); }).bind(p, p) } );
		TweenMax.fromTo(s, 20, { opacity: 0 }, { opacity: 1, repeat: -1, ease: (function(p, s) { return 0.5+0.5*Math.sin(10*(7*s+p)); }).bind(p, p) } );
	}

	var krawallIntervall = 2;
	var foams = [chaos.sentcool.foam1, chaos.dojoe.foam1, chaos.sentcool.foam2, chaos.dojoe.foam2, chaos.sentcool.foam3, chaos.dojoe.foam3];
/*	var foamDivs = [];
	for(var i = 0; i < foams.length; i++) {
		var foam = foams[i];
		foamDivs.push(foam.div.parentNode.appendChild(foam.div.cloneNode(true)));
		foamDivs.push(foam.div);
		foam.div.style.left = (parseInt(foam.div.style.left) + 20-10*i) + 'px';
	}*/
	var krawallFoamTimeline = new TimelineMax({paused: true});
	var krawallFoams = [];
	for(var i = 0; i < foams.length; i++) {
		var foam = foams[i];
		var krawallI = (i & 2);
		var delay = ((krawallIntervall*krawallI)+1.7) + ((beatLen/4)*i*1);
		krawallFoams.push(foam.fromTo(beatLen, { opacity: 0, scale: 0.7 }, { opacity: 1, scale: 1, repeat: -1, delay:delay, yoyo: true, ease: Power2.easeInOut }));
		//krawallFoamTimeline.fromTo(foam, 10, { rotation:i*70 }, { rotation:i*70+20, repeat: -1 });
	}
	krawallFoamTimeline.add(krawallFoams);

	var krawallTweens = [];
	var krawallBags = [];
	var krawallBagEndYpos = [490,480,530];
	for(var i = 0; i<3; i++)
	{
		var krawallA = chaos['krawall'+(i+1)+'a'];
		var krawallB = chaos['krawall'+(i+1)+'b'];
		krawallBags.push(krawallA, krawallB);
		var delay = krawallIntervall*i;
		krawallTweens.push(krawallA.from(0.5, { x:((i&1)*2000-1000), delay:delay-beatLen, ease:Power2.easeOut}));
		krawallTweens.push(krawallB.from(0.5, { x:((i&1)*2000-1000), delay:delay-beatLen, ease:Power2.easeOut}));
		krawallTweens.push(chaosToggle(krawallA, delay));
		krawallTweens.push(chaosToggle(krawallB, delay));
		krawallTweens.push(krawallB.fromTo(2, { y:'+0' }, { y:'+'+krawallBagEndYpos[i], delay:delay+0.5, ease:Power0.easeOut, onStart:function() { this.play(); }, onStartScope:wozi.sfx['tuetchen'+(1+i)] }));
		krawallTweens.push(krawallA.fromTo(2, { y:'+0' }, { y:'+'+krawallBagEndYpos[i], delay:delay+1.5, ease:Power0.easeOut, onStart:function() { wozi.sfx.brause.currentTime = 0; wozi.sfx.brause.play(); } }));
		krawallTweens.push(krawallB.fromTo(0.4, { rotation:-20 }, { rotation: 20, delay:delay+0.5, yoyo:true, repeat:Math.round(2/0.4)-1, ease:Sine.easeInOut }));
		krawallTweens.push(krawallA.fromTo(0.6, { rotation: 20 }, { rotation:-20, delay:delay+1.5, yoyo:true, repeat:Math.round(2/0.6)-1, ease:Sine.easeInOut }));
		krawallTweens.push(krawallB.fromTo(2, { x:'+0' }, { x:'+'+(20+10*i), delay:delay+0.5, ease:function(p){ return p*-Math.cos(Math.PI*p*3); } } ));
		krawallTweens.push(krawallA.fromTo(2, { x:'+0' }, { x:'+'+(20+6*i),  delay:delay+1.5, ease:function(p){ return p*-Math.cos(Math.PI*p*1); } } ));
	}

	var lasers = [laser.right.top, laser.right.bot, laser.left.top, laser.left.bot];
	var lasersTimeline = new TimelineMax({paused: true});
	for(var i = 0; i < lasers.length; i++) {
		var l = lasers[i], p = 0.67*i;
		lasersTimeline.add(l.fromTo(2, { opacity: 0 }, { opacity: 1.2, repeat: -1, yoyo:true, ease:RoughEase.ease.config({ strength:3, points:20+i, clamp:true}) } ), 0);
	}

	var smokers = [chaos.arvenius, chaos.neoman];
	for(var i = 0; i < smokers.length; i++) {
		var smoker = smokers[i],
			smoke = smoker.smoke,
			glow = smoker.glow;
		smoke.div.style.overflow = 'hidden';
		smoke.div.style.bottom = (smoker.size.y-smoke.botRight.y) +'px';
		smoke.div.style.top = '';
		smoke.image.style.top = '';
		smoke.image.style.bottom = 0;
		smoke.image.style.position = 'absolute';
		smoke.fromTo( 2+0.1*i, {height:0, rotationY:-50}, {height:smoke.size.y, rotationY:50, repeat:-1, ease:Power1.easeInOut} );
		smoke.fromTo((2+0.1*i)*.5, {opacity:0.25}, {opacity:1, repeat:-1, ease:Power1.easeOut, yoyo:true} );
		glow.fromTo((2+0.1*i)*.5, {scale:0.25}, {scale:1.2, repeat:-1, ease:Power1.easeOut, yoyo:true} );
		smoker.fromTo(2.9+0.17*i, { x: "-=10", rotation:-1 }, { x: "+=10", rotation:1, repeat:-1, yoyo:true, ease:Sine });
		smoker.fromTo(3+0.09*i, { y: "-=5" }, { y: "+=5", repeat:-1, yoyo:true, ease:Sine });
	}
	
	var fizzerArmPre = chaos.fizzer.arm.fromTo(2, { rotation:0 }, { rotation:30, ease:Power1.easeOut });
	var fizzerArm = chaos.fizzer.arm.fromTo(beatLen/2, { rotation:-5 }, { rotation:30, repeat:-1, yoyo:true, ease:Power1.easeOut });
	var fizzerButton = chaos.fizzer.button.fromTo(beatLen, { opacity:0 }, { opacity:1, repeat:-1, ease:Power1.easeIn });
	var umptchi = chaos.fizzer.umptchi;
	var umptchis = [umptchi.div];
	var umptchiTweens = [];
	for(var i = 0; i < 4; i++) {
		umptchis.push(umptchi.div.parentNode.appendChild(umptchi.div.cloneNode(true)));
	}
	for(var i = 0; i < umptchis.length; i++) {
		var u = umptchis[i];
		umptchiTweens.push(TweenMax.fromTo(u, beatLen*4, { y: "+=30", opacity:1, scale:0.1 }, { y: "-=230", opacity:0.5, scale:1, repeat: -1, delay:(i+.1)*beatLen } ));
		umptchiTweens.push(TweenMax.fromTo(u, 0.1, { opacity:0 }, { opacity:0.5 } ));
	}

	beamer.main.fromTo(2, { rotation:3 }, { rotation:-1.5, repeat:-1, yoyo:true, ease:Sine.easeInOut } );
	beamer.flare.fromTo(4.3, { scale: 0.95 }, { scale: 1.0, repeat:-1, ease:RoughEase.ease.config({ strength:5,points:100,clamp:true}) } );
	beamer.flare.fromTo(6.7, { opacity: 0.7 }, { opacity: 1, repeat:-1, yoyo:true, ease:RoughEase.ease.config({ strength:3,points:10,clamp:true}) } );
	
	chaos.kaomau.fromTo(beatLen*4, { rotation:-10, x:"-=60" }, { rotation:30, x:"+=100", repeat:-1, yoyo:true, ease:Sine.easeInOut } );
	
	chaos.rbr.fromTo(beatLen*4, { rotation:-30 }, { rotation:30, repeat:-1, yoyo:true, ease:Sine.easeInOut } );
	TweenMax.fromTo(lampCable, beatLen*4, { attr:{d:'M 195,0 C 150,80 170,180 170,192'} }, { attr:{d:'M 145,0 C 185,80 170,170 170,192'}, repeat:-1, yoyo:true, ease:Sine.easeInOut } );

	wozi.sofa.hole2.spring.fromTo(0.5, { scaleX: 0.9, rotation:-0.01 }, { scaleX: 1.1, rotation:0.01, repeat:-1, yoyo:true, ease:Power1.easeOut } );
	wozi.sofa.hole1.spring1.fromTo(0.5, { scaleY: 0.85, rotation:-0.01 }, { scaleY: 1.0, rotation:0.01, repeat:-1, yoyo:true, ease:Power1.easeOut } );
	wozi.sofa.hole1.spring2.fromTo(0.617, { scaleY: 0.85, rotation:-0.01 }, { scaleY: 1.0, rotation:0.01, repeat:-1, yoyo:true, ease:Power1.easeOut } );
	
	var wakkawakka = wozi.pacman.fromTo(beatLen/2, { rotation:0 }, { rotation:-65, repeat:-1, yoyo:true, ease:Power0.easeIn } );
	
	var salmiakkiStain = chaos.salmiakki.stain.to(5, { scale:1, ease:Power1.easeOut });

	var chaosObjects = [];
	for (var chaosObjId in wozi.chaos) {
		var child = wozi.chaos[chaosObjId];
		if (child.div) {
			chaosObjects.push(child);
		}
	}
	var chaosSceners = [chaos.arvenius, chaos.neoman, chaos.fizzer, chaos.kaomau, chaos.sentcool, chaos.dojoe, chaos.rbr, chaos.sunspire];
	var chaosSofaObjects = [wozi.sofa.hole3, wozi.sofa.hole1, wozi.sofa.hole2, wozi.sofa.plaster, wozi.boing_ball.atari];

	auaspire.body.fromTo(3, { rotation: 0.5, x: "-=4" }, { rotation: -0.5, x: "+=4", repeat: -1, yoyo: true, ease: Power1.easeInOut });
	auaspire.body.head.to(2, { scale: 1.02, repeat: -1, ease: function(x) { return 7*x > 2 ? 0 : 1-(Math.cos(x*3.141*14)+1)/2; } });
	
	function addPrefaceBubble(offset, enter, stay, out, text) {
		prefaceTimeline
			.call(setBubbleText, [ auabubble, text ], null, "+=" + offset)
			.add(auabubble.to(enter, { opacity: 1 }), "+=" + offset)
			.add(auabubble.to(out, { opacity: 0 }), "+=" + stay);		
	}
	
	/* -------------------------------------------------------------------------
	 * PREFACE
	 * ------------------------------------------------------------------------- */
	prefaceTimeline = (new TimelineMax({paused: true}))
		.set([].concat(chaosObjects, chaosSofaObjects, wozi.curtain.chaos, wozi.marker.chaos).map(_ => _.div), {opacity: 1})
		.set([].concat(sunspire, sceners, chaosSceners, wozi.curtain.normal, wozi.marker.normal, krawallBags).map(_ => _.div), {opacity: 0})
		.add(scenes.wozi.set({ transform: "scale(1.7) translate(5%, -15%)", opacity: 0 }))
		.add(auaspire.set({ transform: "scale(1.7) translate(5%, -15%)", opacity: 0 }))
		.call(function(){ wozi.waber.play(); })
		.add(auaspire.to(7, { opacity: 1, ease: Power0.easeIn }), "+=2")
	;
	addPrefaceBubble(-3, 3.5, 2.0, 0.5, "Ow, my head.");
	addPrefaceBubble( 0, 1.5, 2.0, 0.5, "What the hell happened last night?");
	addPrefaceBubble( 0, 1.5, 2.0, 0.5, "Why do I have a splitting headache, and why does my place look like this?");
	prefaceTimeline
		.add(scenes.wozi.to(4, {opacity: 1, ease: Power0.easeIn}), "-=2.5")
		.to([scenes.wozi.div, auaspire.div], 5, {transform: "scale(1) translate(0, 0)", ease: Power1.easeInOut}, "-=2.5")
	;
	addPrefaceBubble( 0, 1.5, 2.0, 0.5, "The party started fine, I remember by nine everyone was around.");
	var t = prefaceTimeline.duration() - 2;
	prefaceTimeline
		.call(function(){ scenes.kitchen.sound.play(); }, null, null, t - 1)
		.to(wozi.waber, 1, { volume: 0 }, t - 1)
		.to(scenes.kitchen.sound, 1, { volume: 1 }, t - 1)
		.add(auaspire.body.to(1.0, {opacity: 0}), t - 0.2)
		.add(sunspire.to(0.5, {opacity: 1}), t)
		.to([].concat(chaosObjects, chaosSofaObjects, wozi.curtain.chaos, wozi.marker.chaos).map(_ => _.div), 1.5, {opacity: 0}, t)
		.to([].concat(wozi.curtain.normal, wozi.marker.normal).map(_ => _.div), 1.5, {opacity: 1}, t)
		.call(function(){ wozi.waber.pause(); })
		.call(function() { lasersTimeline.play(); }, null, null, t+0.5)
		.call(function(){ scenes.kitchen.sound.play(); }, null, null, t+0.5)
	;
	t += 2;
	prefaceTimeline.call( function() { wozi.sfx.plop.play(); }, null, null, t)
	for (var i = 0; i < sceners.length; i++) {
		prefaceTimeline.add(sceners[i].to(0.5, {opacity: 1}), t);
		t += 0.1 + Math.random()*0.2;
	}
	prefaceTimeline
		.call( function() { spireTimeline.play(); wozi.sfx.juhu.play(); } )
		.add( wozi.fromTo(3, { filter: "grayscale(0) blur(0px)" }, { filter: "grayscale(1) blur(50px)", opacity: 0, ease: Power0.easeOut }), "+=2" )
		.add( wozi.set({ filter: "" }) )
	;
	addPrefaceBubble( -1, 1.5, 2.0, 0.5, "But I don't remember anything after that...");
	
	/* -------------------------------------------------------------------------
	 * CHAOS TIMELINES
	 * ------------------------------------------------------------------------- */
	chaosTimelines.neoarv = (new TimelineMax({paused: true}))
		.add(TweenMax.set([].concat(chaosObjects, chaosSofaObjects, chaosSceners, wozi.marker.chaos, wozi.curtain.chaos).map(_ => _.div), {opacity: 0}), 0)
		.add(focusMask(-100,-100))
		.addLabel('floArveNeoman')
		.call(function() { wozi.sfx.zugUndLachen.play(); })
		.add(chaosToggle('arvenius', null, 0.5).concat(chaosToggle('neoman', null, 0.5)))
		.add(chaosToggle(chaos.penis, null, 0.3), "+=2")
		.add(chaos.arvenius.fromTo(0.1, { y:"+=0" }, { y:"-=10", repeat:9, yoyo:true, ease:Power0.easeInOut }), "floArveNeoman+=1.75")
		.add(chaos.neoman  .fromTo(0.1, { y:"+=0" }, { y:"-=8", repeat:11, yoyo:true, ease:Power0.easeInOut }), "floArveNeoman+=3")
		.add(noFocusMask())
	;
	var fizzerBackgroundTimeline = (new TimelineMax({paused: true})).add([fizzerArm, fizzerButton, boingball, wakkawakka].concat(umptchiTweens));
	chaosTimelines.fizzer = (new TimelineMax({paused: true}))
		.add(focusMask(-50,-400))
		.add(chaosToggle('fizzer', null, 0.5))
		.add(fizzerArmPre, "+=1")
		.call(function(){ scenes.kitchen.sound.pause(); wozi.sfx.scratch.play(); }, null, null, "-=0.5")
		.call(function(){ wozi.sound.play(); fizzerBackgroundTimeline.play() })
		.add(chaosToggle(wozi.curtain), "+="+(beatLen*4))
		.add(noFocusMask())
	;
	chaosTimelines.kaomau = (new TimelineMax({paused: true}))
		.add(chaos.salmiakki.stain.set({ scale: 0.2 }))
		.add(focusMask(250,-250))
		.add(chaosToggle('kaomau', null, 0.5).concat(chaosToggle(wozi.sofa.hole2, null, 0.1)).concat(chaosToggle(wozi.sofa.hole3, 0.5, 0.2)))
		.add(chaosToggle(chaos.pepper, null, 0.5), "+=2")
		.add(chaosToggle(chaos.salmiakki, null, 0.5), "+=1")
		.add(noFocusMask())
		.add(salmiakkiStain)
		.add(chaosToggle(chaos.walldirt, null, 1), "-=1")
	;
	chaosTimelines.sentjoe = (new TimelineMax({paused: true}))
		.add(focusMask(600,-350))
		.add(chaosToggle('sentcool', null, 0.5).concat(chaosToggle('dojoe', null, 0.5)))
		.call(function(){ krawallFoamTimeline.play(); })
		.add(krawallTweens, "+=1")
		.add(noFocusMask())
		.add(chaosToggle(chaos.footprint1), "+=2")
		.add(chaosToggle(chaos.footprint2), "+="+beatLen)
		.add(chaosToggle(chaos.footprint3), "+="+beatLen)
		.add(chaosToggle(chaos.wall_hole),  "+="+beatLen)
	;
	chaosTimelines.rbr = (new TimelineMax({paused: true}))
		.add(focusMask(-550,-650))
		.add(chaosToggle('rbr', null, 0.5).concat(chaosToggle('lamp', null, 0.5)).concat(
			 chaosToggle(wozi.sofa.plaster, null, 0.3)).concat(chaosToggle(wozi.sofa.hole1, null, 0.2)))
		.add(chaosToggle(wozi.boing_ball.atari, null, 0.5).concat(chaosToggle(wozi.marker, null, 0.5)), "+=2")
		.add(noFocusMask())
		.add(chaosToggle(chaos.handprints, null, 0.2), "+=2")
	;
	spireclones = [ sunspire.div ]
	for (var i = 0; i < 4; i++) {
		var clone = sunspire.div.parentNode.appendChild(sunspire.div.cloneNode(true));
		clone.style.opacity = 0;
		spireclones.push(clone);
	}
	chaosTimelines.flashback = (new TimelineMax({paused: true}))
		.set([].concat(sceners, chaosObjects, chaosSofaObjects, chaosSceners, wozi.marker.chaos, wozi.curtain.chaos, krawallBags).map(_ => _.div), {opacity: 0})
		.set([].concat(wozi.curtain.normal, wozi.marker.normal).map(_ => _.div), {opacity: 1})
		.call(function(){
			scenes.kitchen.sound.volume = 0;
			scenes.kitchen.sound.play();
			for (var tl of [ spireTimeline, fizzerBackgroundTimeline, krawallFoamTimeline ]) {
				tl.pause();
				tl.time(0);
			}
		})
		.set(spireclones[0], { x: -85, y: 30 })
		.set(spireclones[1], { x: -91, y: 0 })
		.set(spireclones[2], { x: -97, y: -30 })
		.set(spireclones[3], { x: -103, y: -60 })
		.set(spireclones[4], { x: -109, y: -90 })
		.add([ TweenMax.to(scenes.kitchen.sound, 0.5, { volume: 1 }), TweenMax.to(scenes.wozi.sound, 0.5, {volume: 0}) ])
	;
	chaosTimelines.spireouch = new TimelineMax({paused: true})
	chaosTimelines.spireouch.call( function() { wozi.sfx.plop.play(); } );
	for (var i = 0; i < sceners.length; i++)
		chaosTimelines.spireouch.add(sceners[i].to(0.5, {opacity: 1}), "+=" + (0.1 - 0.5 + Math.random() * 0.2));
	chaosTimelines.spireouch
		.add(focusMask(-750,-250))
		.set({}, {}, "+=0.7")
		.call(function(){ wozi.sfx.juhuarghs.play(); }, null, null, "-=0.5");
	for (var i = 0; i < 5; i++)
		chaosTimelines.spireouch.fromTo(spireclones[i], 1.5, { opacity: 1 }, { x: "-=2", y: "-=10", opacity: i == 4 ? 1 : 0, immediateRender: false, ease: Power1.easeIn }, "-=1");
	chaosTimelines.spireouch
		.call(function(){ wozi.sfx.kopf.play(); })
		.add(pow.set({x: "-=390" }))
		.add([ pow.fromTo(1.5, { scale: 0.7, rotation: -90 }, { x: "+=100", y: "+=300", rotation: 50, scale: 1.5 }),
		       pow.to(0.3, { opacity: 1 }), pow.to(0.5, { opacity: 0, delay: 1.2 }) ])
		.set(spireclones[spireclones.length - 1], { opacity: 0 }, "-=0.5")
		.set(chaos.sunspire.div, { opacity: 1 }, "-=0.5")
		.add(noFocusMask(), "+=1")
	;
	
	chaosTimelines.end = (new TimelineMax({ paused: true }))
		.add( wozi.end_bubble.to(0.5, { opacity: 1 }))
		.add( wozi.end_bubble.to(0.5, { opacity: 0 }), "+=2")
		.call(function(){ scenes.kitchen.sound.pause(); wozi.sfx.splash.play(); }, null, null, "+=1")
		.add( ending.set({ opacity: 1, immediateRender: false }))
		.add( ending.fin.from(0.2, { opacity: 0, scale: 1.2 }))
		.add([ wozi.fromTo(4, { filter: "blur(0px)" }, { filter: "blur(15px)", ease: Power0.easeIn }), ending.white.fromTo(5, { opacity: 0 }, { opacity: 0.5 }) ])
		.call(function(){ scenes.kitchen.sound.currentTime = 0; scenes.kitchen.sound.play(); })
		.add([ ending.fin.to(0.8, { y: "+=1000" }), ending.text.from(1, { opacity: 0 }) ])
		.add( ending.signatures.from(1, { opacity: 0 }))
	;
};