var Rb = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setBloom(3.0);

    var ambientLight = new THREE.AmbientLight(0xffffff);
    this.scene.add(ambientLight);

    this.scene.fog = new THREE.Fog(0x000080, this.near, this.far*0.75);

    //this.texture = TDEMO.TEXTURES.getTextures().kootti2;

    this.rainbow = new Rainbow(4, TDEMO.TEXTURES.getTextures().sydan);
    this.rainbow.rainbowObj.position.set(-50, 0, -300);
    this.rainbow.rainbowObj.rotation.y = Math.PI / 4;
    //this.rainbow.rainbowObj.rotation.x = -Math.PI/4;
    this.scene.add(this.rainbow.rainbowObj);
    console.log(this.rainbow);
    //this.sky = this.createBackground(800, 0x200810, THREE.BackSide);
    this.sky = this.createBackground(800, 0x7090d0, THREE.BackSide);
    this.scene.add(this.sky);
};

Rb.prototype = PartBase.prototype.inheritance();

Rb.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var msin = Math.sin(elapsedTime);
    var mcos = Math.cos(elapsedTime);
    for(var i=0; i<this.rainbow.rings.length; i++) {
        if(i%2 === 0) 
            this.rainbow.rings[i].position.set(12*msin, 10*msin, 12*msin);
        else 
            this.rainbow.rings[i].position.set(12*mcos, 10*msin, 12*mcos);
    }

};

Rb.prototype.createBackground = function(r, color, side){
    var geometry = new THREE.SphereGeometry(r, 30, 30);
    var material = new THREE.MeshBasicMaterial({
        color : color,
        map : TDEMO.TEXTURES.getTextures().valot,
        side : side,
        color: 0xFF0000
    });

    var bg = new THREE.Mesh(geometry, material);

    return bg;
}
