var Logo = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.textures = TDEMO.TEXTURES.getTextures();

    var bg = this.createBackground();
    this.scene.add(bg);

    var material = new THREE.SpriteMaterial({map : this.textures.jumalauta});
    this.jumalauta = new THREE.Sprite(material);
    this.jumalauta.scale.x = 10;
    this.jumalauta.scale.y = 10;
    this.scene.add(this.jumalauta);

};

Logo.prototype = PartBase.prototype.inheritance();

Logo.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    this.textures.valot.offset.x += delta*0.01;
    this.textures.valot.offset.x %= 4;

    this.textures.valot.offset.y = 10*Math.sin(delta*0.01);
    this.textures.valot.offset.y %= 4;

    this.textures.valot.needsUpdate = true;

    var hb = TDEMO.SYNC.getHeartBeat();

};

Logo.prototype.createBackground = function(){
    var material = new THREE.MeshBasicMaterial({
        map : this.textures.valot,
        side : THREE.DoubleSide
    });
    var geometry = new THREE.PlaneBufferGeometry(400, 200);
    var plane = new THREE.Mesh(geometry, material);
    plane.position.z = -10;
    return plane;
};
