var Farjan = function(){
    PartBase.call(this);

    //POSTPROCESSING

    this.textures = TDEMO.TEXTURES.getTextures();

    var bg = this.createBackground();
    this.scene.add(bg);

    var material = new THREE.SpriteMaterial({map : this.textures.farjan});
    this.farjan = new THREE.Sprite(material);
    this.farjan.scale.x = 20;
    this.farjan.scale.y = 10;
    this.scene.add(this.farjan);

};

Farjan.prototype = PartBase.prototype.inheritance();

Farjan.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
    this.textures.valot.offset.x += delta*0.01;
    this.textures.valot.offset.x %= 4;

    this.textures.valot.offset.y = 10*Math.sin(delta*0.01);
    this.textures.valot.offset.y %= 4;

    this.textures.valot.needsUpdate = true;

    var pos = TDEMO.SYNC.getObjPosition();
    this.farjan.position.x = pos.x;

};

Farjan.prototype.createBackground = function(){
    var material = new THREE.MeshBasicMaterial({
        map : this.textures.valot,
        side : THREE.DoubleSide,
        color: 0x00A0FF
    });
    var geometry = new THREE.PlaneBufferGeometry(400, 200);
    var plane = new THREE.Mesh(geometry, material);
    plane.position.z = -10;
    return plane;
};