// simple lens that magnifies a rectangular portion of the screen
#ifdef GL_ES
precision mediump float;
precisioun mediump int;
#endif

//#define PROCESSING_TEXTURE_SHADER
//#define PROCESSING_COLOR_SHADER


uniform sampler2D texture;

uniform float lensCenterX;
uniform float lensCenterY;
uniform float lensW;
uniform float lensH;
uniform float zoomFactor;

uniform int texwidth;
uniform int texheight;

uniform vec2 texOffset;

varying vec4 vertColor;
varying vec4 vertTexCoord;

void main() {

	vec2 center = vec2(lensCenterX, lensCenterY);
	vec2 xy = vertTexCoord.xy - center; // distance from center of the rectangle in s-t units.
	float x = vertTexCoord.x;
	float y = vertTexCoord.y;

	if(center.x - lensW * 0.5 < x && x < center.x + lensW * 0.5 &&
	   center.y - lensH * 0.5 < y && y < center.y + lensH * 0.5) {

		vec2 xy_zoom = center + xy / zoomFactor;

		gl_FragColor = texture2D(texture, xy_zoom);
		//gl_FragColor = vec4(lensCenterX, lensCenterY, 0, 1.0); // debug

	} else {

		gl_FragColor = texture2D(texture, vertTexCoord.xy);

	}

}
