class Scene3 extends Scene {
  float fade;
  color bgColor = color(255, 255, 255);
  //color pink = color(255, 130, 169);
  color pink = color(255, 30, 127);

  void render() {
    fade = (float) moonlander.getValue("fade");

    PGraphics fb = frameBuffer1;
    fb.beginDraw();

    fb.noStroke();
    fb.noFill();

    translate(-width / 2, -height / 2);

    fb.fill(bgColor, 255-fade);
    fb.rectMode(CORNER);
    fb.rect(-100, -100, width + 200, height + 200);

    fb.translate(width / 2, height / 2);
    
    //fb.translate(0, 0, -150);
    fb.translate(0,0,200);
    fb.scale(0.5);

    float bs = height * 0.2;
    float spacing = 0.2 * bs;

    fb.pushMatrix();
    fb.rotateY((float) (moonlander.getValue("s3rotate") * 2 * Math.PI));

    for(int i = -1; i <= 1; i++) {
      for(int j = -1; j <= 1; j++) {
        for(int k = -1; k <= 1; k++) {
          fb.pushMatrix();
          float bss = bs + spacing;
          fb.translate(i * bss, j * bss, k * bss);
          //fb.fill(255, 255, 255, 255 - fade);
          fb.noFill();
          fb.stroke(0, 0, 0);
          fb.strokeWeight(4);
          fb.box(bs);
          fb.popMatrix();
        }
      }
    }

    fb.popMatrix();

    int nCircles = 30;
    for(int i = 1; i <= nCircles; i++) {
      fb.fill(pink, 60);
      fb.noStroke();
      float r = 2 * (bs + spacing) * (1 - 0.05 * i);
      //fb.sphere(0., 0., r, r);
      //fb.sphere(r);
      fb.ellipse(0, 0, r, r);
    }


    fb.endDraw();

    float p = (float) moonlander.getValue("lens parameter");
    int s = (int) moonlander.getValue("lens seed");
    int lensCount = max((int) moonlander.getValue("lens count"), 0);

    randomSeed(s);

    // bounce lens rendering between two framebuffers (might be very bad idea (inefficient))
    PGraphics fba = fb;
    PGraphics fbb = frameBuffer2;

    int i;
    for (i = 0; i < lensCount; i++) {
      float la = random(0, 1) + random(-1, 1) * p;
      float lb = random(0, 1);
      float lc = random(lensMinW, lensMaxW);
      float ld = random(lensMinH, lensMaxH);

      if (random(0, 1) < 0.5) {
        rectLens.set("lensCenterX", la);
        rectLens.set("lensCenterY", lb);
        rectLens.set("lensW", lc);
        rectLens.set("lensH", ld);
      } else {
        rectLens.set("lensCenterX", lb);
        rectLens.set("lensCenterY", la);
        rectLens.set("lensW", ld);
        rectLens.set("lensH", lc);
      }
      rectLens.set("zoomFactor", random(lensMinZoom, lensMaxZoom));

      fbb.beginDraw();
      fbb.shader(rectLens);
      fbb.image(fba, 0, 0);
      fbb.endDraw();


      if (i % 2 == 0) {
        fba = frameBuffer2;
        fbb = fb;
      } else {
        fba = fb;
        fbb = frameBuffer2;
      }
    }

    if (i % 2 == 1 || lensCount == 0) {
      fbb = fb;
    }

    image(fbb, 0, 0);

  }
}
