import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.effects.*; 
import ddf.minim.signals.*; 
import ddf.minim.spi.*; 
import ddf.minim.ugens.*; 
import moonlander.library.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class graffathon2018 extends PApplet {










AudioPlayer player;
Minim minim;
Moonlander moonlander;
//Blurred moon image
PImage moon;

public void settings() {
  fullScreen(P3D);
  //size(1280,720);
}

public void setup() {
  frameRate(60);
  moonlander = Moonlander.initWithSoundtrack(this, "data/Night_Prowler.mp3", 110, 1);
  moonlander.start("localhost", 1338, "syncdata.rocket");
  //moonlander.start();
  background(0);
  noStroke();
  moon = loadImage("data/moon.png");
  generateRoadMarks();
  initTrees();
  setupNoiseWave();
  setupStars();
  colorMode(RGB);
  noCursor();
}

public void draw() {
  moonlander.update();
  int currentScene = moonlander.getIntValue("scene");
  if(currentScene == 0) {
    drawNoiseWave();
  } else if (currentScene == 1) {
    drawHightway();
  } else if (currentScene == 2) {
    colorMode(HSB);
    noStroke();
    drawPlasma();
  } else if (currentScene == 3) {
    colorMode(RGB);
    strokeWeight(3);
    drawStars();
  } else if  (currentScene == 4) {
    strokeWeight(2);
    drawStars();
    moveText(2);
    showGreets();
  } else if (currentScene == 5) {
    exit(); 
  }
}
float plasmaColor = 0;
float i = 0;
float plasma;

public void drawPlasma() {
  background(0);
  float tiem = (float) moonlander.getValue("tiem");
  for(int x = 0; x < 100; x++) {
   for(int y = 0; y < 100; y++) {
     //plasma = sin(i+sin(x/10.5+i*3.5) + sin(y/11.5+i*3) - cos((y-x)/8.5+i*2.5) - sin(x/10.5+i*3));
     plasma = sin(i+sin(x/10.5f+i) - sin(x/11.5f+i) + cos((x-y)/8.5f+i) - sin(y/11.5f+i*2));
     plasmaColor = map(sin(plasma-tiem/TWO_PI),-1,1,0,255);
     fill(plasmaColor,255,255);
     rect(x*19.2f,y*10.8f,20,20);
   }
   i = i + 0.00015f;
  } 
}
float MARKINGS_DISTANCE = 600;
float TREES_DISTANCE = 800;
float TREE_SIZE = 35;
float NOISEBARS_DISTANCE = -7000;

float VERT_VANISHING_POINT = height/2 - 10;

float roadMarkX = 0;
float roadMarkY = (height/2 + 30);
float roadMarkZ1 = 100;
float roadMarkZ2 = roadMarkZ1 + 30;

ArrayList<Roadmark> marks = new ArrayList();
ArrayList<Puu> treesLeft = new ArrayList();
ArrayList<Puu> treesRight = new ArrayList();

/*
 * Processing's drawing method
 */

float beat;

public void drawHightway() {
  noCursor();
  //scale(width/1000);
  translate(width/2, height/2, 0);
  moonlander.update();
  background(0);
  rectMode(CENTER);
  
  //Rocket values
  float musicNoise = (float) moonlander.getValue("noiseFactor");
  beat = (float) moonlander.getValue("speed");
  beatTrees();
  //Drawings
  scale(5,5);
  noiseLines(musicNoise);
  scale(0.2f,0.2f);
  
 
  moveRoadmarks(40.5f);
  moveTrees(27.5f);
    
  checkRoadmarksAndTrees();
  
  drawRoad();
  drawTrees();
  drawRoadmarks();
  drawHorizon();
  drawMoon();
}

public void noiseLines(float musicNoise) {
  float noiseScale = 0.02f;
  noFill();
  strokeWeight(1);
  int c = 0xff42C6FF;
  for (int x=-width; x < width; x += 10) {
    float noiseVal = noise((musicNoise + x)*noiseScale, musicNoise*noiseScale);
    stroke(c);
    if(x > -140 && x < 140) {
      if(x > - 100 && x < 100) {
        if(x > -10 && x < 10) {
          line(x, VERT_VANISHING_POINT, NOISEBARS_DISTANCE,
               x, VERT_VANISHING_POINT - noiseVal * 50, NOISEBARS_DISTANCE);
        } else {
          line(x, VERT_VANISHING_POINT, NOISEBARS_DISTANCE,
               x, VERT_VANISHING_POINT - noiseVal * 100, NOISEBARS_DISTANCE);
        }
      } else {
        line(x, VERT_VANISHING_POINT, NOISEBARS_DISTANCE,
             x, VERT_VANISHING_POINT - noiseVal * 150, NOISEBARS_DISTANCE);
      }
    } else {
      line(x, VERT_VANISHING_POINT, NOISEBARS_DISTANCE, 
           x, VERT_VANISHING_POINT - noiseVal * 200, NOISEBARS_DISTANCE);
    }
  }
}

public void beatTrees() {
  for (int i = 0; i < treesLeft.size(); i++) {
    treesLeft.get(i).setMod(beat);
    treesRight.get(i).setMod(beat);
  }
}

public void generateRoadMarks() {
  
  float initialZ = 0;
  for(int i = 0; i < 9000; i += MARKINGS_DISTANCE) {
    marks.add(new Roadmark((initialZ - i)));
  }
}

public void initTrees() {
  
  float initialZ = 0;
  for(int i = 0; i < 6000; i += TREES_DISTANCE) {
    treesLeft.add(new Puu(-500, 250, initialZ - i, TREE_SIZE));
  }
  for(int i = 0; i < 6000; i += TREES_DISTANCE) {
    treesRight.add(new Puu(500, 250, initialZ - i, TREE_SIZE));
  }
}

public void drawTrees() {
  for(Puu tree : treesLeft) {
    tree.draw();
  }
  for(Puu tree : treesRight) {
    tree.draw();
  }
}

public void moveRoadmarks(float step) {

  for(Roadmark mark : marks) {
    mark.moveCloser(step);
  }
}

public void moveTrees(float step) {
  for(Puu tree : treesLeft) {
    tree.moveCloser(step);
  }
  for(Puu tree : treesRight) {
    tree.moveCloser(step);
  }
}

public void drawRoadmarks() {
  for(Roadmark mark : marks) {
    mark.drawMarking();
  } 
}

public void checkRoadmarksAndTrees() {
  if(marks.get(0).isOutsideView(200)) {
    marks.remove(0);
    marks.add(new Roadmark(marks.get(marks.size() - 1).z1 - MARKINGS_DISTANCE));
  }
  if(treesLeft.get(0).isOutsideView(500)) {
    treesLeft.remove(0);
    treesLeft.add(new Puu(-500, 250, treesLeft.get(treesLeft.size() - 1).z - MARKINGS_DISTANCE, TREE_SIZE));
  }
  if(treesRight.get(0).isOutsideView(500)) {
    treesRight.remove(0);
    treesRight.add(new Puu(500, 250, treesRight.get(treesRight.size() - 1).z - MARKINGS_DISTANCE, TREE_SIZE));
  }
}

public void drawRoad() {
  noFill();
  stroke(0xff42C6FF);
  strokeWeight(4);
  line(
    -(width - 10), //X1
    height, //Y1
    -70, //Z1
    -2, //X2
    VERT_VANISHING_POINT - 15, //Y2
    100 //Z2
    );
  line(
   (width - 10), //X1
   height, //Y1
   -70, //Z1
   2, //X2
   VERT_VANISHING_POINT - 15, //Y2
   100 //Z2
   );
}

public void drawMoon() {
  imageMode(CENTER);
  image(moon, 0, VERT_VANISHING_POINT - height/3.5f );
}

public void drawHorizon() {
  noFill();
  stroke(0xff42C6FF);
  scale(5,5);
  line((-width/2)*3, VERT_VANISHING_POINT, -6001, width, VERT_VANISHING_POINT,-6001);
  scale(0.2f,0.2f);
}
int w; //width of the wave
int spacing = 1; //space between ellipses
float[] values; //array to store height values for the wave
float yoff = 0.0f; //2nd dimension of perlin noise

public void setupNoiseWave() {
  frameRate(30);
  //colorMode(RGB, 255, 255, 255, 255);
  smooth();
  w = width + 16;
  values = new float[w / spacing];
}

public void drawNoiseWave() {
  background(0);
  createWave(300.0f);
  createWave(150.0f);
  createWave(50.0f);
}

float amplitude;

public void createWave(float amplitude) {
  float dx = 0.02f;
  float dy = 0.07f;
  //float amplitude = 300.00f;

  //Increment y
  yoff += dy;
  float xoff = yoff;

  for (int i = 0; i < values.length; i++) {
    // 2D noise function
    values[i] = (1 * noise(xoff, yoff) - 1) * amplitude;
    xoff += dx;
  }

  //Simple way to draw the wave with an ellipse at each location
  for (int x = 0; x < values.length; x++) {
    noStroke();
    fill(0xff42c6ff);
    ellipseMode(CENTER);
    ellipse (x * spacing, width / 2 + values[x], 2, 2);
  }
  PFont font;
  font = createFont("../data/METAG.TTF", 28);
  fill(0xffff0081);
  textFont(font);
  text("m a h a p o y d a l _ A T K   p r o u d l y   p r e s e n t s", width/30, height/7.2f);
  text("f i r s t   t i e m", width/2.4f, height/2.8f);
}
class Puu {
  
  float points = 52;
  float x, y, z;
  float size;
  float change = 0;
  float changeD = 0.01f;
  float palmMod;
  float palmAddition;
  float varsiSize;
  
  Puu(float x, float y, float z, float size) {
    this.x = x;
    this.y = y;
    this.z = z;
    this.size = size;
    varsiSize = size*6;
  }
  
  public void setMod(float mod) {
    this.palmMod = mod;
  }
  
  public void setPos(float x, float y, float z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }
  
  public void draw() {
    //stroke(#ff0081);
    noStroke();
    fill(0xffff0081);
    strokeWeight(2);
    change += changeD;
    if(change > 10) change = 0;
    PVector v;
    float section = PI/points;
    beginShape();
    for (int i = 0; i < points; i++) {
      v = PVector.fromAngle(-section*i);
      if(i == points-1) v = PVector.fromAngle(PI);
      if(section*i < HALF_PI) {
        float m = (PI-section*i)/PI;
        palmAddition = (m*m*m*size)*3;
      } else {
        float m = (PI-(PI-section*i))/PI;
        palmAddition = (m*m*m*size)*3;
      }
      if(i%3 == 0) {
        v.setMag(size + palmAddition);
      } else {
        v.setMag(noise(i/2+change)*palmMod*50 + size + palmAddition);
      }
      vertex(x+v.x,y-varsiSize+v.y, z+v.z);
    }
    endShape();
    //varsi
    beginShape();
    vertex(x+varsiSize*0.083f,y+varsiSize/2-varsiSize, z);
    vertex(x+varsiSize*0.083f,y+varsiSize-varsiSize, z);
    vertex(x-varsiSize*0.045f,y+varsiSize-varsiSize, z);
    vertex(x,y+varsiSize/2-varsiSize, z);
    vertex(x,y-varsiSize,z);
    endShape();
  }
  
  public void moveCloser(float step) {
    this.z += step;
  }
  
  public boolean isOutsideView(float limit) {
    if(this.z < limit) {
      return false;
    } else {
    return true;
    }
  }
}
class Roadmark {
  
  float x = 0;
  float y = height/2;
  
  float z1;
  float z2;
  
  Roadmark(float z1) {
    this.z1 = z1;
    this. z2 = z1 - 70;
  }
  
  public void drawMarking() {
    noFill();
    stroke(0xff42C6FF);
    strokeWeight(2);
    this.z2 = z1 - 130;
    line(
      x,
      y,
      z1,
      x,
      y,
      z2
    );
  }
  
  public void moveCloser(float step) {
    this.z1 += step;
    this.z2 = z1 - 30;
  }
  
  public boolean isOutsideView(float limit) {
    if(this.z1 < limit) {
      return false;
    } else {
    return true;
    }
  }
}
class Star {
  float x;
  float y;
  float z;
  float pz;

  Star() {
    x = random(-width, width);
    y = random(-height, height);
    z = random(width);
    pz = z;
  }

  public void update() {
    z = z - 10; //speed
    if (z < 1) {
      z = width;
      x = random(-width, width);
      y = random(-height, height);
      pz = z;
    }
  }
  
  public void show() {
    fill(66, 198, 255);
    noStroke();
    
    float sx = map(x / z, 0, 1, 0, width);
    float sy = map(y / z, 0, 1, 0, height);
   
    float r = map(z, 0, width, 5, 0);
    ellipse(sx, sy, r, r);
    
    float px = map(x / pz, 0, 1, 0, width);
    float py = map(y / pz, 0, 1, 0, height);

    stroke(66, 198, 255);
    line(px, py, sx, sy);
  }
}
Star[] stars = new Star[1000];

float z = -1000;

public void setupStars() {
  for (int i = 0; i < stars.length; i++) {
    stars[i] = new Star();
  }
}

public void drawStars() {
  background(0);
  translate(width/2, height/2);
  
  for (int i = 0; i < stars.length; i++) {
    stars[i].update();
    stars[i].show();
  }
}

public void showGreets() {
  PFont font;
  font = createFont("../data/METAG.TTF", 48);
  textFont(font);
  fill(244, 34, 90);
  text("G r e e t i n g s", width / 200, -70, z);
  textAlign(CENTER, TOP);
  text("G r a f f a t h o n  2 O 1 B", width / 200, -50, z);
  textAlign(CENTER, CENTER);
  text("m a h a p o y d a l _ A T K", width / 200, height / 15, z);
  textAlign(CENTER, BOTTOM); 
}

public void moveText(float step) {
  z = (z + step);
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#666666", "--hide-stop", "graffathon2018" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
