//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Runtime.InteropServices;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID7c67ef25_49ed_426b_bab2_5828d5c0b521
{
    public class Class_SmokeNoise : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Time = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            SubSpeed = 6,
            SubScale = 7,
            MainScale = 8,
            BaseOffsetX = 9,
            BaseOffsetY = 10,
            SubStrength = 11,
            SubShift = 12,
            MainSpeed = 13,
            Bias = 14
        }
        //<<< _inputids

        //int[] _permutationTable = new int[512];
        //int _permutaionTableSize = 512 * 4 * 4; // 512 entries * intSize * 16byte alignment padding
        //Buffer _permutationTableConstBuffer;


        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> _params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Time = inputs[(int)InputId.Time].Eval(context).Value;
                var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
                var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
                var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
                var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
                var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
                var SubSpeed = inputs[(int)InputId.SubSpeed].Eval(context).Value;
                var SubScale = inputs[(int)InputId.SubScale].Eval(context).Value;
                var MainScale = inputs[(int)InputId.MainScale].Eval(context).Value;
                var BaseOffsetX = inputs[(int)InputId.BaseOffsetX].Eval(context).Value;
                var BaseOffsetY = inputs[(int)InputId.BaseOffsetY].Eval(context).Value;
                var BaseOffset = new Vector2(BaseOffsetX, BaseOffsetY);
                var SubStrength = inputs[(int)InputId.SubStrength].Eval(context).Value;
                var SubShift = inputs[(int)InputId.SubShift].Eval(context).Value;
                var MainSpeed = inputs[(int)InputId.MainSpeed].Eval(context).Value;
                var Bias = inputs[(int)InputId.Bias].Eval(context).Value;
                //<<< _params

                    
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));             

                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Time").AsScalar().Set(Time);
                    _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB, ColorA));
                    _effect.GetVariableByName("SubSpeed").AsScalar().Set(SubSpeed);
                    _effect.GetVariableByName("SubScale").AsScalar().Set(SubScale);
                    _effect.GetVariableByName("MainScale").AsScalar().Set(MainScale);
                    _effect.GetVariableByName("BaseOffset").AsVector().Set(new Vector2(BaseOffsetX, BaseOffsetY));
                    _effect.GetVariableByName("SubStrength").AsScalar().Set(SubStrength);
                    _effect.GetVariableByName("SubShift").AsScalar().Set(SubShift);
                    _effect.GetVariableByName("MainSpeed").AsScalar().Set(MainSpeed);
                    _effect.GetVariableByName("Bias").AsScalar().Set(Bias);
                //<<< _setup

                    Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}

