//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDeea53f81_d17c_4286_82ba_d1bf43318e22
{
    public class Class_Sin : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            angle = 0,
            period = 1,
            amplitute = 2,
            offset = 3,
            phase = 4
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var angle = inputs[(int)InputId.angle].Eval(context).Value;
            var period = inputs[(int)InputId.period].Eval(context).Value;
            var amplitute = inputs[(int)InputId.amplitute].Eval(context).Value;
            var offset = inputs[(int)InputId.offset].Eval(context).Value;
            var phase = inputs[(int)InputId.phase].Eval(context).Value;
            //<<< _params
            
            
            context.Value = (float) (Math.Sin((angle + phase) / period *Math.PI) * amplitute + offset );
            
            return context;
        }
    }
}

