using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using SharpDX;
using SharpDX.Direct3D11;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.IDe4fb57ea_1e2a_4a45_9969_0356de61f2a7
{
    public class Class_PremultiplyShader : FXSourceCodeFunction, IFXSceneSourceCode, IMaterial    
    {

        class Renderer : BaseRenderer
        {
        }

        public override void Dispose() {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5,
            OverrideAlpha = 6
        }
        //<<< _inputids
        bool _firstEval = true;
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            var OverrideAlpha = (int) inputs[(int)InputId.OverrideAlpha].Eval(context).Value;
            //<<< _params
        
            if (_firstEval) {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            using (new PropertyStasher<OperatorPartContext>(context, "Effect", "Renderer")) {
                context.Effect = _effect;
                context.Renderer = _renderer;
            

                var prevMaterial = (IMaterial) context.Objects[OperatorPartContext.MATERIAL_ID];
                
                if(OverrideAlpha > 0.5f) {
                    ColorA *= prevMaterial.Diffuse.Alpha;
                    
                }
                Color.Alpha = ColorA;
                Diffuse = Color;
                
                _effect.GetVariableByName("Color").AsVector().Set(new Vector4(ColorR, ColorG, ColorB,ColorA)); 
                
                context.Objects[OperatorPartContext.MATERIAL_ID] = this;
                Scene.Eval(context);
                
                context.Objects[OperatorPartContext.MATERIAL_ID] = prevMaterial;
                
            }

            return context;
        }

        private Renderer _renderer = new Renderer();
        
        public Color4 Ambient { get; private set; }
        public Color4 Diffuse { get; private set; }
        public Color4 Specular { get; private set; }
        public Color4 Emission { get; private set; }
        public float Shininess { get; private set; }
    }
}


