//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Curve;

namespace Framefield.Core.ID49163ffa_f4e9_406f_8b5c_602c6adc276f
{
    public class Class_Curve : Curve.Curve
    {
        //>>> _inputids
        private enum InputId
        {
            U = 0
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var U = inputs[(int)InputId.U].Eval(context).Value;
            //<<< _params

            context.Value = (float)GetSampledValue(U);
            return context;
        }

        public Class_Curve() {
            ChangedEventEnabled = true;
        }

        private CurveState State
        {
            get
            {
                try
                {
                    return OperatorPart.Parent.GetOperatorPartState(OperatorPart.ID) as CurveState;
                }
                catch (Exception ex)
                {
                    Logger.Error(this,"could not get the CurveState for this Curve op: {0}", ex.Message);
                }
                return null;
            }
        }
    }

    //only here so that an operatorpartstate can be found
    //and created
    public class CurveState : Curve.CurveState
    {
    }
} 
