#version 450 core

#include "include/AppInfo-ubo.inc.glsl"

#include "include/utils.inc.glsl"
#include "include/bsdf.inc.glsl"
uniform sampler2D iChannel0;

in vec3 fColor;
in vec3 fNormal_cs;
in vec3 fPosition_cs;
in vec3 toLight_cs;

out vec4 color;

void main() {
	float fac = clamp(sin(exp(sin(iTime)* 2.0)), 0.0, 1.0);

	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	vec3 normal_cs = normalize(fNormal_cs);
	vec3 toCam_cs = normalize(-fPosition_cs);
	vec3 toLight_cs = normalize(toLight_cs);
	float roughness = 0.2;
	float metallic = 1.0;
	vec3 basecolor = texture(iChannel0, uv + normal_cs.xy * fac * 0.01).rgb + vec3(0.1);
	//basecolor = fColor;
	vec3 c = basecolor * 0.2 + bsdfPbrMetallicRoughness(toCam_cs, toLight_cs, normal_cs, basecolor, roughness, metallic);
	//c = mix(c, basecolor, fac);
	//c = basecolor;
    color = vec4(c * 2.0, 1.f);
}
