
//--------------------------------------------------------------------------
void tiles01_mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float _TimeOffset = slider0; // "Time Offset" 0.0
	float _TimeFactor = slider1; // "Time Factor" 1.0

	float _RadiusPow = slider2 * 2.0;
	float _Zoom = slider3 * 10.0;
	float _PosX = slider4;
	float _PosY = slider5;

	float _GlobalFade = slider6;
	float _Unglitch = slider7;

	float _TimeExcentricity = slider8; // "Time Deform Excentrycity" 0
	float _TimeDeform = slider9 * 4.0; // "Time Deform" 0

	float _ShowE = slider10;
	float _ShowJ = slider11;

	vec2 co = fragCoord.xy / iResolution.y;
	co = (co - vec2(_PosX, _PosY)) / _Zoom;

	float time = _TimeOffset + _TimeFactor * iTime;
	time += mix(length(co - vec2(0.5)), co.x, _TimeExcentricity) * _TimeDeform;

	vec3 albedo;

	vec2 uv = fract(co * 4) * 2.0 - vec2(1.0, 1.0);
	vec2 uv0 = co * 2.0 - vec2(1.0, 1.0);
	vec2 uvid = floor(co * 4);

	float theta = atan(uv.y, uv.x);
	float r = length(uv);
	albedo.r = theta / (2.0 * pi);

	float blades = 6.0 + sin(time) * 3;
	float theta2 = fract(theta / (2.0 * pi) * blades) * (2.0 * pi) / blades;
	vec2 uv2 = r * vec2(cos(theta2), sin(theta2));
	albedo.g = step(0.1, uv2.x) - step(0.2, uv2.x);
	albedo.g = mod(uv2.x, 0.1);

	blades = 24;
	float bottomPow = 1.5;
	float topPow = mix(0.1, 2.0, pow(r, 2.0));
	float radiusPow = _RadiusPow;

	float r2 = fract(pow(r, radiusPow) * 2.0 - time);

	float theta3 = fract(theta / (2.0 * pi) * blades) * (2.0 * pi) / blades;
	float aperture = 2.0 * pi / blades;
	float bottom = step(0.5 + pow(abs(1 - 2.0 * theta3 / aperture), bottomPow) * 0.25, r);
	//float bottom = step(0.5 + acos(abs(1 - 2.0 * theta3 / aperture)) * 0.25, r);
	bottom = step(0.5 + acos(abs(1 - 2.0 * theta3 / aperture)) * 0.25, r2);
	float top = step(-(1.0 - pow(abs(1 - 2.0 * theta3 / aperture), topPow) * 0.25), -r2);

	blades = 24;

	float unsurdeux = mod(uvid.x + uvid.y,  2);

	vec3 color;
	albedo = vec3(0.0, 0.0, 0.0);
			
	color = mix(sienne, grey, unsurdeux) * 0.5;
	topPow = mix(0.1, 2.0, pow(r, 2.0));
	albedo += patternAcosBottom(r2, theta, blades, 1.5, topPow) * color;

	color = mix(redsienne, sienne, unsurdeux) * 0.5;
	topPow = mix(2.0, 0.1, pow(r, 2.0));
	albedo += patternAcosBottom(r2, theta + 2.0 * pi / blades / 2.0, blades, 1.5, topPow) * color;

	albedo += pattern02(r2 - 0.1, theta) * color;
	fragColor = vec4(albedo, 1.0);

	if (_ShowE > 0.5) {
		vec2 rawco = fragCoord.xy / iResolution.y * 1.5;
		float e = (step(0.1, rawco.x) - step(0.11, rawco.x)) * (step(0.1, rawco.y) - step(0.182, rawco.y));
		e += (step(0.16, rawco.x) - step(0.17, rawco.x)) * (step(0.1, rawco.y) - step(0.182, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.1, rawco.y) - step(0.116, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.133, rawco.y) - step(0.149, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.166, rawco.y) - step(0.182, rawco.y));
		float c = cos(-0.5);
		float s = sin(-0.5);
		rawco = mat2(c, s, -s, c) * rawco + vec2(-0.07,  -0.0);
		float accent = (step(0.11, rawco.x) - step(0.17, rawco.x)) * (step(0.1, rawco.y) - step(0.116, rawco.y)) * pow(sin(iTime * 7), 2.0);
		float textMask = step(r2 - 0.1, 0.15) * (1.0 - pattern02(r2 - 0.1, theta));
		fragColor += (e + accent) * textMask;
	}

	if (_ShowJ > 0.5) {
		vec2 rawco = fragCoord.xy / iResolution.y * 1.5 - vec2(2.0, 0.0);
		float e = (step(0.1, rawco.x) - step(0.11, rawco.x)) * (step(0.1, rawco.y) - step(0.182, rawco.y));
		e += (step(0.16, rawco.x) - step(0.17, rawco.x)) * (step(0.1, rawco.y) - step(0.182, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.1, rawco.y) - step(0.116, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.133, rawco.y) - step(0.149, rawco.y));
		e += (step(0.1, rawco.x) - step(0.16, rawco.x)) * (step(0.166, rawco.y) - step(0.182, rawco.y));
		float c = cos(-0.5);
		float s = sin(-0.5);
		rawco = mat2(c, s, -s, c) * rawco + vec2(-0.07,  -0.0);
		float accent = (step(0.11, rawco.x) - step(0.17, rawco.x)) * (step(0.1, rawco.y) - step(0.116, rawco.y)) * pow(sin(iTime * 7), 2.0);
		float textMask = step(r2 - 0.1, 0.15) * (1.0 - pattern02(r2 - 0.1, theta));
		fragColor += (e + accent) * textMask;
	}

	if (_Unglitch > 0.5) {
		fragColor.rgb *= _GlobalFade;
	}
	else {
		fragColor *= _GlobalFade;
	}
}

