const vec3 grey = vec3(97, 101, 113) / 255.0;
const vec3 darkyellow = vec3(210, 156, 31) / 255.0;
const vec3 yellow = vec3(231, 184, 41) / 255.0;
const vec3 sienne = vec3(140, 93, 82) / 255.0;
const vec3 redsienne = vec3(240, 93, 82) / 255.0;
const vec3 hazelnut = vec3(180, 114, 86) / 255.0;
const vec3 lightorange = vec3(226, 142, 100) / 255.0;
const vec3 black = vec3(0.0, 0.0, 0.0);
const vec3 white = vec3(1.0, 1.0, 1.0);

float pattern(float r, float theta, float blades, float bottomPow, float topPow) {
	float theta3 = fract(theta / (2.0 * pi) * blades) * (2.0 * pi) / blades;
	float aperture = 2.0 * pi / blades;
	float bottom = step(0.5 + pow(abs(1 - 2.0 * theta3 / aperture), bottomPow) * 0.25, r);
	float top = step(-(1.0 - pow(abs(1 - 2.0 * theta3 / aperture), topPow) * 0.25), -r);
	return bottom * top;
}
float patternAcosBottom(float r, float theta, float blades, float bottomPow, float topPow) {
	float theta3 = fract(theta / (2.0 * pi) * blades) * (2.0 * pi) / blades;
	float aperture = 2.0 * pi / blades;
	float bottom = step(0.5 + acos(abs(1 - 2.0 * theta3 / aperture)) * 0.25, r);
	float top = step(-(1.0 - pow(abs(1 - 2.0 * theta3 / aperture), topPow) * 0.25), -r);
	return bottom * top;
}
float pattern02(float r, float theta) {
	return step(0.1, r) * step(r, 0.11) + step(0.13, r) * step(r, 0.15);
}
float pattern03(float r, float theta) {
	return step(0.1, r) * step(r, 0.11) + step(0.13, r) * step(r, 0.15);
}


float hash(float n)
{
	return fract(sin(n)*43758.5453);
}

float noise(vec3 x)
{
	// The noise function returns a value in the range -1.0f -> 1.0f

	vec3 p = floor(x);
	vec3 f = fract(x);

	f = f * f*(3.0 - 2.0*f);
	float n = p.x + p.y*57.0 + 113.0*p.z;

	return mix(mix(mix(hash(n + 0.0), hash(n + 1.0), f.x),
		mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y),
		mix(mix(hash(n + 113.0), hash(n + 114.0), f.x),
			mix(hash(n + 170.0), hash(n + 171.0), f.x), f.y), f.z);
}

float diffstep(float a, float b, float x, float smoothness) {
	return smoothstep(a - smoothness, a, x) - smoothstep(b, b + smoothness, x);
}

// The % operator behaves weird with negative values
float mod(float x, float a) {
	return fract(x / a) * a;
}

