uniform sampler2D D;
uniform vec2 RT, anim[9];
vec2 pipeDistance2( vec2 lpos, float outdir, float indir, float subt ) {
  if( outdir == 0. ) {
    return normalize(lpos) * max( 0.0, 1.0 - length( lpos) *2.0 ) ;
  }
  mat2 reorient = mat2(1);
  if( outdir == 2. ) reorient = mat2( 0, 1, -1, 0 );
  if( outdir == 3. ) reorient = mat2( -1 );
  if( outdir == 4. ) reorient = mat2( 0,-1, 1, 0 );
  vec2 dir_rd = -vec2(
    mod( indir ,2.0),
    mod(floor(indir/2.0),2.0)
  );
  vec2 dir_lu = vec2(
    mod(floor(indir/4.0),2.0),
    mod(floor(indir/8.0),2.0)
  );
  vec2 mid = vec2(9);
  lpos *= reorient;
  dir_lu *= reorient;
  dir_rd *= reorient;
  if( indir == 0. )
  {
    if( subt > 0.5 )
    {
      mid = vec2( max( 0.0, min(lpos.x,subt-0.5) ), 0 ) -lpos;
    }
    else
    if( subt > 0.0 )
    {
      lpos /= subt*2.0;
      mid = -lpos ;
    }
  }
  if( dir_lu.x < 0.0 || dir_rd.x < 0.0 ) {
    mid = vec2( min( subt-0.5, lpos.x) -lpos.x , -lpos.y );
  }
  if( dir_lu.y > 0.0 || dir_rd.y > 0.0 ) {
    vec2 mid2 = vec2( 0 , 0.5-subt ) - lpos;
    if( subt > 0.0 ) {
      mid2 = 0.5 - lpos;
      float angle = min( atan(mid2.y,mid2.x) , subt*3.1415/2.0 );
      mid2 -= vec2( cos(angle),sin(angle) )*0.5 ;
    }
    if( length(mid2) < length(mid) )mid=mid2;
  }
  if( dir_lu.y < 0.0 || dir_rd.y < 0.0 ) {
     vec2 mid2 = vec2( 0 , subt-0.5 ) - lpos ;
     if( subt > 0.0 ) {
       mid2 = vec2(0.5,-0.5) - lpos;
       float angle = max( atan(mid2.y,mid2.x) , -subt*3.1415/2.0 );
       mid2 -= vec2( cos(angle),sin(angle) )*0.5 ;
    }
    if( length(mid2) < length(mid) )mid=mid2;
  }
  return mid * reorient *reorient *reorient;
}
void main() {
    vec2 coord = gl_FragCoord.xy / RT.x - vec2( 8.0/9.0 , 0.5 );
    vec2 T = vec2( 1.0 - fract(RT.y), fract(RT.y) );
    vec3 Q;
    vec3 pos = vec3( 0, dot(anim[3],T), -dot(anim[2],T) );
    vec3 dir = normalize(vec3( coord , sqrt( 1.0 + dot(anim[7],T) * length(coord) ) ));
    dir.xy *= mat2( cos(dot(anim[8],T)*3.1415),sin(dot(anim[8],T)*3.1415), -sin(dot(anim[8],T)*3.1415),cos(dot(anim[8],T)*3.1415) );
    dir.yz *= mat2( cos(dot(anim[4],T)),sin(dot(anim[4],T)), -sin(dot(anim[4],T)),cos(dot(anim[4],T)) );
    for (float l = 0.0; l < 3.0; l+=1.0) {
        if( l >= anim[0].x )break;
        float t = ( -pos.z - l * anim[0].y )/dir.z;
        vec2 hit = (pos+t*dir).xy * (64.0/3.0);
        if (l > 1.)
            hit += l*15.0;
        vec2 sub = fract( hit );
        hit -= sub;
        vec4 fbits = texture2D( D, hit / 64.0 ) *255.0;
        sub -= 0.5;
        vec2 pdir = pipeDistance2( sub , fbits.b, fbits.a, dot(anim[1],T) - fbits.r );
        float scale = 0.5 + cos(hit.x)/4.0 ;
 float pdist = length(pdir) / scale;
        float fade = smoothstep(0.5, 0.47, pdist);
 float margin = dot(anim[5],T) ;
        if (margin < 0.0) {
            fade *= smoothstep(-margin, -margin-0.01, length(sub));
        }
        if (margin > 0.0) {
            fade *= smoothstep(margin, margin-0.01, max(abs(sub.y), abs(sub.x) ));
        }
        float gm = dot( dir, normalize(vec3(pdir,0.5)) );
        float st = smoothstep(0.8, 0.7, t) * (1.0-step(0.09, anim[0].y));
        vec3 cd = mix(vec3(0.2,0.2,0.3), vec3(0.35, 0.7, 1.0),min(1.0, t/5.0) );
        cd += smoothstep(2.0, 0.0, t) * vec3(0.5, 0.0, -0.1);
        cd += smoothstep(4.0, 6.0, t) * vec3(0.3);
        if (anim[0].y < 0.1) {
            cd *= (0.5+gm*0.5);
        }
        if (l == 0.) {
            Q = min(1.0, dot(
   smoothstep(
     vec2(0.5),
     vec2(0.49-min(t*t*0.05, 0.1)),
     abs(sub)
    ), vec2(.5)
   ) /4.0 + 0.75) * cd;
            Q *= mix(1.0, smoothstep(0.0, 0.5,pdist), fade) *0.2 + 0.8;
        }
        else
        {
            vec3 crayon = (vec3(pow(abs(sin(pdist*2.0*3.14*dot(anim[6],T))) ,0.5)) * vec3(0.50) + sin( atan( pdir.y, pdir.x )*2.0 + dot(anim[8],T) )*0.5)/ (1.0+t*0.2);
            crayon = mix( crayon, vec3(dot( crayon , cd )) , 0.5 );
            Q = mix( Q, crayon , fade );
        }
    }
    Q *= vec3(1.0, 0.85, 0.85) * (1.0 - pow(4.0 * (T.y-0.5) * (T.y-0.5), 8.0) ) ;
    gl_FragColor = vec4( pow(Q, vec3(1.0/2.2) ) , 1);
}
