
#include <math.h>
#include <stdbool.h>
#include <stdlib.h>
#include <nds.h>

//#include "background.h"
#include "REZ_ASCII_bin.h"
#include "music_bin.h"

/* idgaf */
#include "glfix.h"
#include "quad.h"
#include "meshes.h"
#include "scroll.h"
#include "bg.h"

static float rylogo = 0.0f;
static int cubectr = 0, curcube = 0;
#define NCUBES (2)
#define CUBELEN (8*60)
#define PHASEDT (30)

static bool upd(int keys) {
    rylogo += 0.3f;

    scroll_update();

    cubectr++;
    if (cubectr == CUBELEN) {
        cubectr ^= cubectr;
        curcube++;
        curcube &= NCUBES-1;
    }

    if (keys & KEY_START) return true;

    return false;
}

static void draw() {
    glLoadIdentity();

    glMaterialf(GL_AMBIENT,RGB15(24,24,24));
    glMaterialf(GL_DIFFUSE,RGB15(16,16,16));
    glMaterialf(GL_SPECULAR,BIT(15)|RGB15(16,16,16));
    glMaterialf(GL_EMISSION,RGB15(8,8,8));
    glMaterialShinyness();
    glPolyFmt(POLY_ALPHA(0x1F)|POLY_CULL_NONE|POLY_FORMAT_LIGHT0);

    glTranslatef(0,0,-5);

    glPushMatrix();
    glTranslatef(0,-1,0);
    glRotateY(/*180+*/rylogo*-6.75f);
    scroll_draw();
    glPopMatrix(1);

    glRotatef(rylogo,1,0,1);
    glRotateY(rylogo*2);
    float scale = 1.0f;
    if (cubectr <          PHASEDT ) scale =            cubectr  * (1.0f / PHASEDT);
    if (cubectr > (CUBELEN-PHASEDT)) scale = (CUBELEN - cubectr) * (1.0f / PHASEDT);
    glScalef(scale,scale,scale);

    switch (curcube) {
    case 0: dumbcube(); break;
    case 1: k2logo  (); break;
    }

    glPolyFmt(POLY_ALPHA(0x1F)|POLY_CULL_NONE);
}

int main() {
    videoSetMode(MODE_3_3D|DISPLAY_SPR_1D_LAYOUT);
    vramSetBankA(VRAM_A_MAIN_BG);
    vramSetBankB(VRAM_B_TEXTURE);

    videoSetModeSub(MODE_0_2D);
    vramSetBankC(VRAM_C_SUB_BG);
    consoleInit(0,1,BgType_Text4bpp, BgSize_T_256x256, 31,0,false,true);

    int bg = bgInit(2, BgType_Text8bpp, BgSize_T_256x256  , 1, 0);
    bg_init(bg);
    //bgInit(3, BgType_Bmp16   , BgSize_B16_256x256, 1, 0);
    //decompress(backgroundBitmap, BG_GFX, LZ77Vram);

    soundEnable();
    soundPlaySample(music_bin, SoundFormat_ADPCM, music_bin_size, 48000,
            0xFF, 0x40, true, 0);

    glInit();
    glEnable(GL_TEXTURE_2D|GL_ANTIALIAS|GL_BLEND);
    glClearColor(0,0,0,0);
    glClearPolyID(0x3F);
    glClearDepth(0x7FFF);
    glViewport(0,0,0xFF,191);

    scroll_init();

    rylogo=-180.0f;
    for(;;){
        scanKeys();
        if (upd(keysDown())) break;
        bg_update(bg);

        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();

        gluPerspective(70,1.333333f,0.1f,100);

        glLight(0,RGB15(16,16,16),0,floattov10(-1),0);
        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        draw();
        glPopMatrix(1);
        glFlush(0);

        swiWaitForVBlank();
    }

    soundDisable();

    return 0;
}

