#include "common_vs.glsl"



// ----------------------------------------------------------------------------
// Variables de skinning

uniform mat4 bind_shape_matrix ;

uniform mat4 inverse_bind_matrix[NUMERO_MAXIMO_JOINTS_POR_ARMATURE] ;
uniform mat4 transformation_matrix[NUMERO_MAXIMO_JOINTS_POR_ARMATURE] ;

uniform float num_influencias ;

vec4 pos_final ;
vec3 normal_final ;



// ------------------------------------------------------------------------------------------------
//
//
void ProcesarSkinning()
{
  // --------------------------------------------------------------------------
  // Skinning
  // --------------------------------------------------------------------------

  //int num_influencias_a_procesar = int(num_influencias) ;

  {
    pos_final = vec4(0.0, 0.0, 0.0, 0.0) ;                                                        
    normal_final = vec3(0.0, 0.0, 0.0) ;

    vec4 pos_bindeada =  bind_shape_matrix * at_VertexCoords ;                  // Para hacerlo en este orden hay que usar la traspuesta
    vec3 normal_bindeada =  mat3(bind_shape_matrix) * at_Normal ;    // Para hacerlo en este orden hay que usar la traspuesta

    {

#ifdef DEBUGUEAR_SHADERS
      debug_color.r = 0.0 ;
      debug_color.g = 0.0 ;
      debug_color.b = 0.0 ;
#endif

#ifdef DEBUGUEAR_SHADERS
      color_influencias = vec4(0.0, 0.0, 0.0, 1.0) ;
#endif

      float peso_acumulado = 0.0 ;

      for(int var_influencia = 0; var_influencia < NUMERO_MAXIMO_INFLUENCIAS_POR_VERTICE/*num_influencias_a_procesar*/; var_influencia++) {

        int index = int(joint_indices[var_influencia]) ;
        float peso = joint_weights[var_influencia] ;

        if(index == -1) {

          // An index of -1 into the array of joints refers to the bind shape. (COLLADA Spec 1.4 pag 166)

          pos_final += pos_bindeada * peso ;
          normal_final += normal_bindeada * peso ;

          


#ifdef DEBUGUEAR_SHADERS
          debug_color.a = 1.0 ; //bHayError = 1.0 ;
          debug_color.r = 1.0 ;
          debug_color.g = 0.0 ;
          debug_color.b = 0.0 ;
#endif
        }
        else {

#ifdef DEBUGUEAR_SHADERS
          if(index > 21) color_influencias = vec4(1.0, 0.0, 0.0, 1.0) ;
#endif

          pos_final += ( transformation_matrix[index] * (inverse_bind_matrix[index] * pos_bindeada) ) * peso ;

          normal_final += (mat3(transformation_matrix[index]) * (mat3(inverse_bind_matrix[index]) * normal_bindeada) ) * peso ;
          peso_acumulado += joint_weights[var_influencia] ;
        }
      }

      // Descomentar esta lnea para ver los modelos en su postura de pose
      //return(pos_bindeada) ;

  ////    // Este if() permite corregir mallas que tienen vrtices sin influencias o pesos si pasan sin transformacin
  ////
  ////    if(peso_acumulado == 0.0) {
  ////
  ////      debug_color.a = 1.0 ; //bHayError = 1.0 ;
  ////
  ////      gl_Position = ModelViewProjectionMatrix * pos_bindeada ;
  ////    
  ////      debug_color.r = 1.0 ;
  ////      debug_color.g = 0.0 ;
  ////      debug_color.b = 0.0 ;
  ////    }

      // exactly same as vertices, except you only rotate normals and don't do any translations
      // at_Normal = normal_final ;     // Revisar
    }
  }

  
}




// ------------------------------------------------------------------------------------------------
//
//
void main()
{

#ifdef DEBUGUEAR_SHADERS
  debug_color.a = 0.0 ; //bHayError = 0.0 ;
  debug_color.rgb = vec3(0, 0, 0) ;
#endif

  ProcesarSkinning() ;
 
  if ( g_DatosMaterial.useLights == 0 ) {
    light_final_intensity = g_DatosMaterial.emission ;
    light_final_specular = vec3(0.0, 0.0, 0.0) ;
  }
  else {
    vec4 vertice_a_iluminar = WorldMatrix * pos_final ;
    vec3 normal_a_iluminar = mat3(NormalMatrix) * normal_final ;
    ProcesarIluminacion(vertice_a_iluminar, normal_a_iluminar) ;
    //ProcesarIluminacion(at_VertexCoords, at_Normal) ;
  }

  ProcesarTexturas() ;
  
  gl_Position = ModelViewProjectionMatrix * pos_final ;
}

