; Be Happy! - entry for DiHalt 2018
; 256b intro coded by TomCat/Abaddon

; Tell me which is your favorite smiley?
; - kapor@dit.hu

X=128
Y=92
Z=2

ORG 256
 MOV    AL,13H
 INT    10H             ; init 320x200 video mode
 PUSH   0A000H-2+20*(100-Y)
 POP    ES              ; center the image

 MOV    BH,Y*2          ; number of rows

nextloop:
 MOV    SI,smiles
 MOV    CL,7            ; seven different faces

nextface:
 PUSHA
nextpixel:
 PUSH   SI
 CWD                    ; DL=background color

 TEST   BL,BL           ; first pixel in the row?
 JNZ    .2
 ADD    DI,64           ; border on sides
.2:

nextcircle:
 LODSB
 AAM    21
 MOV    CH,AH           ; CH=color
 AAM    7
 MOV    CL,AH           ; CL=shape
 INC    AX              ; AL=radius+1
 CMP    CH,12           ; highlight?
 JZ     .4
 IMUL   AX,AX,Z*6
 MUL    AL
.4:
 XCHG   BP,AX
 LODSB                  ; xcoord
 SUB    AL,BL
 IMUL   AL
 SHR    AX,CL
 RCL    AX,1
 SUB    BP,AX
 LODSB                  ; ycoord
 SUB    AL,BH
 IMUL   AL
 CMP    AX,BP           ; inside?
 JNL    .5
 MOV    DL,CH           ; DL=new color
.5:
 CMP    BYTE [SI],10*21+7*1+6
 JNE    nextcircle      ; face done?

 POP    AX
 XCHG   AX,SI           ; POP SI
 POP    BP              ; save DI
 POP    CX              ; ignore current frame pointer
 PUSH   AX              ; next frame pointer to SI
 PUSH   BP              ; restore DI

 XCHG   AX,DX
 CMP    AL,7
 SBB    AL,12
 ADC    AL,15           ; color 11 and 12 both white
 STOSB
 DEC    BX
 JNZ    nextpixel       ; last pixel?

 MOV    DS,BX
 MOV    DI,046CH        ; waiting for 8 timer ticks
.6:
 TEST   [DI],AL
 JNZ    .6
.7:
 TEST   [DI],AL
 JZ     .7
 PUSH   CS
 POP    DS

 XCHG   AX,SI           ; check keyboard buffer
 INT    16H
 POPA
 LOOPZ  nextface
 JZ     nextloop        ; no keypress?

;MOV    AL,3
;INT    10H
RETN                    ; exit

smiles:
; color(*21) + (7*)shape + radius, X coord, Y coord

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  1*21+7*1+4,X+Z*00,Y-Z*02
 DB 11*21+7*1+2,X+Z*00,Y-Z*02
 DB 10*21+7*2+3,X+Z*00,Y+Z*10
 DB  3*21+7*1+1,X-Z*14,Y+Z*07
 DB 10*21+7*1+1,X-Z*14,Y+Z*01
 DB  3*21+7*1+1,X+Z*14,Y+Z*07
 DB 10*21+7*1+1,X+Z*14,Y+Z*01

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  3*21+7*1+3,X+Z*00,Y-Z*03
 DB 10*21+7*1+4,X+Z*00,Y+Z*10
 DB  3*21+7*0+1,X-Z*13,Y+Z*08
 DB 10*21+7*0+1,X-Z*13,Y-Z*04
 DB  3*21+7*0+1,X+Z*13,Y+Z*08
;DB 10*21+7*0+1,X+Z*13,Y-Z*04

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  3*21+7*1+4,X+Z*00,Y-Z*03
 DB 10*21+7*1+4,X+Z*00,Y+Z*02
 DB  3*21+7*0+1,X-Z*13,Y+Z*10
 DB  3*21+7*0+1,X+Z*13,Y+Z*10

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  5*21+7*1+4,X+Z*00,Y+Z*01
 DB 10*21+7*1+4,X+Z*00,Y+Z*06
 DB  5*21+7*0+0,X-Z*13,Y+Z*22
 DB  5*21+7*0+0,X+Z*13,Y+Z*20

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  3*21+7*1+2,X+Z*00,Y-Z*06
 DB 10*21+7*2+2,X+Z*00,Y+Z*02
 DB  3*21+7*0+0,X-Z*15,Y+Z*10
 DB  3*21+7*0+0,X+Z*15,Y+Z*10

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  0*21+7*1+5,X+Z*00,Y+Z*00
 DB 10*21+7*1+3,X+Z*00,Y-Z*03
 DB  0*21+7*1+3,X+Z*00,Y+Z*05
 DB 10*21+7*1+0,X-Z*11,Y+Z*12
 DB 10*21+7*1+0,X+Z*12,Y+Z*12

 DB 10*21+7*1+6,X+Z*00,Y+Z*00
 DB  1*21+7*1+3,X+Z*00,Y-Z*10
 DB 11*21+7*1+2,X+Z*00,Y-Z*06
 DB 10*21+7*2+2,X+Z*00,Y-Z*01
 DB  7*21+7*1+2,X-Z*15,Y+Z*12
 DB  7*21+7*1+2,X+Z*15,Y+Z*12
 DB  6*21+7*1+1,X-Z*15,Y+Z*12
 DB  6*21+7*1+1,X+Z*15,Y+Z*12
 DB  5*21+7*1+0,X-Z*15,Y+Z*12
 DB  5*21+7*1+0,X+Z*15,Y+Z*12
 DB 12*21+7*0+3,X-Z*17,Y+Z*14
 DB 12*21+7*0+3,X+Z*13,Y+Z*14

 DB 10*21+7*1+6
