#include <stdio.h>

#include "concorde.h"
#include "ysmaze2.h"
#include "mzedit.h"
#include "ysgui.h"

#include <stdlib.h>
#include <string.h>
#include <winb.h>
#include <te.h>
#include <fntb.h>
#include <gui.h>
#include <wgb.h>
#include <FILE_DLG.H>	/*	gui.h肠Ƃinclude邱	*/



static int FileSelector(char *nam);


extern int ActiveWin;
extern MAZEWIN mzWin[MAZEWIN_NUM];
extern int Ys11Id;
extern int MenuBarDlg;



int pdTwSignatureFunc()
{
	char *str[3];
	YsSetIntroTitle("HGfB^");
	YsSetIntroName("Programmed By YS11");
	str[0]="Nifty   :PEB01130";
	str[1]="Internet:t91472sy@sfc.keio.ac.jp";
	str[2]="TeleStar:TS012309";
	YsSetIntro3Lines(str);
	YsIntroMessage(Ys11Id,0);
	return NOERR;
}


static void LoadOneFile(char *fileName);

int	LoadFileFunc()
{
	char fn[80];

	if(FileSelector(fn)==0)
	{
		LoadOneFile(fn);
	}

	return NOERR;
}

void LoadFileCom(int ac,char *av[])
{
	int i;

	for(i=0; i<ac; i++)
	{
		LoadOneFile(av[i]);
	}
}



static void LoadOneFile(char *fileName)
{
	int yesno,neo;
	MAZEMAP *mz;
	char fn[80];

	if((neo=CheckOpenWindow())<0)
	{
		YsConfirm(Ys11Id,"ȏWindowJƂł܂.",NULL);
		return;
	}

	mz=&mzWin[neo].map;

	while(1)
	{
		strcpy(fn,fileName);

		PutExt(fn,".MAZ");
		if(LoadMazeData(mz,fn)!=0)
		{
			yesno=
				YsYesNoQuestion
					(Ys11Id,"ǂݍ݂Ɏs܂","Ďs","f");
			if(yesno==0)
			{
				break;
			}
		}
		else
		{
			mzWin[neo].saveflag=TRUE;
			OpenNewWindow(neo);
			break;
		}

	}

	return;
}




int	SaveFileFunc()
{
	int yesno,abort;
	MAZEMAP *mz;
	char fn[80];
	FILE *fp;

	if(mzWin[ActiveWin].openflag==FALSE)
	{
		YsConfirm(Ys11Id,"ANeBuȃEBhE܂.",NULL);
		return NOERR;
	}

	mz=&mzWin[ActiveWin].map;


	abort=NO;
	while(abort==NO)
	{
		if(FileSelector(fn)<0)
		{
			abort=YES;
			break;
		}

		PutExt(fn,".MAZ");
		fp=fopen(fn,"r");fclose(fp);
		if(fp!=NULL)
		{
			if(YsYesNoQuestion(Ys11Id,"㏑ł?",NULL,NULL)!=0)
			{
				remove(fn);
			}
			else
			{
				continue;
			}
		}

		if(SaveMazeData(mz,fn)!=0)
		{
			yesno=
				YsYesNoQuestion
					(Ys11Id,"݂Ɏs܂","Ďs","f");
			if(yesno!=0)
			{
				continue;
			}
			else
			{
				abort=YES;
				break;
			}
		}
		else
		{
			mzWin[ActiveWin].saveflag=TRUE;
			abort=YES;
			break;
		}
	}

	return NOERR;
}

int	ClearMazeFunc()
{
	int wId,yesno;
	MAZEMAP *mz;

	if(mzWin[ActiveWin].openflag==FALSE)
	{
		YsConfirm(Ys11Id,"ҏW̃f[^܂.",NULL);
		return NOERR;
	}

	if(mzWin[ActiveWin].saveflag==FALSE)
	{
		yesno=YsYesNoQuestion
			(Ys11Id,"f[^ۑȂĂ悢ł?",NULL,NULL);
		if(yesno==0)
		{
			return NOERR;
		}
	}

	wId=mzWin[ActiveWin].win;
	mz=&mzWin[ActiveWin].map;

	MMI_SendMessage(wId, MM_ERASE, 0);
	MMI_SendMessage(wId, MM_DETACH, 0);
	ClearMaze(mz);

	return NOERR;
}


static int FileSelector(char *nam)
{
	int ret,atr,i;
	unsigned nfile;
	char *ext[]={"*.MAZ",NULL};

	MTL_setAtrObj(MenuBarDlg,MS_INACTIVEL40);
	for(i=0; i<MAZEWIN_NUM; i++)
	{
		MTL_setAtrObj(mzWin[i].win,MS_INACTIVEL40);
	}

	ret=FDG_DspFileDlg(Ys11Id,FDG_TEXT,NULL,ext,&nfile);

	if(ret==1)
	{
		FDG_GetPathName(nam,&atr,0);
	}

	MTL_resetAtrObj(MenuBarDlg,~MS_INACTIVEL40);
	for(i=0; i<MAZEWIN_NUM; i++)
	{
		MTL_resetAtrObj(mzWin[i].win,~MS_INACTIVEL40);
	}

	if(ret==1)
	{
		return 0;
	}
	else
	{
		return -1;
	}
}
