#pragma On(Align_all_labels)
#pragma On(Align_labels)

#include <tomahawk.h>

int PitchUp(int *dst,int *src,int d)
{
	int ev[3],uv[3];

	if(d==0)
	{
		dst[0]=src[0];
		dst[1]=src[1];
		dst[2]=src[2];
		return 0;
	}

	ev[0]= 0;            /* Eye Line Vector */
	ev[1]= 512*FxSinHq(d);
	ev[2]= 512*FxCosHq(d);
	RotVtoGHq(1,ev,ev,src);

	uv[0]= 0;            /* Up Vector */
	uv[1]= 512*FxCosHq(d);
	uv[2]=-512*FxSinHq(d);
	RotVtoGHq(1,uv,uv,src);

	dst[0]= FxAngle(ev[2],-ev[0]);
	dst[1]= FxAngle(FxLength(ev[0],ev[2]),ev[1]);
	dst[2]= 0;
	RotGtoVHq(1,uv,uv,dst);

	dst[2]= FxAngle(uv[1],-uv[0]);

	return 0;
}



int YawLeft(int *dst,int *src,int d)
{
	int ev[3],uv[3];

	if(d==0)
	{
		dst[0]=src[0];
		dst[1]=src[1];
		dst[2]=src[2];
		return 0;
	}

	ev[0]=-512*FxSinHq(d);  /* Eye Line Vector */
	ev[1]= 0;
	ev[2]= 512*FxCosHq(d);
	RotVtoGHq(1,ev,ev,src);

	uv[0]=0;            /* Up Vector */
	uv[1]=0x2000000;
	uv[2]=0;
	RotVtoGHq(1,uv,uv,src);

	dst[0]= FxAngle(ev[2],-ev[0]);
	dst[1]= FxAngle(FxLength(ev[0],ev[2]),ev[1]);
	dst[2]= 0;
	RotGtoVHq(1,uv,uv,dst);

	dst[2]= FxAngle(uv[1],-uv[0]);

	return 0;
}
