#include "FASTMODE.h"

/*
    Sets the minimum MainRAM/VRAM access wait for FM-TOWNS generations of model 1/2, 1F/2F, 10F/20F, CX, and UX.

    Based on the Assembly Source code of AB.com
    AB.com was developed by Mr. EAST

    FM-TOWNS II CX can set FAST mode in TOWNS-OS.  Better to do from there.



    What about register 0x5EC mentioned in FM-TOWNS Superbook?
        I/O 05ECH bit0 is FAST mode == Main RAM 0 wait, VRAM 3 wait.
*/

void SetFastMode(void)
{
	int r30=0,r31=0;
	int is386DX=0,is386SX=0;
	r30=_inb(0x30);
	r31=_inb(0x31);
	if(r30&0xf8)
	{
		printf("Unknown machine.\n");
		return;
	}
	else if(1==(r30&7))
	{
		is386DX=1;
	}
	else if(3==(r30&7))
	{
		is386SX=1;
	}

	if(1==r31)
	{
		printf("Generation of FM-TOWNS model 1/2\n");
		_outb(0x5E0,4);
	}
	else if(2==r31)
	{
		printf("Generation of FM-TOWNS 1F/2F\n");
		_outb(0x5E2,1);
	}
	else if(4==r31)
	{
		printf("Generation of FM-TOWNS 10F/20F\n");
		_outb(0x5E2,1);
		_outb(0x5E6,3);
	}
	else if((5==r31 && 1==is386DX) ||
	        (3==r31 && 1==is386SX))
	{
		printf("Generation of FM-TOWNS II CX or UX\n");
		_outb(0x5E2,0);
		_outb(0x5E6,3);
	}
	else
	{
		printf("Unknown (most likely newer) generation of FM-TOWNS\n");
	}
}
