#include <math.h>

#include <snd.h>
#include <egb.h>

#include "../concorde.h"

#define EDGES 5
#define LCTRS 320
#define LSTEP 8

char EGB_work[EgbWorkSize];
int pnts[LCTRS/LSTEP][EDGES*2+1];

void roll(int *x,int *y,int ang)
{
	double xx,yy,aa;
	xx=(double)*x;
	yy=(double)*y;
	aa=(double)ang * 3.1415927 / 128;

	*x=(int)( xx*cos(aa) -yy*sin(aa));
	*y=(int)( xx*sin(aa) +yy*cos(aa));
}

void main()
{
	PAGE rp;
	int c,i,j,pad;
	int col[]={0x1f,0x03e0,0x03ff,0x7c00,0x7c1f,0x7fe0,0x7fff};
	int star[EDGES*2+1]={5,  0,5,  15,5,  3,15,  8,0,  12,15};
	int ar[512*16],ed[4];

	EGB_init(EGB_work,EgbWorkSize);
	EGB_resolution(EGB_work,0,10);
	EGB_resolution(EGB_work,1,10);
	EGB_writePage(EGB_work,1);
	EGB_displayStart(EGB_work,0,0,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,320,240);
	EGB_displayPage(EGB_work,1,2);

	YGH_initPage(&rp,SEG_VRAMP,0x40000  ,512,256);
	YGH_clearPage(&rp,15);

	for(i=0; i<=LCTRS/LSTEP; i++)
	{
		pnts[i][0]=star[0];
		for(j=0; j<star[0]; j++)
		{
			pnts[i][j*2+1]=star[j*2+1]*i*LSTEP/15;
			pnts[i][j*2+2]=star[j*2+2]*i*LSTEP/15;
			roll(&pnts[i][j*2+1],&pnts[i][j*2+2],i*LSTEP);
			pnts[i][j*2+1]+=160;
			pnts[i][j*2+2]+=120;
		}
	}

	pad=255;
	c=0;
	while(pad==255)
	{
		for(i=0; i<=LCTRS/LSTEP && pad==255; i++)
		{
			YGH_color(&rp,col[c]);
			if(YGH_polygonArea(&rp,ar,ed,pnts[i])==0)YGH_areaPaint(&rp,ar,ed);
			YGH_color(&rp,32767);
			YGH_emptyPolygon(&rp,pnts[i]);
			SND_joy_in_2(0,&pad);
		}
		c=(c+1)%7;
	}
}
