#include <math.h>

#include <snd.h>
#include <egb.h>
#include <msdos.cf>

#include "../concorde.h"

char EGB_work[EgbWorkSize];

void roll(int *x,int *y,int ang)
{
	double xx,yy,aa;
	xx=(double)*x;
	yy=(double)*y;
	aa=(double)ang * 3.1415927 / 128;

	*x=(int)( xx*cos(aa) -yy*sin(aa));
	*y=(int)( xx*sin(aa) +yy*cos(aa));
}

void main()
{
	PAGE p;
	int c,i,j,x,y,pad;
	int grb[]={0,0,31, 0,31,0, 0,31,31, 31,0,0, 31,0,31, 31,31,0, 31,31,31};
	int ar[512*16],ed[4];

	EGB_init(EGB_work,EgbWorkSize);
	EGB_resolution(EGB_work,0,17);

	EGB_writePage(EGB_work,0);
	EGB_displayStart(EGB_work,0,64,0);
	EGB_displayStart(EGB_work,2,1,1);
	EGB_displayStart(EGB_work,3,512,480);
	EGB_displayPage(EGB_work,0,1);

	YGH_initPage(&p,SEG_VRAMS,0,512,480);
	YGH_clearPage(&p,15);

	pad=255;
	j=0;
	while(pad==255)
	{
		for(i=0; i<=512 && pad==255; i+=8)
		{
			c=i+512;
			c=grb[j*3]*c/1024*1024 +grb[j*3+1]*c/1024*32 +grb[j*3+2]*c/1024;
			x=i;
			y=0;
			roll(&x,&y,i);
			YGH_color(&p,c);
			x+=256;
			y+=240;
			if(YGH_circleArea(&p,ar,ed,x,y,i*3/4)==0)YGH_areaPaint(&p,ar,ed);
			SND_joy_in_2(0,&pad);
		}
		j=(j+1)%7;
	}
}
