#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include <msdos.cf>

#include <snd.h>
#include <egb.h>

#include "../../concorde/concorde.h"
#include "../../tomahawk/tomahawk.h"
#include "../airforce.h"


#define XBUF 16
#define LNG 480
#define SRAND 79154726  /* wДԍ(^_^;) */
#define TIMES 100
#define EDGES 5


char EGB_work[EgbWorkSize];
short virt[320*256];

int vx1=10;
int vy1=10;
int vx2=309;
int vy2=229;

short para[64];

void frame()
{
	EGB_clearScreen(EGB_work);
	EGB_paintMode(EGB_work,0x22);

	EGB_color(EGB_work,0,32767);
	EGB_color(EGB_work,2,32767);
	para[0]=0;
	para[1]=0;
	para[2]=319;
	para[3]=239;
	EGB_viewport(EGB_work,(char *)para);
	EGB_rectangle(EGB_work,(char *)para);

	EGB_color(EGB_work,0,0);
	EGB_color(EGB_work,2,0);
	para[0]=vx1;
	para[1]=vy1;
	para[2]=vx2;
	para[3]=vy2;
	EGB_rectangle(EGB_work,(char *)para);
	EGB_viewport(EGB_work,(char *)para);
}

int *LoadSld(const char fn[])
{
	FILE *fp=NULL;
	int *dat=NULL;

	fp=fopen(fn,"rb");
	if(NULL!=fp)
	{
		unsigned int sz=0;
		fseek(fp,0,SEEK_END);
		sz=ftell(fp);
		fseek(fp,0,SEEK_SET);
		dat=(int *)malloc(sz);
		fread(dat,1,sz,fp);
		fclose(fp);
	}
	return dat;
}

int main()
{
	PAGE rp,vp;
	int *mdl=NULL;

	EGB_init(EGB_work,EgbWorkSize);
	EGB_resolution(EGB_work,0,10);
	EGB_resolution(EGB_work,1,10);

	EGB_writePage(EGB_work,0);
	EGB_displayStart(EGB_work,0,0,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,320,240);
	EGB_clearScreen(EGB_work);

	EGB_writePage(EGB_work,1);
	EGB_displayStart(EGB_work,0,0,0);
	EGB_displayStart(EGB_work,2,2,2);
	EGB_displayStart(EGB_work,3,320,240);
	EGB_clearScreen(EGB_work);

	EGB_displayPage(EGB_work,1,2);

	{
		const int NX=320,NY=256,NOBJ=64;

		YGH_initPage(&rp,SEG_VRAMP,0x40000  ,512,256);
		YGH_initPage(&vp,SEG_VIRTU,ADR(virt),NX,NY);
		YGH_clearPage(&vp,15);
		YGH_viewPort(&vp,vx1,vy1,vx2,vy2);

		AL_Init_All(NY,NOBJ);
	}

	mdl=LoadSld("A4MS.SLD");


	srand(SRAND);

	frame();

	{
		int i;
		for(i=0; i<100; ++i)
		{
			int camera[6]={0,0,0,0,0,0};
			int mdlpos[6]={0,0,5000,32768,0,0};
			PRJSCRN prj;

			mdlpos[3]=i*256;

			prj.prj.cx=160;
			prj.prj.cy=120;
			prj.prj.mag=100;
			prj.cpz=10;
			prj.lx=160;
			prj.ly=120;

			YGH_clearPage(&vp,31);
			AL_Set_Eye(camera,&prj);
			AL_Insert_Model(mdl,mdlpos);
			AL_Flush_Buffer(&vp);
			YGH_pageCopy(&rp,&vp);
		}

		for(i=0; i<100; ++i)
		{
			YGH_clearPage(&vp,i*1024+i*32+i);
			YGH_pageCopy(&rp,&vp);
		}

		YGH_clearPage(&vp,0);
		YGH_pageCopy(&rp,&vp);
	}


	printf("End\n");

	return 0;
}
