#pragma On(Align_all_labels)
#pragma On(Align_labels)

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <concorde.h>
#include <tomahawk.h>
#include <airforce.h>

extern int *AL_area,AL_ed[4];

void AL_Draw_RotPoints(int *,int *,int *,int,int,int);

int AL_Draw(PAGE *dp,LAXIS *lax,int *posi,PRJSCRN *pr)
{
	int i,*ptr,cpz;
	int ofsx,ofsy,ofsz;
	int wdr[2],sit[6],pnt[12];
	int p1[1+MAX_POINTS*3],p2[1+MAX_POINTS*3];

	ptr=(*lax).drw;

	wdr[0]=FxSinHq((*lax).wdir);
	wdr[1]=FxCosHq((*lax).wdir);

	sit[0]=FxSinHq(posi[3]);
	sit[1]=FxCosHq(posi[3]);
	sit[2]=FxSinHq(posi[4]);
	sit[3]=FxCosHq(posi[4]);
	sit[4]=FxSinHq(posi[5]);
	sit[5]=FxCosHq(posi[5]);

	switch((*lax).unit)
	{
	default:
		return 1;
	case UNI_METER:
		ofsx=(*lax).wcx-posi[0]/100;
		ofsy=          -posi[1]/100;
		ofsz=(*lax).wcz-posi[2]/100;
		cpz=(*pr).cpz/100;
		break;
	case UNI_CENTI:
		ofsx=(*lax).wcx-posi[0];
		ofsy=          -posi[1];
		ofsz=(*lax).wcz-posi[2];
		cpz=(*pr).cpz;
		break;
	}

	if(_abs(ofsx)>=MAX_SIGHT || _abs(ofsz)>=MAX_SIGHT)return 0;

	pnt[ 0]=(*lax).xs; pnt[ 2]=(*lax).zs;
	pnt[ 3]=(*lax).xs; pnt[ 5]=(*lax).zl;
	pnt[ 6]=(*lax).xl; pnt[ 8]=(*lax).zs;
	pnt[ 9]=(*lax).xl; pnt[11]=(*lax).zl;
	RotFast(&pnt[ 0],&pnt[ 2],wdr);
	RotFast(&pnt[ 3],&pnt[ 5],wdr);
	RotFast(&pnt[ 6],&pnt[ 8],wdr);
	RotFast(&pnt[ 9],&pnt[11],wdr);
	pnt[ 0]+= ofsx; pnt[ 1] = ofsy; pnt[ 2]+= ofsz;
	pnt[ 3]+= ofsx; pnt[ 4] = ofsy; pnt[ 5]+= ofsz;
	pnt[ 6]+= ofsx; pnt[ 7] = ofsy; pnt[ 8]+= ofsz;
	pnt[ 9]+= ofsx; pnt[10] = ofsy; pnt[11]+= ofsz;
	RotGtoVFast(4,pnt,pnt,sit);

	if(pnt[2]<cpz && pnt[5]<cpz && pnt[8]<cpz && pnt[11]<cpz)return 0;

	while(*ptr!=DRW_EOF)
	{
		YGH_color(dp,ptr[1]);

		AL_Draw_RotPoints(p1,ptr+2,wdr,ofsx,ofsy,ofsz);
//		/* ASM*/
//		p1[0]=ptr[2];
//		for(i=0; i<ptr[2]; i++)
//		{
//			p1[1+i*3]=ptr[3+i*2];
//			p1[3+i*3]=ptr[4+i*2];
//			RotFast(&p1[1+i*3],&p1[3+i*3],wdr);
//			p1[1+i*3]+= ofsx;
//			p1[2+i*3]=  ofsy;
//			p1[3+i*3]+= ofsz;
//		}
		RotGtoVFast(p1[0],p1+1,p1+1,sit);

		switch(*ptr)
		{
		case DRW_PSET:
			p2[0]=0;
			for(i=0; i<p1[0]; i++)
			{
				if(p1[i*3+3]<=cpz)continue;
				Projection(1,p2+1+p2[0]*2,p1+1+i*3,&(*pr).prj);
				p2[0]++;
			}
			YGH_psets(dp,p2);
			break;
		case DRW_UNCONNECT:
			p1[0] &= ~1;
			for(i=0; i<p1[0]; i+=2)
			{
				if(ClipLine3D(p2,&p1[i*3+1],cpz))continue;
				Projection(2,p2,p2,&(*pr).prj);
				YGH_line(dp,p2[0],p2[1],p2[2],p2[3]);
			}
			break;
		case DRW_CONNECT:
			for(i=0; i<p1[0]-1; i++)
			{
				if(ClipLine3D(p2,&p1[i*3+1],cpz))continue;
				Projection(2,p2,p2,&(*pr).prj);
				YGH_line(dp,p2[0],p2[1],p2[2],p2[3]);
			}
			break;
		case DRW_POLYGON:
			if(ClipPolyg3D(p2,p1,cpz))
			{
				Projection(p2[0],p2+1,p2+1,&(*pr).prj);
				if(YGH_polygonArea(dp,AL_area,AL_ed,p2)==0)
							YGH_areaPaint(dp,AL_area,AL_ed);
			}
			break;
		case DRW_RECTANGLE:
			if(ClipPolyg3D(p2,p1,cpz))
			{
				Projection(p2[0],p2+1,p2+1,&(*pr).prj);
				if(YGH_triangleArea(dp,AL_area,AL_ed,p2)==0)
							YGH_areaPaint(dp,AL_area,AL_ed);
			}
			break;
		}
		ptr+=(3+ptr[2]*2);
	}
	return 0;
}
