#ifndef AIRFORCE_H_IS_INCUDED
#define AIRFORCE_H_IS_INCUDED

#define MAX_POINTS    64
#define MAX_SIGHT     4000000  /* cm:40km m:4000km */

#define DRW_EOF        0
#define DRW_PSET       1
#define DRW_UNCONNECT  2
#define DRW_CONNECT    3
#define DRW_POLYGON    4
#define DRW_RECTANGLE  5

#define HEAD_STR      12
#define STR_EOF        0
#define STR_MOUNTAIN   1
#define STR_BUILDING   2
#define STR_POLYGON    3
#define STR_BRIDGE     4
#define STR_RUNWAY     5
#define STR_HAZARD     6
#define STR_SURF       7
#define STR_LINE       8
#define STR_GRID       9
#define STR_CIRCLE    10
#define STR_BITMAP    11

#define UNI_METER      0
#define UNI_CENTI      1


#ifndef CONCORDE
#define CONCORDE
typedef struct
{
	int pen,col;          /* pen:Fʔԍ  col:ۂɏ܂F */
	int wdx,wdy;          /* y[W̑傫                           */
	int vx1,vy1,vx2,vy2;  /* ݘg                               */
	int seg,adr;          /* sNZi[ZOg,AhX          */
	unsigned short *plt;  /* zpbgւ̃|C^                 */

	int odw,oup;          /* AhXItZbg ړ,ړ         */
} PAGE;
#endif

#ifndef TOMAHAWK
#define TOMAHAWK
typedef struct {
	int cx,cy,mag;
} PROJ;
#endif


typedef struct {
	int wcx,wcz,wdir;
	int xs,zs,xl,zl,hight;
	int unit;
	int *drw,*str;
} LAXIS;

typedef struct {
	PROJ prj;
	int cpz;
	int lx,ly;
} PRJSCRN;


/* str3d.c */
int AL_Get_Init_Size(int *arsiz,int *bfsiz,int ylin,int omax);
int AL_Init_All_Ref(int omax,char *ar,char *bf);

int AL_Init_All(int ylin,int omax);

int AL_Set_Eye(int *pos,PRJSCRN *prj);
void AL_Insert_Lax(LAXIS *lax);
void AL_Insert_Model(int *sld,int *pos);
void AL_Insert_Grid(int col,int *pos);
void AL_Insert_Line(int col,int *pos);
void AL_Insert_Circle(int col,int *pos,int r);
void AL_Insert_Bitmap(char *bm,int bx,int by,int xsiz,int ysiz,int *pos);
int AL_Flush_Buffer(PAGE *p);
int AL_Sizeof_Str(int *str);

/* draw3d.c */
int AL_Draw(PAGE *p,LAXIS *lax,int *posi,PRJSCRN *pr);

/* Crash.c */
int *AL_Crash(LAXIS *lax,int *pos);

/* Solid.c */
int AL_Model(PAGE *d,int *sld,int *sldp,int *eye,PRJSCRN *pr);

/* Horizon.c */
int AL_Horizon(PAGE *p,int *sit,int *rect,int *col,PRJSCRN *pr);

#endif