							EXPORT	MAIN_TO_SUB_MAINADDR
							EXPORT	MAIN_TO_SUB_SUBADDR
							EXPORT	MAIN_TO_SUB_LENGTH
							EXPORT	MAIN_TO_SUB

							EXPORT	INSTALL_CLEAR_BITPLANE_IN_SUBCPU
							EXPORT	CLEAR_BITPLANE_VRAMADDR
							EXPORT	CLEAR_BITPLANE

							EXPORT	SUBCPU_WAIT_READY

MAIN_TO_SUB_MAINADDR		RZB		2
MAIN_TO_SUB_SUBADDR			RZB		2
MAIN_TO_SUB_LENGTH			RZB		2

MAIN_TO_SUB					PSHS	A,B,X,Y,U

							LDX		MAIN_TO_SUB_MAINADDR,PCR
							LDU		MAIN_TO_SUB_SUBADDR,PCR
							LDY		MAIN_TO_SUB_LENGTH,PCR
							BEQ		MAIN_TO_SUB_END

							STX		MAIN_TO_SUB_CURMAINADDR,PCR
							STU		MAIN_TO_SUB_CURSUBADDR,PCR
							STY		MAIN_TO_SUB_REMAINSIZE,PCR


MAIN_TO_SUB_TFRLOOP			LDD		MAIN_TO_SUB_REMAINSIZE,PCR
							CMPD	#$60
							BLE		MAIN_TO_SUB_TFRLOOP_SETSIZE
							LDD		#$60
MAIN_TO_SUB_TFRLOOP_SETSIZE	STD		MAIN_TO_SUB_CURTFRSIZE,PCR
							STD		SUBCPU_TFRCMD_TFRSIZE,PCR

							LDD		#$D3A0	; Corresponds to $FCA0 in Main-CPU
							STD		SUBCPU_TFRCMD_SUBFROMADDR,PCR

							LDD		MAIN_TO_SUB_CURSUBADDR,PCR
							STD		SUBCPU_TFRCMD_SUBTOADDR,PCR

							LBSR	HALT_SUBCPU


							LEAX	SUBCPU_TFRCMD,PCR
							LDU		#$FC82
							LDB		#9
MAIN_TO_SUB_TFRLOOP_COPYCMD
							LDY		,X++
							STY		,U++
							DECB
							BNE		MAIN_TO_SUB_TFRLOOP_COPYCMD


							LDD		MAIN_TO_SUB_CURTFRSIZE,PCR
							LDX		MAIN_TO_SUB_CURMAINADDR,PCR
							LDU		#$FCA0 	; Corresponds to #$D3A0 in Sub-CPU

							LSRB
							BCC		MAIN_TO_SUB_TFRLOOP_COPY_TO_SHARED
							LDA		,X+
							STA		,U+

MAIN_TO_SUB_TFRLOOP_COPY_TO_SHARED
							LDY		,X++
							STY		,U++
							DECB
							BNE		MAIN_TO_SUB_TFRLOOP_COPY_TO_SHARED
							STX		MAIN_TO_SUB_CURMAINADDR,PCR

							LBSR	RELEASE_SUBCPU

							LDD		MAIN_TO_SUB_CURSUBADDR,PCR
							ADDD	MAIN_TO_SUB_CURTFRSIZE,PCR
							STD		MAIN_TO_SUB_CURSUBADDR,PCR

							LDD		MAIN_TO_SUB_REMAINSIZE,PCR
							SUBD	MAIN_TO_SUB_CURTFRSIZE,PCR
							STD		MAIN_TO_SUB_REMAINSIZE,PCR
							BHI		MAIN_TO_SUB_TFRLOOP

MAIN_TO_SUB_END
							PULS	A,B,X,Y,U
							RTS

MAIN_TO_SUB_CURTFRSIZE		RZB		2
MAIN_TO_SUB_CURMAINADDR		RZB		2
MAIN_TO_SUB_CURSUBADDR		RZB		2
MAIN_TO_SUB_REMAINSIZE		RZB		2


CALL_SUB_CPU_ADDR			RZB		2
CALL_SUB_CPU_PARAM			RZB		2		; Will be copied to $FCFE -> SubCPU $D3FE
CALL_SUB_CPU_PARAMPTR_MAIN	EQU		$FCFE
CALL_SUB_CPU_PARAMPTR_SUB	EQU		$D3FE
CALL_SUB_CPU				PSHS	A,B,X,Y,U

							LDX		CALL_SUB_CPU_ADDR,PCR
							STX		SUBCPU_CALLCMD_JSRADDR,PCR

							BSR		HALT_SUBCPU

							LEAX	SUBCPU_CALLCMD,PCR
							LDU		#$FC82
							LDB		#7
CALL_SUB_CPU_COPYCMD
							LDY		,X++
							STY		,U++
							DECB
							BNE		CALL_SUB_CPU_COPYCMD

							LDY		CALL_SUB_CPU_PARAM,PCR
							STY		CALL_SUB_CPU_PARAMPTR_MAIN

							BSR		RELEASE_SUBCPU

							PULS	A,B,X,Y,U
							RTS


CLS_AND_CALL_SUB_CPU		PSHS	A,B,X,Y,U

							LDX		CALL_SUB_CPU_ADDR,PCR
							STX		SUBCPU_CLS_AND_CALL_JSRADDR,PCR

							BSR		HALT_SUBCPU

							LEAX	SUBCPU_CLS_AND_CALLCMD,PCR
							LDU		#$FC82
							LDB		#8
CLS_AND_CALL_SUB_CPU_COPYCMD
							LDY		,X++
							STY		,U++
							DECB
							BNE		CLS_AND_CALL_SUB_CPU_COPYCMD

							LDY		CLEAR_BITPLANE_VRAMADDR,PCR
							STY		CALL_SUB_CPU_PARAMPTR_MAIN

							BSR		RELEASE_SUBCPU

							PULS	A,B,X,Y,U
							RTS



HALT_SUBCPU					LDA		$FD05
							BMI		HALT_SUBCPU

							LDA		#$80
							STA		$FD05

HALT_SUBCPU_WAIT			LDA		$FD05
							BPL		HALT_SUBCPU_WAIT
							RTS



RELEASE_SUBCPU				PSHS	A
							LDA		#0
							STA		$FD05
							PULS	A,PC


SUBCPU_WAIT_READY			PSHS	A
SUBCPU_WAIT_READY_LOOP		LDA		$FD05
							BMI		SUBCPU_WAIT_READY_LOOP
							PULS	A,PC


; 19 byes in total (including FC80, FC81)
; Available Main $FCA0-$FCFF
;           Sub  $D3A0-$D3FF
;			$60 bytes at a time.
SUBCPU_TFRCMD				FCB		$3F  		; 1 <- Should go to FC82
							FCB		"YAMAUCHI"	; 1+8=9
							FCB		$91			; 9+1=10
SUBCPU_TFRCMD_SUBFROMADDR	RZB		2			; 10+2=12
SUBCPU_TFRCMD_SUBTOADDR		RZB		2			; 12+2=14
SUBCPU_TFRCMD_TFRSIZE		RZB		2			; 14+2=16
							FCB		$90			; 16+1=17
							RZB		1			; 17+1=18  Just in case.  Make it even.


SUBCPU_CALLCMD				FCB		$3F			; 1 <- Sh
							FCB		"YAMAUCHI"  ; 1+8=9
							FCB		$93         ; 9+1=10
SUBCPU_CALLCMD_JSRADDR		RZB		2           ; 10+2=12
							FCB		$90			; 12+1=13
							RZB		1			; 13+1=14  Just in case.  Make it even.


SUBCPU_CLS_AND_CALLCMD		FCB		$3F			; 1 <- Sh
							FCB		"YAMAUCHI"  ; 1+8=9
							FCB		$93         ; 9+1=10
							FDB		CLEAR_BITPLANE_INSTALL_SUBCPU_ADDR	; 10+2=12
							FCB		$93         ; 12+1=13
SUBCPU_CLS_AND_CALL_JSRADDR	RZB		2           ; 13+2=15
							FCB		$90			; 15+1=16


CLEAR_BITPLANE_INSTALL_SUBCPU_ADDR	EQU		$C400

INSTALL_CLEAR_BITPLANE_IN_SUBCPU
							PSHS	A,B,X

							LEAX		CLEAR_BITPLANE_IN_SUBCPU,PCR
							STX			MAIN_TO_SUB_MAINADDR,PCR

							LDX			#CLEAR_BITPLANE_INSTALL_SUBCPU_ADDR
							STX			MAIN_TO_SUB_SUBADDR,PCR

							LDX			#(CLEAR_BITPLANE_IN_SUBCPU_LASTADDR-CLEAR_BITPLANE_IN_SUBCPU)
							STX			MAIN_TO_SUB_LENGTH,PCR

							LBSR		MAIN_TO_SUB

							PULS	A,B,X,PC
							; Save one RTS by pulling PC



CLEAR_SCREEN				PSHS	X
							LDX		#0
							STX		CLEAR_BITPLANE_VRAMADDR,PCR
							BSR		CLEAR_BITPLANE
							LDX		#$4000
							STX		CLEAR_BITPLANE_VRAMADDR,PCR
							BSR		CLEAR_BITPLANE
							LDX		#$8000
							STX		CLEAR_BITPLANE_VRAMADDR,PCR
							BSR	CLEAR_BITPLANE
							PULS	X,PC


CLEAR_BITPLANE_VRAMADDR		RZB		2
CLEAR_BITPLANE				PSHS	A,B,X

							LDX		CLEAR_BITPLANE_VRAMADDR,PCR
							STX		CALL_SUB_CPU_PARAM,PCR
							LDX		#CLEAR_BITPLANE_INSTALL_SUBCPU_ADDR
							STX		CALL_SUB_CPU_ADDR,PCR

							LBSR		CALL_SUB_CPU

							PULS	A,B,X,PC
							; RTS


							; This function will be installed in the console RAM part of Sub-CPU
CLEAR_BITPLANE_IN_SUBCPU	PSHS	A,B,X,Y,U

							BITA	$D409	; Sub-CPU VRAM Access Flag On

							LDU		CALL_SUB_CPU_PARAMPTR_SUB
							LEAU	16000,U


							LDB		#200
							CLRA
							LDX		#0
							LDY		#0
CLEAR_BITPLANE_IN_SUBCPU_INSIDELOOP
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							PSHU	A,X,Y
							DECB
							BNE		CLEAR_BITPLANE_IN_SUBCPU_INSIDELOOP

							STA		$D409	; Sub-CPU VRAM Access Flag Clear

							PULS	A,B,X,Y,U,PC
							; PUL PC instead of RTS.  Save one byte.

CLEAR_BITPLANE_IN_SUBCPU_LASTADDR





VERTICAL_CLEAR_SUBCPU_INSTALL_ADDR	EQU		$C4C0

INSTALL_VERTICAL_CLEAR_IN_SUBCPU
							PSHS	A,B,X

							LEAX		VERTICAL_CLEAR_IN_SUBCPU,PCR
							STX			MAIN_TO_SUB_MAINADDR,PCR

							LDX			#VERTICAL_CLEAR_SUBCPU_INSTALL_ADDR
							STX			MAIN_TO_SUB_SUBADDR,PCR

							LDX			#(VERTICAL_CLEAR_IN_SUBCPU_LASTADDR-VERTICAL_CLEAR_IN_SUBCPU)
							STX			MAIN_TO_SUB_LENGTH,PCR

							LBSR		MAIN_TO_SUB

							PULS	A,B,X,PC



							; X VRAM ADDR (0 to 79)
CALL_VERTICAL_CLEAR_SUBCPU
							LBSR	HALT_SUBCPU

							STX		$FCFE
							LEAX	SUBCPU_VERTICAL_CLEAR_CALLCMD,PCR
							LDU		#$FC82
							LDA		#16
CALL_VERTICAL_CLEAR_SUBCPU_COPY_LOOP
							LDB		,X+
							STB		,U+
							DECA
							BNE		CALL_VERTICAL_CLEAR_SUBCPU_COPY_LOOP

							LBSR	RELEASE_SUBCPU
							RTS

SUBCPU_VERTICAL_CLEAR_CALLCMD		FCB		$3F			; 1 <- Sh
							FCB		"YAMAUCHI"  ; 1+8=9
							FCB		$93         ; 9+1=10
							FDB		VERTICAL_CLEAR_SUBCPU_INSTALL_ADDR	; 10+2=12
							FCB		$90			; 15+1=16



VERTICAL_CLEAR_IN_SUBCPU
							LDU		$D3FE		; $FCFE in Main CPU
							LDA		#204
							BITA	$D409	; Sub-CPU VRAM Access Flag On
VERTICAL_CLEAR_IN_SUBCPU_LOOP
							CLR		,U
							CLR		$4000,U
							CLR		$8000,U
							LEAU	80,U
							DECA
							BNE		VERTICAL_CLEAR_IN_SUBCPU_LOOP
							STA		$D409	; Sub-CPU VRAM Access Flag Clear
							RTS

VERTICAL_CLEAR_IN_SUBCPU_LASTADDR


							; Set VRAM Offset Register to X
SUBCPU_SET_VRAM_OFFSET		PSHS	A,B,X,Y,U

							PSHS	X
							LBSR		HALT_SUBCPU

							LEAX	SUBCPU_VRAMOFFSET_CMD,PCR
							LDU		#$FC82
SET_VRAM_OFFSET_TFR			LDD		,X++
							STD		,U++
							CMPU	#$FC94
							BLE		SET_VRAM_OFFSET_TFR

							PULS	X
							STX		$FCFE

							LBSR		RELEASE_SUBCPU
							PULS	A,B,X,Y,U,PC

SUBCPU_VRAMOFFSET_CMD		FCB		$3F			; $FC82
							FCB		"YAMAUCHI"  ; $FC83
							FCB		$91         ; $FC8B
							FDB		$D3FE		; $FC8C
							FDB		$D40E		; $FC8E
							FDB		2			; $FC90
							FCB		$90,0		; $FC92
												; $FC94



							; X 	Command addr
							; B		Command length
SUBCPU_EXEC_COMMAND			PSHS	A,B,X,U
							LBSR	HALT_SUBCPU

							LDU		#$FC80
SUBCPU_EXEC_COMMAND_LOOP	LDA		,X+
							STA		,U+
							DECB
							BNE		SUBCPU_EXEC_COMMAND_LOOP

							LBSR	RELEASE_SUBCPU

							PULS	A,B,X,U,PC



RESET_PALETTE				PSHS	A,U
							CLRA
							LDU		#$FD38
RESET_PALETTE_LOOP			STA		,U+
							INCA
							CMPA	#8
							BNE		RESET_PALETTE_LOOP
							PULS	A,U,PC



HIDE_BY_PALETTE				PSHS	U
							LDU		#$FD38
							CLR		,U+
							CLR		,U+
							CLR		,U+
							CLR		,U+
							CLR		,U+
							CLR		,U+
							CLR		,U+
							CLR		,U+
							PULS	U,PC
