				EXPORT	SCLIP_LX0
				EXPORT	SCLIP_LY0
				EXPORT	SCLIP_LX1
				EXPORT	SCLIP_LY1
				EXPORT	SCLIP_WX0
				EXPORT	SCLIP_WY0
				EXPORT	SCLIP_WX1
				EXPORT	SCLIP_WY1
				EXPORT	SCLIP_VISIBLE

				EXPORT	SCRNCLIP


SCLIP_LX0		RZB			2
SCLIP_LY0		RZB			2
SCLIP_LX1		RZB			2
SCLIP_LY1		RZB			2
SCLIP_WX0		RZB			2		; Input Window Xmin
SCLIP_WY0		RZB			2		; Input Window Ymin
SCLIP_WX1		RZB			2		; Input Window Xmax
SCLIP_WY1		RZB			2		; Input Window Ymax
SCLIP_VISIBLE	RZB			1		; Output 1:Visible  0:Invisible

SCRNCLIP		PSHS		A,B,X

				CLR 		SCLIP_SWAPPED,PCR
				LDA			#1
				STA			SCLIP_VISIBLE,PCR

				LDD			SCLIP_LX1,PCR
				SUBD		SCLIP_LX0,PCR
				STD			SCLIP_DX,PCR
				BPL			SCLIP_SETDX
				COMA
				COMB
				ADDD		#1
SCLIP_SETDX		STD			SCLIP_ABSDX,PCR

				LDD			SCLIP_LY1,PCR
				SUBD		SCLIP_LY0,PCR
				STD			SCLIP_DY,PCR
				BPL			SCLIP_SETDY
				COMA
				COMB
				ADDD		#1
SCLIP_SETDY		STD			SCLIP_ABSDY,PCR

				CMPD		SCLIP_ABSDX,PCR
				BHI			SCLIP_ABSDYGREATER
				LBSR		SCLIP_IN_X
				LBSR		SCLIP_IN_Y
				BRA			SCLIP_CLIPPED
SCLIP_ABSDYGREATER
				LBSR		SCLIP_IN_Y
				LBSR		SCLIP_IN_X
SCLIP_CLIPPED
				LDA			SCLIP_SWAPPED,PCR
				ASRA
				BCC			SCLIP_END
				BSR			SCLIP_SWAP0_1
SCLIP_END		LBSR		SCLIP_CHECKVISIBLE
				PULS		A,B,X
				RTS

				; Swap P0 and P1
SCLIP_SWAP0_1	LDD			SCLIP_LX1,PCR
				LDX			SCLIP_LX0,PCR
				STD			SCLIP_LX0,PCR
				STX			SCLIP_LX1,PCR
				LDD			SCLIP_LY1,PCR
				LDX			SCLIP_LY0,PCR
				STD			SCLIP_LY0,PCR
				STX			SCLIP_LY1,PCR
				INC			SCLIP_SWAPPED,PCR
				RTS

SCLIP_CALC_Y_FOR_X	; Input D=x  Output D=y(x)
					; y'=LY0+(x'-LX0)*DY/DX
				SUBD		SCLIP_LX0,PCR
				STD			MUL16_NUM0,PCR
				LDD			SCLIP_DY,PCR
				STD			MUL16_NUM1,PCR
				LBSR		MUL16

				LDD			MUL16_NUM0,PCR
				LDX			MUL16_NUM1,PCR
				STD			DIV32_16_NUMER,PCR
				STX			DIV32_16_NUMER+2,PCR
				LDD			SCLIP_DX,PCR
				STD			DIV32_16_DENOM,PCR
				LBSR		DIV32_16
				LDD			DIV32_16_DENOM,PCR

				ADDD		SCLIP_LY0,PCR
				RTS

SCLIP_CALC_X_FOR_Y	; Input D=y  Output D=x(y)
					; x'=LX0+(y'-LY0)*DX/DY
				SUBD		SCLIP_LY0,PCR
				STD			MUL16_NUM0,PCR
				LDD			SCLIP_DX,PCR
				STD			MUL16_NUM1,PCR
				LBSR		MUL16

				LDD			MUL16_NUM0,PCR
				LDX			MUL16_NUM1,PCR
				STD			DIV32_16_NUMER,PCR
				STX			DIV32_16_NUMER+2,PCR
				LDD			SCLIP_DY,PCR
				STD			DIV32_16_DENOM,PCR
				LBSR		DIV32_16
				LDD			DIV32_16_DENOM,PCR

				ADDD		SCLIP_LX0,PCR
				RTS


				; Clipping by Xmin, Xmax
SCLIP_IN_X		
				LDD			SCLIP_LX1,PCR
				CMPD		SCLIP_LX0,PCR
				BGE			SCLIP_IN_X_X0_X1_ORDERED
				LBSR		SCLIP_SWAP0_1
SCLIP_IN_X_X0_X1_ORDERED
				; LX0<=LX1

				LDD			SCLIP_LX0,PCR
				CMPD		SCLIP_WX1,PCR
				BLE			SCLIP_IN_X_X0CHECKED
				CLR			SCLIP_VISIBLE,PCR
				RTS
SCLIP_IN_X_X0CHECKED

				LDD			SCLIP_LX1,PCR
				CMPD		SCLIP_WX0,PCR
				BGE			SCLIP_IN_X_X1CHECKED
				CLR			SCLIP_VISIBLE,PCR
				RTS
SCLIP_IN_X_X1CHECKED

				LDD			SCLIP_LX0,PCR
				CMPD		SCLIP_WX0,PCR
				BGE			SCLIP_IN_X_X0CLIPPED

				LDD			SCLIP_WX0,PCR
				LBSR		SCLIP_CALC_Y_FOR_X
				STD			SCLIP_LY0,PCR
				LDD			SCLIP_WX0,PCR
				STD			SCLIP_LX0,PCR
SCLIP_IN_X_X0CLIPPED

				LDD			SCLIP_LX1,PCR
				CMPD		SCLIP_WX1,PCR
				BLE			SCLIP_IN_X_X1CLIPPED

				LDD			SCLIP_WX1,PCR
				LBSR		SCLIP_CALC_Y_FOR_X
				STD			SCLIP_LY1,PCR
				LDD			SCLIP_WX1,PCR
				STD			SCLIP_LX1,PCR
SCLIP_IN_X_X1CLIPPED

				RTS


				; Clipping Ymin and Ymax
SCLIP_IN_Y
				LDD			SCLIP_LY1,PCR
				CMPD		SCLIP_LY0,PCR
				BGE			SCLIP_IN_Y_Y0_Y1_ORDERED
				LBSR		SCLIP_SWAP0_1
SCLIP_IN_Y_Y0_Y1_ORDERED
				; LY0<=LY1

				LDD			SCLIP_LY0,PCR
				CMPD		SCLIP_WY1,PCR
				BLE			SCLIP_IN_Y_Y0CHECKED
				CLR			SCLIP_VISIBLE,PCR
				RTS
SCLIP_IN_Y_Y0CHECKED

				LDD			SCLIP_LY1,PCR
				CMPD		SCLIP_WY0,PCR
				BGE			SCLIP_IN_Y_Y1CHECKED
				CLR			SCLIP_VISIBLE,PCR
				RTS
SCLIP_IN_Y_Y1CHECKED

				LDD			SCLIP_LY0,PCR
				CMPD		SCLIP_WY0,PCR
				BGE			SCLIP_IN_Y_Y0CLIPPED

				LDD			SCLIP_WY0,PCR
				LBSR		SCLIP_CALC_X_FOR_Y
				STD			SCLIP_LX0,PCR
				LDD			SCLIP_WY0,PCR
				STD			SCLIP_LY0,PCR
SCLIP_IN_Y_Y0CLIPPED

				LDD			SCLIP_LY1,PCR
				CMPD		SCLIP_WY1,PCR
				BLE			SCLIP_IN_Y_Y1CLIPPED

				LDD			SCLIP_WY1,PCR
				LBSR		SCLIP_CALC_X_FOR_Y
				STD			SCLIP_LX1,PCR
				LDD			SCLIP_WY1,PCR
				STD			SCLIP_LY1,PCR
SCLIP_IN_Y_Y1CLIPPED

				RTS

				; There are situations like a point starts from the left of the window
				; and extends above the window.
SCLIP_CHECKVISIBLE
				LDX			SCLIP_LX0,PCR
				CMPX		SCLIP_WX0,PCR
				BLT			SCLIP_CHECKVISIBLE_NO
				CMPX		SCLIP_WX1,PCR
				BGT			SCLIP_CHECKVISIBLE_NO

				LDX			SCLIP_LY0,PCR
				CMPX		SCLIP_WY0,PCR
				BLT			SCLIP_CHECKVISIBLE_NO
				CMPX		SCLIP_WY1,PCR
				BGT			SCLIP_CHECKVISIBLE_NO

				LDX			SCLIP_LX1,PCR
				CMPX		SCLIP_WX0,PCR
				BLT			SCLIP_CHECKVISIBLE_NO
				CMPX		SCLIP_WX1,PCR
				BGT			SCLIP_CHECKVISIBLE_NO

				LDX			SCLIP_LY1,PCR
				CMPX		SCLIP_WY0,PCR
				BLT			SCLIP_CHECKVISIBLE_NO
				CMPX		SCLIP_WY1,PCR
				BGT			SCLIP_CHECKVISIBLE_NO

				RTS
SCLIP_CHECKVISIBLE_NO
				CLR			SCLIP_VISIBLE,PCR
				RTS

SCLIP_SWAPPED	RZB			1
SCLIP_DX		RZB			2
SCLIP_DY		RZB			2
SCLIP_ABSDX		RZB			2
SCLIP_ABSDY		RZB			2
