#version 330

${uniforms! }

layout(origin_upper_left) in vec4 gl_FragCoord;

uniform sampler2D image;
uniform vec4 fill;
uniform vec4 stroke;
uniform float strokeWeight;

flat in int v_instance;

${varyingIn! }

out vec4 o_color;

void main(void) {

    int instance = v_instance;
    vec3 boundsPosition = vec3(v_bounds.xy, 0.0);
    vec3 boundsSize = vec3(v_bounds.zw, 0.0);

    float imageMap = texture(image, v_texCoord0).r;
    vec4 x_fill = fill * imageMap;
    vec4 x_stroke = stroke;
    {
        ${fragmentTransform! }
    }
    o_color = x_fill;
}