/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.sketches;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.DropEvent;
import org.openrndr.KeyEvent;
import org.openrndr.Program;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.DepthTestPass;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.QuaternionKt;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.transforms.TransformsKt;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import studio.rndr.camera.CameraKey;
import studio.rndr.camera.CameraKeyframer;
import studio.rndr.camera.FirstPersonCamera;
import studio.rndr.camera.TweenMode;
import studio.rndr.modeling.ModelingKt;
import studio.rndr.post.PostProcessor;
import studio.rndr.screens.MapDrawerKt;
import studio.rndr.screens.MapScene;
import studio.rndr.sketches.RouteList;
import studio.rndr.sketches.Sketch019;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020cH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u001b\"\u0004\b.\u0010\u001dR\u001a\u0010/\u001a\u000200X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0012\"\u0004\bC\u0010\u0014R\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0006\"\u0004\bL\u0010\bR\u001a\u0010M\u001a\u00020NX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020TX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u0014\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\\\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\u0012\"\u0004\b^\u0010\u0014R\u001a\u0010_\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010\u001b\"\u0004\ba\u0010\u001d\u00a8\u0006e"}, d2={"Lstudio/rndr/sketches/Sketch019;", "Lorg/openrndr/Program;", "()V", "activeInterval", "", "getActiveInterval", "()D", "setActiveInterval", "(D)V", "activeTweenMode", "Lstudio/rndr/camera/TweenMode;", "getActiveTweenMode", "()Lstudio/rndr/camera/TweenMode;", "setActiveTweenMode", "(Lstudio/rndr/camera/TweenMode;)V", "box", "Lorg/openrndr/draw/VertexBuffer;", "getBox", "()Lorg/openrndr/draw/VertexBuffer;", "setBox", "(Lorg/openrndr/draw/VertexBuffer;)V", "boxTransforms", "getBoxTransforms", "setBoxTransforms", "boxVertexCount", "", "getBoxVertexCount", "()I", "setBoxVertexCount", "(I)V", "camera", "Lstudio/rndr/camera/FirstPersonCamera;", "getCamera", "()Lstudio/rndr/camera/FirstPersonCamera;", "cameraKeyFramer", "Lstudio/rndr/camera/CameraKeyframer;", "getCameraKeyFramer", "()Lstudio/rndr/camera/CameraKeyframer;", "font", "Lorg/openrndr/draw/FontImageMap;", "getFont", "()Lorg/openrndr/draw/FontImageMap;", "setFont", "(Lorg/openrndr/draw/FontImageMap;)V", "frame", "getFrame", "setFrame", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "getGbuffer", "()Lorg/openrndr/draw/RenderTarget;", "setGbuffer", "(Lorg/openrndr/draw/RenderTarget;)V", "postProcessor", "Lstudio/rndr/post/PostProcessor;", "getPostProcessor", "()Lstudio/rndr/post/PostProcessor;", "setPostProcessor", "(Lstudio/rndr/post/PostProcessor;)V", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "getPreviousViewMatrix", "()Lorg/openrndr/math/Matrix44;", "setPreviousViewMatrix", "(Lorg/openrndr/math/Matrix44;)V", "randomMesh", "getRandomMesh", "setRandomMesh", "replayAnimation", "", "getReplayAnimation", "()Z", "setReplayAnimation", "(Z)V", "replayStart", "getReplayStart", "setReplayStart", "result", "Lorg/openrndr/draw/ColorBuffer;", "getResult", "()Lorg/openrndr/draw/ColorBuffer;", "setResult", "(Lorg/openrndr/draw/ColorBuffer;)V", "routeTable", "Lorg/openrndr/draw/BufferTexture;", "getRouteTable", "()Lorg/openrndr/draw/BufferTexture;", "setRouteTable", "(Lorg/openrndr/draw/BufferTexture;)V", "routes", "", "Lorg/openrndr/shape/ShapeContour;", "transforms", "getTransforms", "setTransforms", "vertexCount", "getVertexCount", "setVertexCount", "draw", "", "setup", "demo-paddock"})
public final class Sketch019
extends Program {
    @NotNull
    public VertexBuffer randomMesh;
    @NotNull
    public VertexBuffer transforms;
    @NotNull
    public VertexBuffer box;
    @NotNull
    public VertexBuffer boxTransforms;
    private int boxVertexCount;
    private int vertexCount;
    @NotNull
    public PostProcessor postProcessor;
    @NotNull
    public ColorBuffer result;
    @NotNull
    public RenderTarget gbuffer;
    @NotNull
    public BufferTexture routeTable;
    @NotNull
    private final FirstPersonCamera camera = new FirstPersonCamera();
    @NotNull
    private Matrix44 previousViewMatrix = Matrix44.Companion.getIDENTITY();
    @NotNull
    private final CameraKeyframer cameraKeyFramer = new CameraKeyframer();
    @NotNull
    private TweenMode activeTweenMode = TweenMode.EXPO_STAIR_4;
    private double activeInterval = 1.0;
    private boolean replayAnimation;
    private double replayStart;
    @NotNull
    public FontImageMap font;
    private List<ShapeContour> routes;
    private int frame;

    @NotNull
    public final VertexBuffer getRandomMesh() {
        VertexBuffer vertexBuffer = this.randomMesh;
        if (vertexBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("randomMesh");
        }
        return vertexBuffer;
    }

    public final void setRandomMesh(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.randomMesh = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getTransforms() {
        VertexBuffer vertexBuffer = this.transforms;
        if (vertexBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("transforms");
        }
        return vertexBuffer;
    }

    public final void setTransforms(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.transforms = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getBox() {
        VertexBuffer vertexBuffer = this.box;
        if (vertexBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("box");
        }
        return vertexBuffer;
    }

    public final void setBox(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.box = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getBoxTransforms() {
        VertexBuffer vertexBuffer = this.boxTransforms;
        if (vertexBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("boxTransforms");
        }
        return vertexBuffer;
    }

    public final void setBoxTransforms(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.boxTransforms = vertexBuffer;
    }

    public final int getBoxVertexCount() {
        return this.boxVertexCount;
    }

    public final void setBoxVertexCount(int n) {
        this.boxVertexCount = n;
    }

    public final int getVertexCount() {
        return this.vertexCount;
    }

    public final void setVertexCount(int n) {
        this.vertexCount = n;
    }

    @NotNull
    public final PostProcessor getPostProcessor() {
        PostProcessor postProcessor = this.postProcessor;
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("postProcessor");
        }
        return postProcessor;
    }

    public final void setPostProcessor(@NotNull PostProcessor postProcessor) {
        Intrinsics.checkParameterIsNotNull(postProcessor, "<set-?>");
        this.postProcessor = postProcessor;
    }

    @NotNull
    public final ColorBuffer getResult() {
        ColorBuffer colorBuffer = this.result;
        if (colorBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        return colorBuffer;
    }

    public final void setResult(@NotNull ColorBuffer colorBuffer) {
        Intrinsics.checkParameterIsNotNull(colorBuffer, "<set-?>");
        this.result = colorBuffer;
    }

    @NotNull
    public final RenderTarget getGbuffer() {
        RenderTarget renderTarget = this.gbuffer;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        return renderTarget;
    }

    public final void setGbuffer(@NotNull RenderTarget renderTarget) {
        Intrinsics.checkParameterIsNotNull(renderTarget, "<set-?>");
        this.gbuffer = renderTarget;
    }

    @NotNull
    public final BufferTexture getRouteTable() {
        BufferTexture bufferTexture = this.routeTable;
        if (bufferTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException("routeTable");
        }
        return bufferTexture;
    }

    public final void setRouteTable(@NotNull BufferTexture bufferTexture) {
        Intrinsics.checkParameterIsNotNull(bufferTexture, "<set-?>");
        this.routeTable = bufferTexture;
    }

    @NotNull
    public final FirstPersonCamera getCamera() {
        return this.camera;
    }

    @NotNull
    public final Matrix44 getPreviousViewMatrix() {
        return this.previousViewMatrix;
    }

    public final void setPreviousViewMatrix(@NotNull Matrix44 matrix44) {
        Intrinsics.checkParameterIsNotNull(matrix44, "<set-?>");
        this.previousViewMatrix = matrix44;
    }

    @NotNull
    public final CameraKeyframer getCameraKeyFramer() {
        return this.cameraKeyFramer;
    }

    @NotNull
    public final TweenMode getActiveTweenMode() {
        return this.activeTweenMode;
    }

    public final void setActiveTweenMode(@NotNull TweenMode tweenMode) {
        Intrinsics.checkParameterIsNotNull((Object)tweenMode, "<set-?>");
        this.activeTweenMode = tweenMode;
    }

    public final double getActiveInterval() {
        return this.activeInterval;
    }

    public final void setActiveInterval(double d) {
        this.activeInterval = d;
    }

    public final boolean getReplayAnimation() {
        return this.replayAnimation;
    }

    public final void setReplayAnimation(boolean bl) {
        this.replayAnimation = bl;
    }

    public final double getReplayStart() {
        return this.replayStart;
    }

    public final void setReplayStart(double d) {
        this.replayStart = d;
    }

    @NotNull
    public final FontImageMap getFont() {
        FontImageMap fontImageMap = this.font;
        if (fontImageMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
        }
        return fontImageMap;
    }

    public final void setFont(@NotNull FontImageMap fontImageMap) {
        Intrinsics.checkParameterIsNotNull(fontImageMap, "<set-?>");
        this.font = fontImageMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setup() {
        Collection<ShapeContour> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        this.font = FontImageMap.Companion.fromUrl$default(FontImageMap.Companion, "file:data/fonts/IBMPLexMono-Bold.ttf", 16.0, 0.0, 4, null);
        this.result = DrawerKt.colorBuffer$default(this.getWidth(), this.getHeight(), null, null, 12, null);
        RouteList routePoints = new Gson().fromJson(FilesKt.readText$default(new File("data/routes-small-400-3.json"), null, 1, null), RouteList.class);
        Iterable iterable = routePoints.getValues();
        Sketch019 sketch019 = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            collection = destination$iv$iv;
            ShapeContour shapeContour = ShapeContour.Companion.fromPoints((List<Vector2>)it, false);
            collection.add(shapeContour);
        }
        collection = (List)destination$iv$iv;
        sketch019.routes = collection;
        List<ShapeContour> list = this.routes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("routes");
        }
        BufferTexture bufferTexture = this.routeTable = BufferTexture.Companion.create(list.size() * 256, ColorFormat.RGBa, ColorType.FLOAT32);
        if (bufferTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException("routeTable");
        }
        bufferTexture.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Iterable $receiver$iv = Sketch019.access$getRoutes$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    ShapeContour it = (ShapeContour)element$iv;
                    int n = 0;
                    int n2 = 256;
                    while (n < n2) {
                        void i;
                        $receiver.write(it.position((double)i / 255.0));
                        $receiver.write(0.0f, 0.0f);
                        ++i;
                    }
                }
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.gbuffer = DrawerKt.renderTarget(this.getWidth(), this.getHeight(), setup.3.INSTANCE);
        this.postProcessor = new PostProcessor(this.getWidth(), this.getHeight());
        MapScene map = MapDrawerKt.loadMapScene(new File("output.json"));
        VertexBuffer vertexBuffer = this.box = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(setup.4.INSTANCE), 80);
        if (vertexBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("box");
        }
        this.boxVertexCount = vertexBuffer.put(setup.5.INSTANCE);
        this.boxTransforms = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(setup.6.INSTANCE), 400000);
        VertexBuffer vertexBuffer2 = this.randomMesh = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(setup.7.INSTANCE), 600000);
        if (vertexBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("randomMesh");
        }
        this.vertexCount = vertexBuffer2.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(map){
            final /* synthetic */ MapScene $map;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BufferWriter $receiver) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                ModelingKt.extrudeContour$default(ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(this){
                    final /* synthetic */ setup.8 this$0;

                    public final void invoke(@NotNull ContourBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.moveTo(this.this$0.$map.getBounds().getCorner().minus(new Vector2(200.0, 200.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(this.this$0.$map.getBounds().getWidth() + 400.0, 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, this.this$0.$map.getBounds().getHeight() + 400.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(-(this.this$0.$map.getBounds().getWidth() + 400.0), 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, -(this.this$0.$map.getBounds().getHeight() + 400.0))));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), 300.0, 0.0, $receiver, false, false, 32, null);
                Random random = new Random(303808909L);
                Iterable iterable = $receiver$iv = (Iterable)this.$map.getBuildings();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                int index$iv$iv = 0;
                for (T item$iv$iv : $receiver$iv$iv) {
                    void idx;
                    void it;
                    int n = index$iv$iv++;
                    List list = (List)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    ModelingKt.extrudeContour$default(ShapeContour.Companion.fromPoints((List<Vector2>)it, true), 5.0 + random.nextDouble() * 50.0, (double)idx + 1.0, $receiver, true, false, 32, null);
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
            {
                this.$map = mapScene;
                super(1);
            }
        });
        this.transforms = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(setup.9.INSTANCE), 1000);
        this.camera.setPosition(new Vector3(0.0, 200.0, 100.0));
        this.camera.update();
        this.getMouse().getScrolled().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.getCamera().mouseScrolled(it);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getMouse().getMoved().listen(new Function1<Program.Mouse.MouseEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull Program.Mouse.MouseEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.getCamera().mouseMoved(it);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getWindow().getDrop().listen(new Function1<DropEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull DropEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String json = FilesKt.readText$default(CollectionsKt.first(it.getFiles()), null, 1, null);
                CameraKey[] cameraKeyArray = new Gson().fromJson(json, CameraKey[].class);
                Intrinsics.checkExpressionValueIsNotNull(cameraKeyArray, "Gson().fromJson(json, Ar\u2026y<CameraKey>::class.java)");
                List<Object> keys2 = ArraysKt.toList((Object[])cameraKeyArray);
                this.this$0.getCameraKeyFramer().getKeys().clear();
                this.this$0.getCameraKeyFramer().getKeys().addAll((Collection<CameraKey>)keys2);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.13.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                double last = -this.this$0.getActiveInterval();
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    last = CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getTime();
                }
                this.this$0.getCameraKeyFramer().getKeys().add(new CameraKey(this.this$0.getCamera().getPosition(), this.this$0.getCamera().getCameraQuat(), this.this$0.getCamera().getFov(), this.this$0.getCamera().getAperture(), this.this$0.getCamera().getFocalPlane(), this.this$0.getCamera().getFocalLength(), this.this$0.getCamera().getExposure(), this.this$0.getCamera().getCenterX(), this.this$0.getCamera().getCenterY(), last + this.this$0.getActiveInterval(), this.this$0.getActiveTweenMode()));
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.15.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.getCameraKeyFramer().getKeys().clear();
                this.this$0.setReplayAnimation(false);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.17.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Sketch019 sketch019 = this.this$0;
                double d = sketch019.getActiveInterval();
                sketch019.setActiveInterval(d + 1.0);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.19.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                Sketch019 sketch019 = this.this$0;
                double d = sketch019.getActiveInterval();
                sketch019.setActiveInterval(d + -1.0);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.21.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.setActiveTweenMode(TweenMode.values()[(this.this$0.getActiveTweenMode().ordinal() + 1) % ((Object[])TweenMode.values()).length]);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.23.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.setActiveTweenMode(TweenMode.values()[((this.this$0.getActiveTweenMode().ordinal() - 1) % ((Object[])TweenMode.values()).length + ((Object[])TweenMode.values()).length) % ((Object[])TweenMode.values()).length]);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.25.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCameraKeyFramer().getKeys().remove(CollectionsKt.getLastIndex(this.this$0.getCameraKeyFramer().getKeys()));
                }
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.27.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.this$0.setReplayAnimation(!this.this$0.getReplayAnimation());
                if (this.this$0.getReplayAnimation()) {
                    this.this$0.setReplayStart(this.this$0.getSeconds());
                }
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.29.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCamera().setCameraQuat(CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getOrientation());
                }
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.31.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (this.this$0.getCameraKeyFramer().getKeys().size() > 0) {
                    this.this$0.getCamera().setPosition(CollectionsKt.last(this.this$0.getCameraKeyFramer().getKeys()).getPosition());
                }
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        this.getKeyboard().getKeyDown().filter(setup.33.INSTANCE).listen(new Function1<KeyEvent, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull KeyEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                LocalDateTime dt = LocalDateTime.now();
                StringBuilder stringBuilder = new StringBuilder().append("camera-recording-");
                LocalDateTime localDateTime = dt;
                Intrinsics.checkExpressionValueIsNotNull(localDateTime, "dt");
                Month month = localDateTime.getMonth();
                Intrinsics.checkExpressionValueIsNotNull(month, "dt.month");
                File f = new File(stringBuilder.append(month.getValue()).append('-').append(dt.getDayOfMonth()).append('_').append(dt.getHour()).append('-').append(dt.getMinute()).append(".json").toString());
                String string = new GsonBuilder().setPrettyPrinting().create().toJson(this.this$0.getCameraKeyFramer().getKeys());
                Intrinsics.checkExpressionValueIsNotNull(string, "GsonBuilder().setPrettyP\u2026son(cameraKeyFramer.keys)");
                FilesKt.writeText$default(f, string, null, 2, null);
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
    }

    public final int getFrame() {
        return this.frame;
    }

    public final void setFrame(int n) {
        this.frame = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Drawer drawer = this.getDrawer();
        RenderTarget renderTarget = this.gbuffer;
        if (renderTarget == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        DrawerKt.isolatedWithTarget(drawer, renderTarget, (Function1<? super Drawer, Unit>)new Function1<Drawer, Unit>(this){
            final /* synthetic */ Sketch019 this$0;

            public final void invoke(@NotNull Drawer $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if (this.this$0.getReplayAnimation()) {
                    CameraKey frame = this.this$0.getCameraKeyFramer().frame((this.this$0.getSeconds() - this.this$0.getReplayStart()) * 1.9666666666666666);
                    this.this$0.getCamera().setPosition(frame.getPosition());
                    this.this$0.getCamera().setCameraQuat(frame.getOrientation());
                    this.this$0.getCamera().setFov(frame.getFov());
                    this.this$0.getCamera().setAperture(frame.getAperture());
                    this.this$0.getCamera().setFocalLength(frame.getFocalLength());
                    this.this$0.getCamera().setFocalPlane(frame.getFocalPlane());
                    this.this$0.getCamera().setExposure(frame.getExposure());
                    this.this$0.getCamera().setCenterX(frame.getCenterX());
                    this.this$0.getCamera().setCenterY(frame.getCenterY());
                    this.this$0.getCamera().update();
                }
                this.this$0.getDrawer().background(ColorRGBa.Companion.getPINK());
                this.this$0.getDrawer().perspective(this.this$0.getCamera().getFov(), (double)$receiver.getWidth() * 1.0 / (double)$receiver.getHeight(), 0.1, 1400.0);
                this.this$0.getDrawer().setProjection(TransformsKt.perspectiveDegrees(this.this$0.getCamera().getFov(), (double)$receiver.getWidth() * 1.0 / (double)$receiver.getHeight(), 0.1, 1400.0, this.this$0.getCamera().getCenterX() * 0.1, this.this$0.getCamera().getCenterY() * 0.1));
                this.this$0.getDrawer().setView(this.this$0.getCamera().getViewMatrix());
                this.this$0.getDrawer().translate(-500.0, -500.0, 0.0);
                this.this$0.getPostProcessor().setProjection(this.this$0.getDrawer().getProjection());
                this.this$0.getPostProcessor().setAperture(this.this$0.getCamera().getAperture());
                this.this$0.getPostProcessor().setFocalLength(this.this$0.getCamera().getFocalLength());
                this.this$0.getPostProcessor().setFocalPlane(this.this$0.getCamera().getFocalPlane());
                this.this$0.getPostProcessor().setExposure(this.this$0.getCamera().getExposure());
                this.this$0.getDrawer().setFill(ColorRGBa.Companion.getWHITE().shade(0.05));
                this.this$0.getDrawer().setDepthWrite(true);
                this.this$0.getDrawer().setDepthTestPass(DepthTestPass.LESS_OR_EQUAL);
                this.this$0.getDrawer().setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.parameter("time", this.this$0.this$0.getSeconds());
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                        $receiver.setVertexTransform("\n\n                    vec3 oldPosition = x_position +  (0.5+0.5*cos(objectId +.1*p_time-0.1/30.0)) * up * 40.0 * 0.0;\n                    oldPosition += (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * 0.0;\n                    x_position +=(cos(objectId + 0.1*p_time)*0.5+0.5) * up * 40.0 * 0.0;\n                    x_position +=  (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * 0.0;\n                    previousView = (p_previousViewMatrix * vec4( oldPosition, 1.0));\n                    vec4 pclip = projectionMatrix * previousView;\n                    //pclip.xyz /= pclip.w;\n                    previousClip = pclip;\n                    //x_position += x_normal*(cos(x_position.x+x_position.y+p_time)*10.0+10.0);\n                    currentClip = projectionMatrix * viewMatrix * vec4(x_position, 1.0);\n\n\n                ");
                        $receiver.setFragmentTransform("\n                    o_position.xyz = view.position;\n                    o_position.w = 1.0;\n                    o_normal.xyz = view.normal;\n                    o_normal.w = 1.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.05;\n                    //x_fill.rgb += (object.normal.z) * vec3(1.0, 1.05, 1.1) * (0.5+0.5*cos(object.position.x*0.01+0.01*object.position.y));\n                    //x_fill.rgb *= (sin(object.position.z*4.0)*0.5+0.5);\n                    x_fill.rgb *= cos(v_objectId+object.position.z*4.0)*0.5+0.5;\n                    x_fill.rgb /= max(1.0, -(view.position.z/10.0)-20.0);\n                    //x_fill.rgb += vec3(0.1);\n                    ");
                        $receiver.output("position", this.this$0.this$0.getGbuffer().colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.this$0.getGbuffer().colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.this$0.getGbuffer().colorBufferIndex("velocity"));
                        $receiver.parameter("previousViewMatrix", this.this$0.this$0.getPreviousViewMatrix());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                this.this$0.getDrawer().vertexBuffer(this.this$0.getRandomMesh(), DrawPrimitive.TRIANGLES, 0, this.this$0.getVertexCount());
                this.this$0.getDrawer().setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this){
                    final /* synthetic */ draw.1 this$0;

                    public final void invoke(@NotNull ShadeStyle $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.parameter("time", this.this$0.this$0.getSeconds());
                        $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                    out vec3 objPos;\n                ");
                        $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                    in vec3 objPos;\n                ");
                        $receiver.setVertexTransform("\n\n\n\n                    int path = (instance%3000);\n                    float fi = p_time*10.0;\n                    float pfi = fi - 10.0/30.0;\n\n                    int index0 = int(instance+int(fi)  )%256;\n                    int index1 = min(255, index0 + 1);\n                    int index2 = min(255, index0 + 2);\n                    float f = fi - int(fi);\n\n                    int pindex0 = int(instance+int(pfi)  )%256;\n                    int pindex1 = min(255, index0 + 1);\n                    int pindex2 = min(255, index0 + 2);\n                    float pf = pfi - int(pfi);\n\n\n                    vec3 ipos0 = texelFetch(p_positions, path*256+index0 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 ipos1 = texelFetch(p_positions, path*256+index1 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 ipos2 = texelFetch(p_positions, path*256+index2 ).xyz;// + vec3(0.0, 0.0, 10.0);\n\n                    vec3 pipos0 = texelFetch(p_positions, path*256+pindex0 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 pipos1 = texelFetch(p_positions, path*256+pindex1 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 pipos2 = texelFetch(p_positions, path*256+pindex2 ).xyz;// + vec3(0.0, 0.0, 10.0);\n\n\n                    vec2 d0 = ipos1.xy - ipos0.xy;\n                    vec2 n0 = vec2(-d0.y, d0.x);\n\n                    vec2 d1 = ipos2.xy - ipos1.xy;\n                    vec2 n1 = vec2(-d1.y, d1.x);\n\n                    vec2 pd0 = pipos1.xy - pipos0.xy;\n                    vec2 pn0 = vec2(-pd0.y, pd0.x);\n\n                    vec2 pd1 = pipos2.xy - pipos1.xy;\n                    vec2 pn1 = vec2(-pd1.y, pd1.x);\n\n\n\n                    float sf = smoothstep(0.0, 1.0, f);\n                    vec2 d = (1.0-sf) * d0 + sf * d1;\n                    vec2 n = (1.0-sf) * n0 + sf * n1;\n\n                    float psf = smoothstep(0.0, 1.0, pf);\n                    vec2 pd = (1.0-psf) * pd0 + psf * pd1;\n                    vec2 pn = (1.0-psf) * pn0 + psf * pn1;\n\n\n\n                    mat3 tbn = mat3( vec3(normalize(n), 0.0), vec3(normalize(d), 0.0), vec3(0.0, 0.0, 1.0));\n                    mat3 ptbn = mat3( vec3(normalize(pn), 0.0), vec3(normalize(pd), 0.0), vec3(0.0, 0.0, 1.0));\n\n\n                    float ifi = mod(instance + fi,256.0);\n                    x_position.z+=0.75/4.0;\n                    x_position.y *= smoothstep(0.0, 2.0, ifi) * smoothstep(255,253, ifi);\n                    objPos = x_position;\n                    x_position = tbn * x_position;\n                    vec3 pposition = ptbn * x_position;\n\n\n                    x_position += ipos0 * (1.0-f) + ipos1 * f;\n                    x_position.xy += cos(instance)*n*2.0;\n                    x_position.z += cos(instance)*10.0 + 20.0;\n\n                    pposition += pipos0 * (1.0-pf) + pipos1 * pf;\n                    pposition.xy += cos(instance)*pn*2.0;\n                    pposition.z += cos(instance)*10.0 + 20.0;\n\n\n                    currentClip = projectionMatrix * x_viewMatrix *   vec4(x_position, 1.0);\n\n\n                    previousView = (p_previousViewMatrix * vec4( pposition, 1.0));\n                    vec4 pclip = projectionMatrix * previousView;\n                    previousClip = pclip;\n\n\n\n                ");
                        $receiver.setFragmentTransform("\n                    o_position.xyz = view.position;\n                    o_position.w = 1.0;\n                    o_normal.xyz = view.normal;\n                    o_normal.w = 0.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.5;\n                    x_fill.rgb += vec3(4.0) * max(0.0, objPos.y);\n                    //x_fill.rgb += (object.normal.z) * vec3(1.0, 1.05, 1.1) * (0.5+0.5*cos(object.position.x*0.01+0.01*object.position.y));\n                    //x_fill.rgb *= (sin(object.position.z*4.0)*0.5+0.5);\n                    //x_fill.rgb *= cos(v_objectId+object.position.z*4.0)*0.5+0.5;\n                    x_fill.rgb *= cos(v_instance)*0.5+0.5;;\n                    x_fill.rgb /= max(1.0, -(view.position.z/10.0)-20.0);\n\n                    ");
                        $receiver.output("position", this.this$0.this$0.getGbuffer().colorBufferIndex("position"));
                        $receiver.output("normal", this.this$0.this$0.getGbuffer().colorBufferIndex("normal"));
                        $receiver.output("velocity", this.this$0.this$0.getGbuffer().colorBufferIndex("velocity"));
                        $receiver.parameter("previousViewMatrix", this.this$0.this$0.getPreviousViewMatrix());
                        $receiver.parameter("positions", this.this$0.this$0.getRouteTable());
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                this.this$0.setPreviousViewMatrix(this.this$0.getDrawer().getView());
                double idx = 0.0;
                this.this$0.getDrawer().setFill(ColorRGBa.Companion.getPINK().toLinear());
                this.this$0.getDrawer().vertexBufferInstances(CollectionsKt.listOf(this.this$0.getBox()), CollectionsKt.emptyList(), DrawPrimitive.TRIANGLES, this.this$0.getBoxTransforms().getVertexCount(), 0, this.this$0.getBoxVertexCount());
                $receiver.setFill(ColorRGBa.Companion.getBLACK());
            }
            {
                this.this$0 = sketch019;
                super(1);
            }
        });
        PostProcessor postProcessor = this.postProcessor;
        if (postProcessor == null) {
            Intrinsics.throwUninitializedPropertyAccessException("postProcessor");
        }
        RenderTarget renderTarget2 = this.gbuffer;
        if (renderTarget2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gbuffer");
        }
        ColorBuffer colorBuffer = this.result;
        if (colorBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        PostProcessor.apply$default(postProcessor, renderTarget2, colorBuffer, 0.0, 4, null);
        Drawer drawer2 = this.getDrawer();
        ColorBuffer colorBuffer2 = this.result;
        if (colorBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("result");
        }
        drawer2.image(colorBuffer2);
        int n = this.frame;
        this.frame = n + 1;
        Drawer drawer3 = this.getDrawer();
        FontImageMap fontImageMap = this.font;
        if (fontImageMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("font");
        }
        drawer3.setFontMap(fontImageMap);
        this.getDrawer().setFill(new ColorRGBa(1.0, 0.5, 0.0, 0.0, null, 24, null));
        this.getDrawer().text("aperture: " + this.camera.getAperture(), 40.0, 100.0);
        this.getDrawer().text("exposure: " + this.camera.getExposure(), 40.0, 120.0);
        this.getDrawer().text("focal plane: " + this.camera.getFocalPlane(), 40.0, 140.0);
        this.getDrawer().text("focal length: " + this.camera.getFocalLength(), 40.0, 160.0);
        this.getDrawer().text("fov: " + this.camera.getFov(), 40.0, 180.0);
        this.getDrawer().text("center: " + this.camera.getCenterX() + ' ' + this.camera.getCenterY(), 40.0, 200.0);
        this.getDrawer().text("tween: " + this.activeTweenMode.name(), 40.0, 220.0);
        this.getDrawer().text("interval: " + this.activeInterval, 40.0, 240.0);
        if (this.cameraKeyFramer.getKeys().size() > 0) {
            CameraKey last = CollectionsKt.last(this.cameraKeyFramer.getKeys());
            this.getDrawer().text("last: " + last.getTime(), 40.0, 260.0);
            this.getDrawer().text("distance from last: " + this.camera.getPosition().minus(last.getPosition()).getLength(), 40.0, 280.0);
            this.getDrawer().text("rotation from last: " + QuaternionKt.dot(this.camera.getCameraQuat().getNormalized(), last.getOrientation().getNormalized()), 40.0, 300.0);
        }
        Iterable iterable = $receiver$iv = (Iterable)this.cameraKeyFramer.getKeys();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            CameraKey cameraKey = (CameraKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            double x = it.getTime() % 16.0 * 16.0 + (double)(this.getWidth() - 300);
            double y = Math.floor(it.getTime() / 16.0) * 16.0 + 100.0;
            Vector2 vector2 = new Vector2(x, y);
            collection.add(vector2);
        }
        List circles = (List)destination$iv$iv;
        this.getDrawer().circles((List<Vector2>)circles, 6.0);
    }

    @NotNull
    public static final /* synthetic */ List access$getRoutes$p(Sketch019 $this) {
        List<ShapeContour> list = $this.routes;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("routes");
        }
        return list;
    }

    public static final /* synthetic */ void access$setRoutes$p(Sketch019 $this, @NotNull List list) {
        $this.routes = list;
    }
}

